/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsColumn;
import de.andreasroerig.fits.FitsData;
import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsHeader;
import de.andreasroerig.fits.FitsKeyword;
import java.io.DataInput;
import java.util.Enumeration;
import java.util.Vector;

public class FitsTable
extends FitsData {
    private Vector columns;
    private int noRows;

    public FitsTable(FitsHeader header, DataInput file, boolean sflag) throws FitsException {
        super(header, file, sflag);
        if (this.bitpix != 8 || this.noParm < 0 || this.noGroup != 1) {
            throw new FitsException("Incompatible TABLE header", 4);
        }
        FitsKeyword kw = header.getKeyword("TFIELDS");
        if (kw == null) {
            throw new FitsException("Missing TFIELDS keyword", 4);
        }
        int ncol = kw.getInt();
        this.columns = new Vector(ncol);
        int recordSize = this.naxis[0];
        this.noRows = this.naxis[1];
        kw = header.getKeyword("THEAP");
        long heapOffset = kw == null ? 0 : kw.getInt();
        int npos = 0;
        int n = 1;
        while (n <= ncol) {
            kw = header.getKeyword("TFORM" + n);
            if (kw == null) {
                throw new FitsException("Missing TFORMn keyword", 4);
            }
            String tform = kw.getString();
            if (this.type == 3) {
                kw = header.getKeyword("TBCOL" + n);
                if (kw == null) {
                    throw new FitsException("Missing TBCOLn keyword", 4);
                }
                npos = kw.getInt();
            }
            String ttype = (kw = header.getKeyword("TTYPE" + n)) == null ? "Label" + n : kw.getString();
            FitsColumn column = new FitsColumn(this.type, tform, ttype, this.noRows);
            if (this.isRAFile) {
                column.setData(this.dataFile, this.dataOffset, npos, recordSize);
            } else if (this.dataArray != null) {
                column.setData(this.dataArray, npos, recordSize);
            }
            if (this.type == 2) {
                npos += column.getWidth();
            }
            if ((kw = header.getKeyword("TZERO" + n)) != null) {
                column.setZero(kw.getReal());
            }
            if ((kw = header.getKeyword("TSCALE" + n)) != null) {
                column.setScale(kw.getReal());
            }
            if ((kw = header.getKeyword("TNULL" + n)) != null) {
                if (this.type == 2) {
                    column.setNull(kw.getInt());
                } else {
                    column.setNull(kw.getString());
                }
            }
            if ((kw = header.getKeyword("TUNIT" + n)) != null) {
                column.setUnit(kw.getString());
            }
            if ((kw = header.getKeyword("TDISP" + n)) != null) {
                column.setDisplay(kw.getString());
            }
            if ((kw = header.getKeyword("TDIM" + n)) != null) {
                column.setDim(kw.getString());
            }
            this.columns.addElement(column);
            ++n;
        }
    }

    public FitsHeader getHeader() {
        FitsHeader hdr = new FitsHeader();
        hdr.addKeyword(new FitsKeyword("XTENSION", "BINTABLE", "Bibary table extension"));
        hdr.addKeyword(new FitsKeyword("BITPIX", 8, "No. of bits per pixel"));
        hdr.addKeyword(new FitsKeyword("NAXIS", 2, "No. of axes in image"));
        int nb = 0;
        int n = 0;
        while (n < this.columns.size()) {
            ++n;
        }
        hdr.addKeyword(new FitsKeyword("NAXIS1", nb, "No. of bytes in row"));
        hdr.addKeyword(new FitsKeyword("NAXIS2", this.getNoRows(), "No. of rows in table"));
        hdr.addKeyword(new FitsKeyword("PCOUNT", this.noParm, "Size of heap area"));
        hdr.addKeyword(new FitsKeyword("GCOUNT", this.noGroup, "Group count"));
        hdr.addKeyword(new FitsKeyword("TFIELDS", this.getNoColumns(), "No. of columns in table"));
        return hdr;
    }

    public void addColumn(FitsColumn column) {
        this.columns.addElement(column);
    }

    public void insertColumnAt(FitsColumn column, int index) {
        this.columns.insertElementAt(column, index);
    }

    public void removeColumnAt(int index) {
        this.columns.removeElementAt(index);
    }

    public FitsColumn getColumn(int index) {
        if (index < 0 || this.columns.size() <= index) {
            return null;
        }
        Enumeration enumeration = this.columns.elements();
        while (index-- > 0) {
            enumeration.nextElement();
        }
        return (FitsColumn)enumeration.nextElement();
    }

    public FitsColumn getColumn(String label) {
        Enumeration enumeration = this.columns.elements();
        while (enumeration.hasMoreElements()) {
            FitsColumn col = (FitsColumn)enumeration.nextElement();
            if (!label.equalsIgnoreCase(col.getLabel())) continue;
            return col;
        }
        return null;
    }

    public int getNoColumns() {
        return this.columns.size();
    }

    public int getNoRows() {
        return this.noRows;
    }
}

