/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsFile;
import de.andreasroerig.fits.FitsHDUnit;
import de.andreasroerig.fits.FitsHeader;
import de.andreasroerig.fits.FitsKeyword;
import de.andreasroerig.fits.FitsMatrix;
import de.andreasroerig.util.SLogger;
import java.io.IOException;
import java.util.Enumeration;

public class FitsReader {
    private FitsFile file;
    private int noHDU;
    private FitsMatrix dm;
    private int noValues;
    private int noColumns;
    private int noRows;
    private String fname;

    public FitsReader(String fname) throws FitsException, IOException {
        this.fname = fname;
        this.file = new FitsFile(fname);
        this.noHDU = this.file.getNoHDUnits();
        int i = 0;
        while (i < this.noHDU) {
            FitsHDUnit hdu = this.file.getHDUnit(i);
            FitsHeader hdr = hdu.getHeader();
            int noKw = hdr.getNoKeywords();
            int type = hdr.getType();
            int size = (int)hdr.getDataSize();
            Enumeration enumeration = hdr.getKeywords();
            while (enumeration.hasMoreElements()) {
                FitsKeyword kw = (FitsKeyword)enumeration.nextElement();
                SLogger.debug("     " + kw.getName());
                switch (kw.getType()) {
                    case 1: {
                        SLogger.debug("(C) " + kw.getComment());
                        break;
                    }
                    case 2: {
                        SLogger.debug("(S)= '" + kw.getString() + "'");
                        break;
                    }
                    case 3: {
                        SLogger.debug("(B)= " + kw.getBool());
                        break;
                    }
                    case 4: {
                        SLogger.debug("(I)= " + kw.getInt());
                        break;
                    }
                    case 5: {
                        SLogger.debug("(R)= " + kw.getReal());
                        break;
                    }
                    case 6: {
                        SLogger.debug("(D)= " + kw.getString());
                    }
                }
                if (kw.getComment().length() <= 0 || kw.getType() == 1) continue;
                System.out.print(" / " + kw.getComment());
            }
            if (type == 1) {
                System.out.println("\n  Check data matrix - compute mean and rms");
                this.dm = (FitsMatrix)hdu.getData();
                this.noRows = this.dm.getNoRows();
                this.noColumns = this.dm.getNoColumns();
                this.noValues = this.dm.getNoValues();
            }
            ++i;
        }
    }

    public int[] getRow(int rowIdx) throws FitsException {
        return this.dm.getRow(rowIdx);
    }

    public int[][] getData() throws FitsException {
        int[][] data = new int[this.noRows][];
        int i = 0;
        while (i < this.noRows) {
            data[i] = this.dm.getRow(i);
            ++i;
        }
        return data;
    }

    public FitsMatrix getDm() {
        return this.dm;
    }

    public void setDm(FitsMatrix dm) {
        this.dm = dm;
    }

    public FitsFile getFile() {
        return this.file;
    }

    public void setFile(FitsFile file) {
        this.file = file;
    }

    public int getNoColumns() {
        return this.noColumns;
    }

    public void setNoColumns(int noColumns) {
        this.noColumns = noColumns;
    }

    public int getNoHDU() {
        return this.noHDU;
    }

    public void setNoHDU(int noHDU) {
        this.noHDU = noHDU;
    }

    public int getNoRows() {
        return this.noRows;
    }

    public void setNoRows(int noRows) {
        this.noRows = noRows;
    }

    public int getNoValues() {
        return this.noValues;
    }

    public void setNoValues(int noValues) {
        this.noValues = noValues;
    }

    public String getFname() {
        return this.fname;
    }
}

