/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsData;
import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsHeader;
import de.andreasroerig.fits.FitsKeyword;
import de.andreasroerig.fits.FitsWCS;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

public class FitsRGroup
extends FitsData {
    private int noValues;
    private int dataFormat = -32;
    private int bytesPerData = 4;
    private boolean scaling = false;
    private double zero = 0.0;
    private double scale = 1.0;
    private FitsWCS wcs;

    public FitsRGroup(FitsHeader header, DataInput file, boolean sflag) throws FitsException {
        super(header, file, sflag);
        if (this.type != 4) {
            throw new FitsException("Wrong header type", 4);
        }
        int nax = this.naxis.length;
        FitsKeyword kw = header.getKeyword("BITPIX");
        if (kw == null || kw.getType() != 4) {
            throw new FitsException("Invalid or missing BITPIX", 4);
        }
        this.dataFormat = kw.getInt();
        this.bytesPerData = Math.abs(this.dataFormat) / 8;
        this.noValues = (int)(this.size / (long)this.bytesPerData);
        this.wcs = new FitsWCS(header);
        kw = header.getKeyword("BSCALE");
        if (kw != null) {
            this.scale = kw.getReal();
            if (this.scale != 1.0) {
                this.scaling = true;
            }
        }
        if ((kw = header.getKeyword("BZERO")) != null) {
            this.zero = kw.getReal();
            if (this.zero != 0.0) {
                this.scaling = true;
            }
        }
    }

    public FitsHeader getHeader() {
        FitsHeader hdr = new FitsHeader();
        hdr.addKeyword(new FitsKeyword("SIMPLE", true, "Standard FITS format; NOST 100-2.0"));
        hdr.addKeyword(new FitsKeyword("BITPIX", this.bitpix, "No. of bits per pixel"));
        hdr.addKeyword(new FitsKeyword("NAXIS", this.naxis.length + 1, "No. of axes in image"));
        hdr.addKeyword(new FitsKeyword("NAXIS1", 0, "Random Groups convension"));
        int n = 2;
        while (n <= this.naxis.length + 1) {
            hdr.addKeyword(new FitsKeyword("NAXIS" + n, this.naxis[n - 2], "No. of pixels"));
            ++n;
        }
        hdr.addKeyword(new FitsKeyword("PCOUNT", this.noParm, "Parameter count"));
        hdr.addKeyword(new FitsKeyword("GCOUNT", this.noGroup, "Group count"));
        hdr.addKeyword(new FitsKeyword("GROUPS", true, "Random Groups format"));
        return hdr;
    }

    public short[] getShortValues(int offset, int size, short[] data) throws FitsException {
        if (offset < 0 || size < 1) {
            return data;
        }
        if (this.noValues < offset + size) {
            size = this.noValues - offset;
        }
        if (data == null || data.length < size) {
            data = new short[size];
        }
        int n = 0;
        DataInputStream dis = this.getStream(offset, size);
        try {
            switch (this.dataFormat) {
                case 8: {
                    while (n < size) {
                        data[n++] = (short)dis.readUnsignedByte();
                    }
                    break;
                }
                case 16: {
                    while (n < size) {
                        data[n++] = dis.readShort();
                    }
                    break;
                }
                case 32: {
                    while (n < size) {
                        data[n++] = (short)dis.readInt();
                    }
                    break;
                }
                default: {
                    return data;
                }
            }
        }
        catch (IOException e) {
            throw new FitsException("Cannot convert data", 5);
        }
        if (this.scaling) {
            int i = 0;
            while (i < n) {
                data[i] = (short)(this.scale * (double)data[i] + this.zero);
                ++i;
            }
        }
        return data;
    }

    public int[] getFloatValues(int offset, int size, int[] data) throws FitsException {
        if (offset < 0 || size < 1) {
            return data;
        }
        if (this.noValues < offset + size) {
            size = this.noValues - offset;
        }
        if (data == null || data.length < size) {
            data = new int[size];
        }
        int n = 0;
        DataInputStream dis = this.getStream(offset, size);
        try {
            switch (this.dataFormat) {
                case 8: {
                    while (n < size) {
                        data[n++] = dis.readUnsignedByte();
                    }
                    break;
                }
                case 16: {
                    while (n < size) {
                        data[n++] = dis.readShort();
                    }
                    break;
                }
                case 32: {
                    while (n < size) {
                        data[n++] = dis.readInt();
                    }
                    break;
                }
                default: {
                    return data;
                }
            }
        }
        catch (IOException e) {
            throw new FitsException("Cannot convert data", 5);
        }
        if (this.scaling) {
            int i = 0;
            while (i < n) {
                data[i] = (int)(this.scale * (double)data[i] + this.zero);
                ++i;
            }
        }
        return data;
    }

    public float[] getFloatValues(int offset, int size, float[] data) throws FitsException {
        if (offset < 0 || size < 1) {
            return data;
        }
        if (this.noValues < offset + size) {
            size = this.noValues - offset;
        }
        if (data == null || data.length < size) {
            data = new float[size];
        }
        int n = 0;
        DataInputStream dis = this.getStream(offset, size);
        try {
            switch (this.dataFormat) {
                case 8: {
                    while (n < size) {
                        data[n++] = dis.readUnsignedByte();
                    }
                    break;
                }
                case 16: {
                    while (n < size) {
                        data[n++] = dis.readShort();
                    }
                    break;
                }
                case 32: {
                    while (n < size) {
                        data[n++] = dis.readInt();
                    }
                    break;
                }
                case -32: {
                    while (n < size) {
                        data[n++] = dis.readFloat();
                    }
                    break;
                }
                case -64: {
                    while (n < size) {
                        data[n++] = (float)dis.readDouble();
                    }
                    break;
                }
                default: {
                    return data;
                }
            }
        }
        catch (IOException e) {
            throw new FitsException("Cannot convert data", 5);
        }
        if (this.scaling) {
            int i = 0;
            while (i < n) {
                data[i] = (float)(this.scale * (double)data[i] + this.zero);
                ++i;
            }
        }
        return data;
    }

    private DataInputStream getStream(int offset, int size) throws FitsException {
        DataInputStream di;
        try {
            this.dataFile.seek(this.dataOffset + (long)(offset * this.bytesPerData));
            if (this.noValues < offset + size) {
                size = this.noValues - offset;
            }
            byte[] dbuf = new byte[size * this.bytesPerData];
            this.dataFile.read(dbuf);
            di = new DataInputStream(new ByteArrayInputStream(dbuf));
        }
        catch (IOException e) {
            throw new FitsException("Cannot read data", 5);
        }
        return di;
    }

    public int getNoValues() {
        return this.noValues;
    }

    public double[] getCrpix() {
        return this.wcs.crpix;
    }

    public double[] getCrval() {
        return this.wcs.crval;
    }

    public double[] getCdelt() {
        return this.wcs.cdelt;
    }

    public FitsWCS getWCS() {
        return this.wcs;
    }

    public double[] toWCS(double[] pix) {
        return this.wcs.toWCS(pix);
    }

    public double[] toPixel(double[] wc) {
        return this.wcs.toPixel(wc);
    }
}

