/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.fits;

import de.andreasroerig.fits.FitsData;
import de.andreasroerig.fits.FitsException;
import de.andreasroerig.fits.FitsHeader;
import de.andreasroerig.fits.FitsMatrix;
import de.andreasroerig.fits.FitsRGroup;
import de.andreasroerig.fits.FitsTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FitsHDUnit {
    private FitsHeader header;
    private FitsData data;
    private boolean changeHeader = false;
    private long headerOffset = 0L;
    private RandomAccessFile headerFile = null;

    public FitsHDUnit(DataInput file, boolean sflag) throws FitsException {
        if (file instanceof RandomAccessFile) {
            this.headerFile = (RandomAccessFile)file;
            try {
                this.headerOffset = this.headerFile.getFilePointer();
            }
            catch (IOException e) {
                throw new FitsException("Cannot read header offset", 1);
            }
        }
        this.header = new FitsHeader(file);
        int type = this.header.getType();
        switch (type) {
            case 1: {
                this.data = new FitsMatrix(this.header, file, sflag);
                break;
            }
            case 2: 
            case 3: {
                this.data = new FitsTable(this.header, file, sflag);
                break;
            }
            case 4: {
                this.data = new FitsRGroup(this.header, file, sflag);
            }
        }
        this.changeHeader = false;
    }

    public FitsHDUnit(FitsHeader header, FitsData data) throws FitsException {
        this.header = header;
        this.data = data;
        this.changeHeader = true;
    }

    public int getType() {
        return this.header.getType();
    }

    public boolean canSave() {
        if (this.changeHeader || this.headerFile == null) {
            return false;
        }
        int nfill = this.header.getHeaderSpace() - this.header.getNoKeywords() - 1;
        return nfill >= 0;
    }

    protected void saveFile(RandomAccessFile file) throws IOException, FitsException {
        if (this.changeHeader) {
            throw new FitsException("HD unit modified", 1);
        }
        if (this.headerFile == null) {
            throw new FitsException("No header file", 1);
        }
        int nfill = this.header.getHeaderSpace() - this.header.getNoKeywords() - 1;
        if (nfill < 0) {
            throw new FitsException("No space in FITS header", 6);
        }
        file.seek(this.headerOffset);
        file.write(this.header.toString().getBytes());
        while (nfill-- > 0) {
            file.write("                                                                                ".getBytes());
        }
        file.write("END                                                                             ".getBytes());
    }

    public void writeFile(DataOutput file) throws IOException, FitsException {
        int nokw = this.header.getNoKeywords();
        if (nokw < 2) {
            throw new FitsException("Bad FITS header", 4);
        }
        file.write(this.header.toString().getBytes());
        int nfill = 36 * (nokw / 36 + 1) - nokw - 1;
        while (nfill-- > 0) {
            file.write("                                                                                ".getBytes());
        }
        file.write("END                                                                             ".getBytes());
        this.data.writeFile(file);
    }

    public void closeFile() {
        this.headerFile = null;
        this.data.closeFile();
    }

    public FitsData getData() {
        return this.data;
    }

    public FitsHeader getHeader() {
        return this.header;
    }
}

