/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.util;

import de.lehmannet.om.Eyepiece;
import de.lehmannet.om.Filter;
import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IFinding;
import de.lehmannet.om.IImager;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.Lens;
import de.lehmannet.om.OALException;
import de.lehmannet.om.Observation;
import de.lehmannet.om.Observer;
import de.lehmannet.om.RootElement;
import de.lehmannet.om.Scope;
import de.lehmannet.om.Session;
import de.lehmannet.om.Site;
import de.lehmannet.om.util.ConfigException;
import de.lehmannet.om.util.ConfigLoader;
import de.lehmannet.om.util.SchemaException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaLoader {
    public static final String[] VERSIONS = new String[]{"comast14.xsd", "comast15.xsd", "comast16.xsd", "comast17.xsd", "oal20.xsd", "oal21.xsd"};
    private IObservation[] observations = null;
    private ISession[] sessions = null;
    private ITarget[] targets = null;
    private IObserver[] observers = null;
    private ISite[] sites = null;
    private IScope[] scopes = null;
    private IEyepiece[] eyepieces = null;
    private IFilter[] filters = null;
    private IImager[] imagers = null;
    private ILens[] lenses = null;
    private HashMap doublicateTargets = new HashMap();
    private static ArrayList extensionClassLoaders = new ArrayList();

    public static ITarget getTargetFromXSIType(String xsiType, Node currentNode, IObserver[] observers) throws SchemaException {
        return (ITarget)SchemaLoader.getObjectFromXSIType(xsiType, currentNode, observers, 7);
    }

    public static IFinding getFindingFromXSIType(String xsiType, Node currentNode) throws SchemaException {
        return (IFinding)SchemaLoader.getObjectFromXSIType(xsiType, currentNode, null, 10);
    }

    public static IImager getImagerFromXSIType(String xsiType, Node currentNode) throws SchemaException {
        return (IImager)SchemaLoader.getObjectFromXSIType(xsiType, currentNode, null, 3);
    }

    public IObservation[] getObservations() {
        return this.observations;
    }

    public ISession[] getSessions() {
        return this.sessions;
    }

    public ITarget[] getTargets() {
        return this.targets;
    }

    public IObserver[] getObservers() {
        return this.observers;
    }

    public ISite[] getSites() {
        return this.sites;
    }

    public IScope[] getScopes() {
        return this.scopes;
    }

    public IEyepiece[] getEyepieces() {
        return this.eyepieces;
    }

    public IFilter[] getFilters() {
        return this.filters;
    }

    public ILens[] getLenses() {
        return this.lenses;
    }

    public IImager[] getImagers() {
        return this.imagers;
    }

    public RootElement load(File xmlFile, File schemaPath) throws OALException, SchemaException {
        if (xmlFile == null || !xmlFile.exists() || xmlFile.isDirectory()) {
            throw new OALException("XML file is null, does not exist or is directory. ");
        }
        File schemaFile = this.getSchemaFile(xmlFile, schemaPath);
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(true);
            dbf.setNamespaceAware(true);
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaFile.getAbsoluteFile());
            DocumentBuilder db = dbf.newDocumentBuilder();
            Validator handler = new Validator();
            db.setErrorHandler(handler);
            Document doc = db.parse(new FileInputStream(xmlFile), schemaFile.getAbsolutePath());
            return this.load(doc);
        }
        catch (SAXException sax) {
            throw new SchemaException("Unable to parse xml file: " + xmlFile.getAbsolutePath(), sax);
        }
        catch (IOException ioe) {
            throw new OALException("Unable to access xml file: " + xmlFile.getAbsolutePath(), (Throwable)ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new SchemaException("Parser configuration wrong: " + xmlFile.getAbsolutePath(), pce);
        }
    }

    public static void addClassloader(ClassLoader classloader) {
        if (classloader != null) {
            extensionClassLoaders.add(classloader);
        }
    }

    public RootElement load(Document doc) throws OALException, SchemaException {
        if (doc == null || !doc.hasChildNodes()) {
            throw new OALException("XML Schema is NULL or has no child nodes. ");
        }
        Element rootElement = doc.getDocumentElement();
        Node element = null;
        NodeList elementContainer = null;
        elementContainer = rootElement.getElementsByTagName("observers");
        if (elementContainer.getLength() != 1) {
            throw new OALException("Schema XML can only have one observers element. ");
        }
        element = elementContainer.item(0);
        this.observers = this.createObserverElements(element);
        elementContainer = rootElement.getElementsByTagName("targets");
        if (elementContainer.getLength() != 1) {
            throw new OALException("Schema XML can only have one targets element. ");
        }
        element = elementContainer.item(0);
        this.targets = this.createTargetElements(element, this.observers);
        elementContainer = rootElement.getElementsByTagName("sites");
        if (elementContainer.getLength() != 1) {
            throw new OALException("Schema XML can only have one sites element. ");
        }
        element = elementContainer.item(0);
        this.sites = this.createSiteElements(element);
        elementContainer = rootElement.getElementsByTagName("scopes");
        if (elementContainer.getLength() != 1) {
            throw new OALException("Schema XML can only have one scopes element. ");
        }
        element = elementContainer.item(0);
        this.scopes = this.createScopeElements(element);
        elementContainer = rootElement.getElementsByTagName("lenses");
        if (elementContainer.getLength() > 1) {
            throw new OALException("Schema XML can only have one lenses element. ");
        }
        element = elementContainer.item(0);
        this.lenses = this.createLensElements(element);
        elementContainer = rootElement.getElementsByTagName("eyepieces");
        if (elementContainer.getLength() != 1) {
            throw new OALException("Schema XML can only have one eyepieces element. ");
        }
        element = elementContainer.item(0);
        this.eyepieces = this.createEyepieceElements(element);
        elementContainer = rootElement.getElementsByTagName("filters");
        if (elementContainer.getLength() > 1) {
            throw new OALException("Schema XML can only have one filters element. ");
        }
        element = elementContainer.item(0);
        this.filters = this.createFilterElements(element);
        elementContainer = rootElement.getElementsByTagName("imagers");
        if (elementContainer.getLength() > 1) {
            throw new OALException("Schema XML can only have one imagers element. ");
        }
        if (elementContainer.getLength() == 1) {
            element = elementContainer.item(0);
            this.imagers = this.createImagerElements(element);
        }
        if ((elementContainer = rootElement.getElementsByTagName("sessions")).getLength() != 1) {
            throw new OALException("Schema XML can only have one sessions element. ");
        }
        element = elementContainer.item(0);
        this.sessions = this.createSessionElements(element);
        this.observations = this.createObservationElements(rootElement);
        this.removeDoublicateTargets();
        RootElement obs = new RootElement();
        for (int i = 0; i < this.observations.length; ++i) {
            obs.addObservation(this.observations[i]);
        }
        return obs;
    }

    private static Object getObjectFromXSIType(String xsiType, Node currentNode, IObserver[] observers, int schemaElementType) throws SchemaException {
        Class<?> currentClass;
        String classname;
        block15: {
            classname = null;
            try {
                classname = 10 == schemaElementType ? ConfigLoader.getFindingClassnameFromType(xsiType) : ConfigLoader.getTargetClassnameFromType(xsiType);
            }
            catch (ConfigException ce) {
                throw new SchemaException("Unable to get classname from xsi:type.\n" + ce.getMessage());
            }
            currentClass = null;
            try {
                currentClass = Class.forName(classname);
            }
            catch (ClassNotFoundException cnfe) {
                if (extensionClassLoaders.isEmpty()) break block15;
                ListIterator iterator = extensionClassLoaders.listIterator();
                while (iterator.hasNext()) {
                    try {
                        currentClass = ((ClassLoader)iterator.next()).loadClass(classname);
                        break;
                    }
                    catch (ClassNotFoundException cnfe2) {
                    }
                }
                if (currentClass != null) break block15;
                throw new SchemaException("Unable to load class for classname:" + classname);
            }
        }
        Constructor<?>[] constructors = currentClass.getConstructors();
        Object object = null;
        if (constructors.length > 0) {
            try {
                Class<?>[] parameters = null;
                for (int i = 0; i < constructors.length; ++i) {
                    parameters = constructors[i].getParameterTypes();
                    if (observers == null) {
                        if (parameters.length != 1 || !parameters[0].isInstance(currentNode)) continue;
                        object = constructors[i].newInstance(currentNode);
                    }
                    if (parameters.length != 2 || !parameters[0].isInstance(currentNode) || !parameters[1].isInstance(observers)) continue;
                    object = constructors[i].newInstance(currentNode, observers);
                }
            }
            catch (InstantiationException ie) {
                throw new SchemaException("Unable to instantiate class: " + classname + "\n" + ie.getMessage());
            }
            catch (InvocationTargetException ite) {
                throw new SchemaException("Unable to invocate class: " + classname + "\n" + ite.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new SchemaException("Unable to access class: " + classname + "\n" + iae.getMessage());
            }
        } else {
            throw new SchemaException("Unable to load class: " + classname + "\nMaybe class has no default constructor. ");
        }
        return object;
    }

    private IObservation[] createObservationElements(Node observations) throws SchemaException {
        Element e = (Element)observations;
        NodeList observationList = e.getElementsByTagName("observation");
        ArrayList<Observation> obs = new ArrayList<Observation>(observationList.getLength());
        for (int i = 0; i < observationList.getLength(); ++i) {
            try {
                obs.add(new Observation(observationList.item(i), this.targets, this.observers, this.sites, this.scopes, this.sessions, this.eyepieces, this.filters, this.imagers, this.lenses));
                continue;
            }
            catch (SchemaException se) {
                System.err.println((Object)((Object)se) + "\n\nContinue loading next observation...\n\n");
                continue;
            }
            catch (IllegalArgumentException iae) {
                System.err.println(iae + "\n\nContinue loading next observation...\n\n");
            }
        }
        return obs.toArray(new IObservation[0]);
    }

    private ITarget[] createTargetElements(Node targets, IObserver[] observers) throws SchemaException {
        Element e = (Element)targets;
        NodeList targetList = e.getElementsByTagName("target");
        ArrayList<ITarget> targetElements = new ArrayList<ITarget>(targetList.getLength());
        Node currentNode = null;
        Node attribute = null;
        for (int i = 0; i < targetList.getLength(); ++i) {
            currentNode = targetList.item(i);
            NamedNodeMap attributes = currentNode.getAttributes();
            if (attributes != null && attributes.getLength() != 0) {
                attribute = attributes.getNamedItem("xsi:type");
                if (attribute != null) {
                    String xsiType = attribute.getNodeValue();
                    ITarget object = null;
                    try {
                        object = SchemaLoader.getTargetFromXSIType(xsiType, currentNode, observers);
                    }
                    catch (SchemaException se) {
                        System.err.println((Object)((Object)se) + "\n\nContinue with next target element...\n\n");
                        continue;
                    }
                    if (object != null) {
                        ITarget currentTarget = null;
                        if (object instanceof ITarget) {
                            currentTarget = object;
                            int index = targetElements.indexOf(currentTarget);
                            if (index != -1) {
                                this.doublicateTargets.put(currentTarget, targetElements.get(index));
                            }
                            targetElements.add(currentTarget);
                            continue;
                        }
                        throw new SchemaException("Unable to load class of type: " + xsiType + "\nClass seems not to be of type ITarget. ");
                    }
                    throw new SchemaException("Unable to load class of type: " + xsiType);
                }
                throw new SchemaException("No attribute specified: xsi:type");
            }
            throw new SchemaException("No attribute specified: xsi:type");
        }
        return targetElements.toArray(new ITarget[0]);
    }

    private ISession[] createSessionElements(Node sessions) throws SchemaException {
        Element e = (Element)sessions;
        NodeList sessionList = e.getElementsByTagName("session");
        ISession[] sessionElements = new ISession[sessionList.getLength()];
        for (int i = 0; i < sessionList.getLength(); ++i) {
            sessionElements[i] = new Session(sessionList.item(i), this.observers, this.sites);
        }
        return sessionElements;
    }

    private IObserver[] createObserverElements(Node observers) throws SchemaException {
        Element e = (Element)observers;
        NodeList observerList = e.getElementsByTagName("observer");
        IObserver[] observerElements = new IObserver[observerList.getLength()];
        for (int i = 0; i < observerList.getLength(); ++i) {
            observerElements[i] = new Observer(observerList.item(i));
        }
        return observerElements;
    }

    private ISite[] createSiteElements(Node sites) throws SchemaException {
        Element e = (Element)sites;
        NodeList siteList = e.getElementsByTagName("site");
        ISite[] siteElements = new ISite[siteList.getLength()];
        for (int i = 0; i < siteList.getLength(); ++i) {
            siteElements[i] = new Site(siteList.item(i));
        }
        return siteElements;
    }

    private IScope[] createScopeElements(Node scopes) throws SchemaException {
        Element e = (Element)scopes;
        NodeList scopeList = e.getElementsByTagName("scope");
        IScope[] scopeElements = new IScope[scopeList.getLength()];
        for (int i = 0; i < scopeList.getLength(); ++i) {
            scopeElements[i] = new Scope(scopeList.item(i));
        }
        return scopeElements;
    }

    private IEyepiece[] createEyepieceElements(Node eyepieces) throws SchemaException {
        Element e = (Element)eyepieces;
        NodeList eyepieceList = e.getElementsByTagName("eyepiece");
        IEyepiece[] eyepieceElements = new IEyepiece[eyepieceList.getLength()];
        for (int i = 0; i < eyepieceList.getLength(); ++i) {
            eyepieceElements[i] = new Eyepiece(eyepieceList.item(i));
        }
        return eyepieceElements;
    }

    private ILens[] createLensElements(Node lenses) throws SchemaException {
        if (lenses == null) {
            return new ILens[0];
        }
        Element e = (Element)lenses;
        NodeList lensesList = e.getElementsByTagName("lens");
        ILens[] lensElements = new ILens[lensesList.getLength()];
        for (int i = 0; i < lensesList.getLength(); ++i) {
            lensElements[i] = new Lens(lensesList.item(i));
        }
        return lensElements;
    }

    private IFilter[] createFilterElements(Node filters) throws SchemaException {
        if (filters == null) {
            return new IFilter[0];
        }
        Element e = (Element)filters;
        NodeList filterList = e.getElementsByTagName("filter");
        IFilter[] filterElements = new IFilter[filterList.getLength()];
        for (int i = 0; i < filterList.getLength(); ++i) {
            filterElements[i] = new Filter(filterList.item(i));
        }
        return filterElements;
    }

    private IImager[] createImagerElements(Node imagers) throws SchemaException {
        Element e = (Element)imagers;
        NodeList imagerList = e.getElementsByTagName("imager");
        ArrayList<IImager> imagerElements = new ArrayList<IImager>(imagerList.getLength());
        Node currentNode = null;
        Node attribute = null;
        for (int i = 0; i < imagerList.getLength(); ++i) {
            currentNode = imagerList.item(i);
            NamedNodeMap attributes = currentNode.getAttributes();
            if (attributes != null && attributes.getLength() != 0) {
                attribute = attributes.getNamedItem("xsi:type");
                if (attribute != null) {
                    String xsiType = attribute.getNodeValue();
                    IImager object = null;
                    try {
                        object = SchemaLoader.getImagerFromXSIType(xsiType, currentNode);
                    }
                    catch (SchemaException se) {
                        System.err.println((Object)((Object)se) + "\n\nContinue with next imager element...\n\n");
                        continue;
                    }
                    if (object != null) {
                        IImager currentImager = null;
                        if (object instanceof IImager) {
                            currentImager = object;
                            imagerElements.add(currentImager);
                            continue;
                        }
                        throw new SchemaException("Unable to load class of type: " + xsiType + "\nClass seems not to be of type IImager. ");
                    }
                    throw new SchemaException("Unable to load class of type: " + xsiType);
                }
                throw new SchemaException("No attribute specified: xsi:type");
            }
            throw new SchemaException("No attribute specified: xsi:type");
        }
        return imagerElements.toArray(new IImager[0]);
    }

    private File getSchemaFile(File xmlFile, File schemaPath) throws OALException {
        FileReader reader = null;
        try {
            reader = new FileReader(xmlFile);
        }
        catch (FileNotFoundException fnf) {
            throw new OALException("XML file " + xmlFile + " cannot be found.\n" + fnf);
        }
        char[] buffer = new char[500];
        try {
            reader.read(buffer, 0, 500);
        }
        catch (IOException ioe) {
            throw new OALException("Cannot read XML file to determine schema version. File " + xmlFile + "\n" + ioe);
        }
        for (int i = 0; i < VERSIONS.length; ++i) {
            int index = new String(buffer).indexOf(VERSIONS[i]);
            if (index == -1) continue;
            return new File(schemaPath.getAbsolutePath() + File.separatorChar + VERSIONS[i]);
        }
        throw new OALException("Cannot determine schema version from XML file: " + xmlFile + "\n");
    }

    private void removeDoublicateTargets() {
        if (this.doublicateTargets.isEmpty() || this.observations.length <= 0) {
            return;
        }
        Iterator keyIterator = null;
        ITarget current = null;
        Object dT = null;
        for (int i = 0; i < this.observations.length; ++i) {
            current = this.observations[i].getTarget();
            if (current.getDatasource() == null) {
                // empty if block
            }
            keyIterator = this.doublicateTargets.keySet().iterator();
            while (keyIterator.hasNext()) {
                dT = keyIterator.next();
                if (!current.equalsID(dT)) continue;
                this.observations[i].setTarget((ITarget)this.doublicateTargets.get(dT));
            }
        }
        ArrayList<ITarget> targetElements = new ArrayList<ITarget>(Arrays.asList(this.targets));
        ListIterator<ITarget> iterator = targetElements.listIterator();
        while (iterator.hasNext()) {
            current = iterator.next();
            keyIterator = this.doublicateTargets.keySet().iterator();
            while (keyIterator.hasNext()) {
                dT = keyIterator.next();
                if (!current.equalsID(dT)) continue;
                iterator.remove();
            }
        }
        this.targets = targetElements.toArray(new ITarget[0]);
    }

    private class Validator
    extends DefaultHandler {
        private Validator() {
        }

        public void error(SAXParseException exception) throws SAXException {
            System.err.println("XML Schema error: " + exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            System.err.println("XML Schema fatal error: " + exception);
        }

        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("XML Schema warning: " + exception);
        }
    }
}

