/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.util;

import de.lehmannet.om.Angle;
import de.lehmannet.om.EquPosition;
import java.util.Calendar;

public class Ephemerides {
    public static final int SUN = 0;
    public static final int MERCURY = 1;
    public static final int VENUS = 2;
    public static final int MOON = 301;
    public static final int MARS = 4;
    public static final int JUPITER = 5;
    public static final int SATURN = 6;
    public static final int URANUS = 7;
    public static final int NEPTUNE = 8;
    private static final String KEY_SUN = "SUN";
    private static final String KEY_MERCURY = "MERCURY";
    private static final String KEY_VENUS = "VENUS";
    private static final String KEY_EARTH = "EARTH";
    private static final String KEY_MOON = "MOON";
    private static final String KEY_MARS = "MARS";
    private static final String KEY_JUPITER = "JUPITER";
    private static final String KEY_SATURN = "SATURN";
    private static final String KEY_URANUS = "URANUS";
    private static final String KEY_NEPTUNE = "NEPTUNE";

    public static int planetKey(String planet) {
        if (KEY_SUN.equals(planet)) {
            return 0;
        }
        if (KEY_MERCURY.equals(planet)) {
            return 1;
        }
        if (KEY_VENUS.equals(planet)) {
            return 2;
        }
        if (KEY_MOON.equals(planet)) {
            return 301;
        }
        if (KEY_MARS.equals(planet)) {
            return 4;
        }
        if (KEY_JUPITER.equals(planet)) {
            return 5;
        }
        if (KEY_SATURN.equals(planet)) {
            return 6;
        }
        if (KEY_URANUS.equals(planet)) {
            return 7;
        }
        if (KEY_NEPTUNE.equals(planet)) {
            return 8;
        }
        return -1;
    }

    public static EquPosition getPosition(int planet, Calendar date) {
        if (planet == 0) {
            return Ephemerides.getSunPosition(date);
        }
        if (planet == -1) {
            return null;
        }
        double[] geo = Ephemerides.getGeocentricPosition(planet, date);
        double ecl = Ephemerides.getObliquityOfTheEcliptic(date);
        ecl = Math.toRadians(ecl);
        double xe = geo[0];
        double ye = geo[1] * Math.cos(ecl) - geo[2] * Math.sin(ecl);
        double ze = geo[1] * Math.sin(ecl) + geo[2] * Math.cos(ecl);
        double RA = Math.atan2(ye, xe);
        double Dec = Math.atan2(ze, Math.sqrt(xe * xe + ye * ye));
        RA = Math.toDegrees(RA);
        Dec = Math.toDegrees(Dec);
        if (RA < 0.0) {
            RA = 360.0 + RA;
        }
        return new EquPosition(new Angle(RA, "deg"), new Angle(Dec, "deg"));
    }

    public static EquPosition getSunPosition(Calendar date) {
        double[] equRecPos = Ephemerides.getSunEquatorialRectangularGeocentric(date);
        double RA = Math.atan2(equRecPos[1], equRecPos[0]);
        double Dec = Math.atan2(equRecPos[2], Math.sqrt(equRecPos[0] * equRecPos[0] + equRecPos[1] * equRecPos[1]));
        RA = Math.toDegrees(RA);
        Dec = Math.toDegrees(Dec);
        if (RA < 0.0) {
            RA = 360.0 + RA;
        }
        return new EquPosition(new Angle(RA, "deg"), new Angle(Dec, "deg"));
    }

    public static EquPosition getMoonPosition(Calendar date, double geoLongitude) {
        double[] helioPos = Ephemerides.getHeliocentricPosition(301, date);
        double gcLat = helioPos[4] - 0.1924 * Math.sin(Math.toRadians(2.0 * helioPos[4]));
        gcLat = Math.toDegrees(gcLat);
        double rho = 0.99833 + 0.00167 * Math.cos(Math.toRadians(2.0 * helioPos[4]));
        rho = Math.toDegrees(rho);
        EquPosition equPos = Ephemerides.getPosition(301, date);
        double RA = equPos.getRaAngle().toDegree();
        double Dec = equPos.getDecAngle().toDegree();
        double HA = Ephemerides.getMoonHourAngle(date, geoLongitude);
        double g = Math.atan(Math.tan(Math.toRadians(gcLat)) / Math.cos(Math.toRadians(HA)));
        g = Math.toDegrees(g);
        double r = Ephemerides.getDistance(301, date);
        r = Ephemerides.getPerturbationsForMoonDistance(r, date);
        double mpar = Math.asin(Math.toRadians(1.0 / r));
        mpar = Math.toDegrees(mpar);
        double topRA = RA - mpar * rho * Math.cos(Math.toRadians(gcLat)) * Math.sin(Math.toRadians(HA)) / Math.cos(Math.toRadians(Dec));
        double topDecl = Dec - mpar * rho * Math.sin(Math.toRadians(gcLat)) * Math.sin(Math.toRadians(g - Dec)) / Math.sin(Math.toRadians(g));
        if (topRA < 0.0) {
            topRA = 360.0 + topRA;
        }
        return new EquPosition(new Angle(topRA, "deg"), new Angle(topDecl, "deg"));
    }

    public static boolean isMoonAboveHorizon(Calendar date, double geoLongitude, double geoLatitude) {
        EquPosition equPos = Ephemerides.getPosition(301, date);
        double Dec = equPos.getDecAngle().toDegree();
        double HA = Ephemerides.getMoonHourAngle(date, geoLongitude);
        double sinh = Math.sin(Math.toRadians(geoLatitude)) * Math.sin(Math.toRadians(Dec)) + Math.cos(Math.toRadians(geoLatitude)) * Math.cos(Math.toRadians(Dec)) * Math.cos(Math.toRadians(HA));
        double h = Math.asin(sinh);
        return (h = Math.toDegrees(h)) > 0.0;
    }

    public static double altitudeAboveHorizon(EquPosition equPos, Calendar date, double geoLongitude, double geoLatitude) {
        double Dec = equPos.getDecAngle().toDegree();
        double RA = equPos.getRaAngle().toDegree();
        double Ls = Ephemerides.getSunLongitude(date);
        double GMST0 = Ls + 180.0;
        double UT = (double)(date.get(11) - date.get(15) / 3600000) + (double)date.get(12) / 60.0;
        double LST = GMST0 + UT * 15.0 + geoLongitude;
        double HA = LST - RA;
        double sinh = Math.sin(Math.toRadians(geoLatitude)) * Math.sin(Math.toRadians(Dec)) + Math.cos(Math.toRadians(geoLatitude)) * Math.cos(Math.toRadians(Dec)) * Math.cos(Math.toRadians(HA));
        double h = Math.asin(sinh);
        h = Math.toDegrees(h);
        return h;
    }

    public static double getAzimut(EquPosition equPos, Calendar date, double geoLongitude, double geoLatitude) {
        double Dec = equPos.getDecAngle().toDegree();
        double RA = equPos.getRaAngle().toDegree();
        double Ls = Ephemerides.getSunLongitude(date);
        double GMST0 = Ls + 180.0;
        double UT = (double)(date.get(11) - date.get(15) / 3600000) + (double)date.get(12) / 60.0;
        double LST = GMST0 + UT * 15.0 + geoLongitude;
        double HA = LST - RA;
        double sinHA = Math.sin(Math.toRadians(HA));
        double Nnr = Math.cos(Math.toRadians(HA)) * Math.sin(Math.toRadians(geoLatitude)) - Math.tan(Math.toRadians(Dec)) * Math.cos(Math.toRadians(geoLatitude));
        double at = Math.atan2(sinHA, Nnr);
        at = Math.toDegrees(at);
        return (at += 180.0) % 360.0;
    }

    public static double getMoonPhase(Calendar date) {
        double currentPhase = Ephemerides.getMoonPhasePercentage(date);
        Calendar phaseTrendDate = (Calendar)date.clone();
        phaseTrendDate.add(11, 24);
        double trendPhase = Ephemerides.getMoonPhasePercentage(phaseTrendDate);
        if (currentPhase > trendPhase) {
            currentPhase *= -1.0;
        }
        return currentPhase;
    }

    private static double getMoonPhasePercentage(Calendar date) {
        double[] moonEcliptic = Ephemerides.getGeocentricPosition(301, date);
        double slon = Ephemerides.getSunLongitude(date);
        double mlon = moonEcliptic[3];
        double mlat = moonEcliptic[4];
        double elong = Math.acos(Math.cos(Math.toRadians(slon - mlon)) * Math.cos(Math.toRadians(mlat)));
        elong = Math.toDegrees(elong);
        double FV = 180.0 - elong;
        double phase = (1.0 + Math.cos(Math.toRadians(FV))) / 2.0;
        return phase;
    }

    private static double getMoonHourAngle(Calendar date, double geoLongitude) {
        EquPosition equPos = Ephemerides.getPosition(301, date);
        double RA = equPos.getRaAngle().toDegree();
        double Ls = Ephemerides.getSunLongitude(date);
        double GMST0 = Ls + 180.0;
        double UT = (double)(date.get(11) - date.get(15) / 3600000) + (double)date.get(12) / 60.0;
        double LST = GMST0 + UT * 15.0 + geoLongitude;
        double HA = LST - RA;
        return HA;
    }

    private static double[] getSunXY(int planet, Calendar date) {
        double e = Ephemerides.getEccentricity(planet, date);
        double E = Ephemerides.getEccentricAnomaly(planet, date);
        double xv = Math.cos(Math.toRadians(E)) - e;
        double yv = Math.sqrt(1.0 - e * e) * Math.sin(Math.toRadians(E));
        return new double[]{xv, yv};
    }

    private static double[] getXY(int planet, Calendar date) {
        double e = Ephemerides.getEccentricity(planet, date);
        double E = Ephemerides.getEccentricAnomaly(planet, date);
        double a = Ephemerides.getSemiMajorAxis(planet, date);
        double xv = a * (Math.cos(Math.toRadians(E)) - e);
        double yv = a * (Math.sqrt(1.0 - e * e) * Math.sin(Math.toRadians(E)));
        return new double[]{xv, yv};
    }

    private static double getDistance(int planet, Calendar date) {
        double[] XvYv = Ephemerides.getXY(planet, date);
        if (0 == planet) {
            XvYv = Ephemerides.getSunXY(planet, date);
        }
        double r = Math.sqrt(XvYv[0] * XvYv[0] + XvYv[1] * XvYv[1]);
        return r;
    }

    private static double getTrueAnomaly(int planet, Calendar date) {
        double[] XvYv = Ephemerides.getXY(planet, date);
        if (0 == planet) {
            XvYv = Ephemerides.getSunXY(planet, date);
        }
        double v = Math.atan2(XvYv[1], XvYv[0]);
        return Math.toDegrees(v);
    }

    private static double[] getSunEclipticRectangularGeocentric(Calendar date) {
        int planet = 0;
        double lonsun = Ephemerides.getSunLongitude(date);
        double r = Ephemerides.getDistance(planet, date);
        double xs = r * Math.cos(Math.toRadians(lonsun));
        double ys = r * Math.sin(Math.toRadians(lonsun));
        return new double[]{xs, ys};
    }

    private static double getSunLongitude(Calendar date) {
        int planet = 0;
        double lonsun = Ephemerides.getTrueAnomaly(planet, date) + Ephemerides.getArgumentOfPerihelion(planet, date);
        return lonsun;
    }

    private static double[] getSunEquatorialRectangularGeocentric(Calendar date) {
        double[] ecliptivRectangularGeocentric = Ephemerides.getSunEclipticRectangularGeocentric(date);
        double ecl = Ephemerides.getObliquityOfTheEcliptic(date);
        ecl = Math.toRadians(ecl);
        double xe = ecliptivRectangularGeocentric[0];
        double ye = ecliptivRectangularGeocentric[1] * Math.cos(ecl);
        double ze = ecliptivRectangularGeocentric[1] * Math.sin(ecl);
        return new double[]{xe, ye, ze};
    }

    private static double[] getHeliocentricPosition(int planet, Calendar date) {
        double r = Ephemerides.getDistance(planet, date);
        if (planet == 301) {
            double perturbationDist = 0.0;
            r = perturbationDist = Ephemerides.getPerturbationsForMoonDistance(r, date);
        }
        double N = Ephemerides.getLongitudeOfTheAscendingNode(planet, date);
        N = Math.toRadians(N);
        double v = Ephemerides.getTrueAnomaly(planet, date);
        v = Math.toRadians(v);
        double w = Ephemerides.getArgumentOfPerihelion(planet, date);
        w = Math.toRadians(w);
        double i = Ephemerides.getInclination(planet, date);
        i = Math.toRadians(i);
        double xh = r * (Math.cos(N) * Math.cos(v + w) - Math.sin(N) * Math.sin(v + w) * Math.cos(i));
        double yh = r * (Math.sin(N) * Math.cos(v + w) + Math.cos(N) * Math.sin(v + w) * Math.cos(i));
        double zh = r * (Math.sin(v + w) * Math.sin(i));
        double lonecl = Math.atan2(yh, xh);
        double latecl = Math.atan2(zh, Math.sqrt(xh * xh + yh * yh));
        lonecl = Math.toDegrees(lonecl);
        latecl = Math.toDegrees(latecl);
        switch (planet) {
            case 301: {
                double[] per = Ephemerides.getPerturbationsForMoon(lonecl, latecl, date);
                lonecl = per[0];
                latecl = per[1];
                xh = r * Math.cos(Math.toRadians(lonecl)) * Math.cos(Math.toRadians(latecl));
                yh = r * Math.sin(Math.toRadians(lonecl)) * Math.cos(Math.toRadians(latecl));
                zh = r * Math.sin(Math.toRadians(latecl));
            }
        }
        return new double[]{xh, yh, zh, lonecl, latecl};
    }

    private static double[] getGeocentricPosition(int planet, Calendar date) {
        double[] helio = Ephemerides.getHeliocentricPosition(planet, date);
        if (planet == 301) {
            return helio;
        }
        double rs = Ephemerides.getDistance(0, date);
        double lonsun = Ephemerides.getSunLongitude(date);
        lonsun = Math.toRadians(lonsun);
        double xs = rs * Math.cos(lonsun);
        double ys = rs * Math.sin(lonsun);
        double xg = helio[0] + xs;
        double yg = helio[1] + ys;
        double zg = helio[2];
        return new double[]{xg, yg, zg};
    }

    private static double getD(Calendar date) {
        int year = date.get(1);
        int month = date.get(2) + 1;
        int day = date.get(5);
        double time = date.get(11) / 24;
        double d = 367 * year - 7 * (year + (month + 9) / 12) / 4 + 275 * month / 9 + day - 730530;
        return d += time;
    }

    private static double getObliquityOfTheEcliptic(Calendar date) {
        double d = Ephemerides.getD(date);
        double ecl = 23.4393 - 3.563E-7 * d;
        return ecl;
    }

    private static double getLongitudeOfTheAscendingNode(int planet, Calendar date) {
        double d = Ephemerides.getD(date);
        switch (planet) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return 48.3313 + 3.24587E-5 * d;
            }
            case 2: {
                return 76.6799 + 2.4659E-5 * d;
            }
            case 301: {
                return 125.1228 - 0.0529538083 * d;
            }
            case 4: {
                return 49.5574 + 2.11081E-5 * d;
            }
            case 5: {
                return 100.4542 + 2.76854E-5 * d;
            }
            case 6: {
                return 113.6634 + 2.3898E-5 * d;
            }
            case 7: {
                return 74.0005 + 1.3978E-5 * d;
            }
            case 8: {
                return 131.7806 + 3.0173E-5 * d;
            }
        }
        return Double.NaN;
    }

    private static double getInclination(int planet, Calendar date) {
        double d = Ephemerides.getD(date);
        switch (planet) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return 7.0047 + 5.0E-8 * d;
            }
            case 2: {
                return 3.3946 + 2.75E-8 * d;
            }
            case 301: {
                return 5.1454;
            }
            case 4: {
                return 1.8497 - 1.78E-8 * d;
            }
            case 5: {
                return 1.303 - 1.557E-7 * d;
            }
            case 6: {
                return 2.4886 - 1.081E-7 * d;
            }
            case 7: {
                return 0.7733 + 1.9E-8 * d;
            }
            case 8: {
                return 11.77 - 2.55E-7 * d;
            }
        }
        return Double.NaN;
    }

    private static double getArgumentOfPerihelion(int planet, Calendar date) {
        double d = Ephemerides.getD(date);
        switch (planet) {
            case 0: {
                return 282.9404 + 4.70935E-5 * d;
            }
            case 1: {
                return 29.1241 + 1.01444E-5 * d;
            }
            case 2: {
                return 54.891 + 1.38374E-5 * d;
            }
            case 301: {
                return 318.0634 + 0.1643573223 * d;
            }
            case 4: {
                return 286.5016 + 2.92961E-5 * d;
            }
            case 5: {
                return 273.8777 + 1.64505E-5 * d;
            }
            case 6: {
                return 339.3939 + 2.97661E-5 * d;
            }
            case 7: {
                return 96.6612 + 3.0565E-5 * d;
            }
            case 8: {
                return 272.8461 - 6.027E-6 * d;
            }
        }
        return Double.NaN;
    }

    private static double getSemiMajorAxis(int planet, Calendar date) {
        double d = Ephemerides.getD(date);
        switch (planet) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return 0.387098;
            }
            case 2: {
                return 0.72333;
            }
            case 301: {
                return 60.2666;
            }
            case 4: {
                return 1.523688;
            }
            case 5: {
                return 5.20256;
            }
            case 6: {
                return 9.55475;
            }
            case 7: {
                return 19.18171 - 1.55E-8 * d;
            }
            case 8: {
                return 30.05826 + 3.313E-8 * d;
            }
        }
        return Double.NaN;
    }

    private static double getEccentricity(int planet, Calendar date) {
        double d = Ephemerides.getD(date);
        switch (planet) {
            case 0: {
                return 0.016709 - 1.151E-9 * d;
            }
            case 1: {
                return 0.205635 + 5.59E-10 * d;
            }
            case 2: {
                return 0.006773 - 1.302E-9 * d;
            }
            case 301: {
                return 0.0549;
            }
            case 4: {
                return 0.093405 + 2.516E-9 * d;
            }
            case 5: {
                return 0.048498 + 4.469E-9 * d;
            }
            case 6: {
                return 0.055546 - 9.499E-9 * d;
            }
            case 7: {
                return 0.047318 + 7.45E-9 * d;
            }
            case 8: {
                return 0.008606 + 2.15E-9 * d;
            }
        }
        return Double.NaN;
    }

    private static double getMeanAnomaly(int planet, Calendar date) {
        double d = Ephemerides.getD(date);
        switch (planet) {
            case 0: {
                return 356.047 + 0.9856002585 * d;
            }
            case 1: {
                return 168.6562 + 4.0923344368 * d;
            }
            case 2: {
                return 48.0052 + 1.6021302244 * d;
            }
            case 301: {
                return 115.3654 + 13.0649929509 * d;
            }
            case 4: {
                return 18.6021 + 0.5240207766 * d;
            }
            case 5: {
                return 19.895 + 0.0830853001 * d;
            }
            case 6: {
                return 316.967 + 0.0334442282 * d;
            }
            case 7: {
                return 142.5905 + 0.011725806 * d;
            }
            case 8: {
                return 260.2471 + 0.005995147 * d;
            }
        }
        return Double.NaN;
    }

    private static double getEccentricAnomaly(int planetKey, Calendar date) {
        double aoP = Ephemerides.getArgumentOfPerihelion(planetKey, date);
        if (Double.isNaN(aoP)) {
            return Double.NaN;
        }
        double M = Ephemerides.getMeanAnomaly(planetKey, date);
        double e = Ephemerides.getEccentricity(planetKey, date);
        double E = M + 57.29577951308232 * e * Math.sin(Math.toRadians(M));
        double deltaM = 0.0;
        double deltaE = 0.0;
        for (int i = 0; i < 10; ++i) {
            deltaM = M + e * 57.29577951308232 * Math.sin(Math.toRadians(E)) - E;
            deltaE = deltaM / (1.0 - e * Math.cos(Math.toRadians(E)));
            E += deltaE;
        }
        return E;
    }

    private static double getPerturbationsForMoonDistance(double distance, Calendar date) {
        double Mm = Ephemerides.getMeanAnomaly(301, date);
        double Ms = Ephemerides.getMeanAnomaly(0, date);
        double Nm = Ephemerides.getLongitudeOfTheAscendingNode(301, date);
        double wm = Ephemerides.getArgumentOfPerihelion(301, date);
        double ws = Ephemerides.getArgumentOfPerihelion(0, date);
        double Ls = Ms + ws;
        double Lm = Mm + wm + Nm;
        double D = Lm - Ls;
        double F = Lm - Nm;
        distance += -0.58 * Math.cos(Math.toRadians(Mm - 2.0 * D));
        return distance += -0.46 * Math.cos(Math.toRadians(2.0 * D));
    }

    private static double[] getPerturbationsForMoon(double longitude, double latitude, Calendar date) {
        double Mm = Ephemerides.getMeanAnomaly(301, date);
        double Ms = Ephemerides.getMeanAnomaly(0, date);
        double Nm = Ephemerides.getLongitudeOfTheAscendingNode(301, date);
        double wm = Ephemerides.getArgumentOfPerihelion(301, date);
        double ws = Ephemerides.getArgumentOfPerihelion(0, date);
        double Ls = Ms + ws;
        double Lm = Mm + wm + Nm;
        double D = Lm - Ls;
        double F = Lm - Nm;
        longitude += -1.274 * Math.sin(Math.toRadians(Mm - 2.0 * D));
        longitude += 0.658 * Math.sin(Math.toRadians(2.0 * D));
        longitude += -0.186 * Math.sin(Math.toRadians(Ms));
        longitude += -0.059 * Math.sin(Math.toRadians(2.0 * Mm - 2.0 * D));
        longitude += -0.057 * Math.sin(Math.toRadians(Mm - 2.0 * D + Ms));
        longitude += 0.053 * Math.sin(Math.toRadians(Mm + 2.0 * D));
        longitude += 0.046 * Math.sin(Math.toRadians(2.0 * D - Ms));
        longitude += 0.041 * Math.sin(Math.toRadians(Mm - Ms));
        longitude += -0.035 * Math.sin(Math.toRadians(D));
        longitude += -0.031 * Math.sin(Math.toRadians(Mm + Ms));
        longitude += -0.015 * Math.sin(Math.toRadians(2.0 * F - 2.0 * D));
        latitude += -0.173 * Math.sin(Math.toRadians(F - 2.0 * D));
        latitude += -0.055 * Math.sin(Math.toRadians(Mm - F - 2.0 * D));
        latitude += -0.046 * Math.sin(Math.toRadians(Mm + F - 2.0 * D));
        latitude += 0.033 * Math.sin(Math.toRadians(F + 2.0 * D));
        return new double[]{longitude += 0.011 * Math.sin(Math.toRadians(Mm - 4.0 * D)), latitude += 0.017 * Math.sin(Math.toRadians(2.0 * Mm + F))};
    }
}

