/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.FitsData;
import eap.fits.FitsException;
import eap.fits.FitsFile;
import eap.fits.FitsHDU;
import eap.fits.FitsHeader;
import eap.fits.NoSuchFitsHDUException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFitsFile
extends FitsFile {
    RandomAccessFile file;
    long first_new_byte;

    public RandomAccessFitsFile(RandomAccessFile randomAccessFile) throws IOException {
        this.file = randomAccessFile;
        this.first_new_byte = 0L;
    }

    private FitsHDU readNextHDU() throws IOException {
        this.file.seek(this.first_new_byte);
        FitsHDU fitsHDU = new FitsHDU();
        FitsHeader fitsHeader = fitsHDU.getHeader();
        byte[] byArray = new byte[2880];
        while (this.file.read(byArray) == byArray.length && !fitsHeader.add(byArray)) {
        }
        if (!fitsHeader.isComplete()) {
            throw new FitsException("Invalid FITS format");
        }
        fitsHDU.initData();
        this.first_new_byte += (long)(2880 * fitsHDU.blockCount());
        if (this.first_new_byte >= this.file.length()) {
            this.isComplete = true;
        }
        return fitsHDU;
    }

    private void fillInData(FitsHDU fitsHDU, int n) throws IOException {
        if (n == 0) {
            this.fillInData(fitsHDU);
        } else if (n == 1) {
            new DataFiller(fitsHDU).start();
        }
    }

    private synchronized void fillInData(FitsHDU fitsHDU) throws IOException {
        FitsHDU fitsHDU2;
        FitsData fitsData = fitsHDU.getData();
        if (fitsData.isComplete()) {
            return;
        }
        long l = 0L;
        Object object = this.hdus.iterator();
        while (object.hasNext() && (fitsHDU2 = (FitsHDU)object.next()) != fitsHDU) {
            l += (long)fitsHDU2.blockCount();
        }
        l += (long)fitsHDU.getHeader().blockCount();
        object = fitsData.data();
        if (this.file.read((byte[])object) != ((Object)object).length) {
            throw new FitsException("Couldn't read all data for " + fitsData);
        }
        fitsData.setValidBytes(((Object)object).length);
    }

    public FitsHDU getHDU(int n) throws IOException {
        return this.getHDU(n, 0);
    }

    public FitsHDU getHDU(int n, int n2) throws IOException {
        for (int i = this.hdus.size(); i <= n && !this.isComplete(); ++i) {
            this.add(this.readNextHDU());
        }
        if (this.hdus.size() > n) {
            FitsHDU fitsHDU = (FitsHDU)this.hdus.get(n);
            this.fillInData(fitsHDU, n2);
            return fitsHDU;
        }
        throw new NoSuchFitsHDUException("Can't get HDU " + n + " in " + this);
    }

    public FitsHDU getHDU(String string) throws IOException {
        return this.getHDU(string, 0);
    }

    public FitsHDU getHDU(String string, int n) throws IOException {
        int n2 = this.hdus.size();
        while (!this.index.containsKey(string) && !this.isComplete()) {
            this.add(this.readNextHDU());
            ++n2;
        }
        if (this.index.containsKey(string)) {
            FitsHDU fitsHDU = (FitsHDU)this.index.get(string);
            this.fillInData(fitsHDU, n);
            return fitsHDU;
        }
        throw new NoSuchFitsHDUException("Can't get HDU" + string + " in " + this);
    }

    private class DataFiller
    extends Thread {
        FitsHDU hdu;

        public DataFiller(FitsHDU fitsHDU) {
            this.hdu = fitsHDU;
        }

        public void run() {
            try {
                RandomAccessFitsFile.this.fillInData(this.hdu);
            }
            catch (IOException iOException) {
                System.err.println("Error while reading data for " + this.hdu + "in background");
                iOException.printStackTrace();
            }
        }
    }
}

