/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.FitsCard;
import eap.fits.FitsData;
import eap.fits.FitsException;
import eap.fits.FitsHDU;
import eap.fits.FitsHeader;
import eap.fits.FitsImageData;
import eap.fits.NoSuchFitsHDUException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FitsFile {
    public static final int BLOCK_SIZE = 2880;
    public static final int NEED_DATA_NOW = 0;
    public static final int NEED_DATA_LATER = 1;
    public static final int DATA_NOT_NEEDED = 2;
    protected List hdus = new ArrayList();
    protected Map index = new HashMap();
    protected boolean isComplete = false;

    public boolean isComplete() {
        return this.isComplete;
    }

    public void add(FitsHDU fitsHDU) {
        this.hdus.add(fitsHDU);
        this.index.put(fitsHDU.name(), fitsHDU);
    }

    public FitsHDU getHDU(int n) throws IOException {
        if (n >= this.hdus.size()) {
            throw new NoSuchFitsHDUException("Can't get HDU " + n + " in " + this);
        }
        return (FitsHDU)this.hdus.get(n);
    }

    public FitsHDU getHDU(String string) throws IOException {
        FitsHDU fitsHDU = (FitsHDU)this.index.get(string);
        if (fitsHDU == null) {
            throw new NoSuchFitsHDUException("Can't get HDU " + string + " in " + this);
        }
        return fitsHDU;
    }

    public FitsHDU getHDU(int n, int n2) throws IOException {
        return this.getHDU(n);
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            int n = 0;
            while (true) {
                int n2;
                FitsHDU fitsHDU = this.getHDU(n);
                FitsHeader fitsHeader = fitsHDU.getHeader();
                int n3 = fitsHeader.cardCount();
                for (n2 = 0; n2 < n3; ++n2) {
                    outputStream.write(fitsHeader.card(n2).data());
                }
                n2 = fitsHeader.blockCount() * 36 - n3;
                for (int i = 0; i < n2; ++i) {
                    outputStream.write(FitsCard.PADDING);
                }
                FitsData fitsData = fitsHDU.getData();
                outputStream.write(fitsData.data());
                int n4 = fitsData.blockCount() * 2880 - fitsData.data().length;
                for (int i = 0; i < n4; ++i) {
                    outputStream.write(0);
                }
                ++n;
            }
        }
        catch (NoSuchFitsHDUException noSuchFitsHDUException) {
            outputStream.close();
            return;
        }
    }

    public static FitsFile createEmpty() throws FitsException {
        FitsFile fitsFile = new FitsFile();
        FitsImageData fitsImageData = new FitsImageData();
        FitsHeader fitsHeader = fitsImageData.createHeader("PRIMARY");
        FitsHDU fitsHDU = new FitsHDU(fitsHeader, fitsImageData);
        fitsFile.add(fitsHDU);
        return fitsFile;
    }
}

