/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.FitsBinaryColumn;
import eap.fits.FitsColumn;
import eap.fits.FitsException;
import eap.fits.FitsHeader;
import eap.fits.FitsTableData;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class FitsBinTableData
extends FitsTableData {
    public FitsBinTableData(FitsHeader fitsHeader) throws FitsException {
        super(fitsHeader);
        int n;
        for (n = 1; n <= this.ncolumns; ++n) {
            this.columns.add(new FitsBinaryColumn(fitsHeader, n));
        }
        n = 0;
        Iterator iterator = this.columns.iterator();
        while (iterator.hasNext()) {
            FitsColumn fitsColumn = (FitsColumn)iterator.next();
            this.offsets.put(fitsColumn, new Integer(n));
            n += fitsColumn.getWidth();
        }
    }

    private Object readNextElement(FitsColumn fitsColumn) throws FitsException {
        char c = fitsColumn.type;
        try {
            if (c == 'L') {
                byte by = this.interpreter.readByte();
                if (by == 84) {
                    return Boolean.TRUE;
                }
                if (by == 70) {
                    return Boolean.FALSE;
                }
                return null;
            }
            if (c == 'X') {
                return new Byte(this.interpreter.readByte());
            }
            if (c == 'A') {
                byte[] byArray = new byte[fitsColumn.getWidth()];
                this.interpreter.readFully(byArray);
                String string = new String(byArray);
                int n = string.indexOf(0);
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                return string;
            }
            if (c == 'B') {
                return new Integer(this.interpreter.readUnsignedByte());
            }
            if (c == 'I') {
                return new Short(this.interpreter.readShort());
            }
            if (c == 'J') {
                return new Integer(this.interpreter.readInt());
            }
            if (c == 'E') {
                return new Float(this.interpreter.readFloat());
            }
            if (c == 'D') {
                return new Double(this.interpreter.readDouble());
            }
            if (c == 'C') {
                return new Float(this.interpreter.readFloat());
            }
            if (c == 'M') {
                return new Double(this.interpreter.readDouble());
            }
            throw new FitsException("Can't read data type " + c + " from " + this);
        }
        catch (EOFException eOFException) {
            throw new FitsException("No such element in " + this);
        }
        catch (FitsException fitsException) {
            throw fitsException;
        }
        catch (IOException iOException) {
            throw new FitsException("Couldn't get element in " + this);
        }
    }

    private void setNextElement(FitsColumn fitsColumn, Object object) throws FitsException {
        block20: {
            char c = fitsColumn.type;
            try {
                if (c == 'L') {
                    if (object == null) {
                        this.setter.writeByte(0);
                    } else {
                        Boolean bl = (Boolean)object;
                        if (bl.booleanValue()) {
                            this.setter.writeByte(84);
                        } else {
                            this.setter.writeByte(70);
                        }
                    }
                    break block20;
                }
                if (c == 'X') {
                    this.setter.writeByte(((Number)object).intValue());
                    break block20;
                }
                if (c == 'A') {
                    String string = (String)object;
                    if (string.length() > fitsColumn.count) {
                        string = string.substring(0, fitsColumn.count);
                    }
                    if (string.length() < fitsColumn.count) {
                        int n = fitsColumn.count - string.length();
                        StringBuffer stringBuffer = new StringBuffer(n);
                        for (int i = 0; i < n; ++i) {
                            stringBuffer.append('\u0000');
                        }
                        string = string + stringBuffer;
                    }
                    this.setter.writeBytes(string);
                    break block20;
                }
                if (c == 'B') {
                    this.setter.writeByte(((Number)object).intValue());
                    break block20;
                }
                if (c == 'I') {
                    this.setter.writeShort(((Number)object).intValue());
                    break block20;
                }
                if (c == 'J') {
                    this.setter.writeInt(((Number)object).intValue());
                    break block20;
                }
                if (c == 'E') {
                    this.setter.writeFloat(((Number)object).floatValue());
                    break block20;
                }
                if (c == 'D') {
                    this.setter.writeDouble(((Number)object).doubleValue());
                    break block20;
                }
                if (c == 'C') {
                    this.setter.writeFloat(((Number)object).floatValue());
                    break block20;
                }
                if (c == 'M') {
                    this.setter.writeDouble(((Number)object).doubleValue());
                    break block20;
                }
                throw new FitsException("Can't write data type " + c + " from " + this);
            }
            catch (ClassCastException classCastException) {
                throw new FitsException("Incompatible data type " + object.getClass().getName() + " for column " + fitsColumn + " (" + fitsColumn.rawRepresentation().getName() + ") " + "in " + this);
            }
            catch (IOException iOException) {
                throw new FitsException("Couldn't set element in " + this);
            }
        }
    }

    public Object getValueAt(int n, int n2) {
        FitsColumn fitsColumn = this.getColumn(n2);
        this.goToElement(n, fitsColumn);
        try {
            int n3 = fitsColumn.getCount();
            if (n3 == 1) {
                return fitsColumn.scale(this.readNextElement(fitsColumn));
            }
            if (n3 < 0) {
                n3 = this.interpreter.readInt();
                long l = this.interpreter.readInt();
                this.goToByte(l += (long)(this.nrows * this.bytes_per_row));
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < n3; ++i) {
                arrayList.add(fitsColumn.scale(this.readNextElement(fitsColumn)));
            }
            return arrayList;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        FitsColumn fitsColumn = this.getColumn(n2);
        this.goToElement(n, fitsColumn);
        try {
            long l = fitsColumn.getCount();
            if (l != 1L) {
                char c;
                int n3;
                int n4;
                String string = object.toString();
                if (l < 0L) {
                    l = this.interpreter.readInt();
                    n4 = this.interpreter.readInt();
                    this.goToByte(n4 += this.nrows * this.bytes_per_row);
                }
                for (n4 = 0; n4 < string.length() && ((n3 = string.charAt(n4)) == 32 || n3 == 91); ++n4) {
                }
                for (n3 = string.length() - 1; n3 >= 0 && ((c = string.charAt(n3)) == ' ' || c == ']'); --n3) {
                }
                string = string.substring(n4, n3 + 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n5 = 0;
                while ((long)n5 < l && stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    this.setNextElement(fitsColumn, fitsColumn.represent(fitsColumn.unscale(string2)));
                    ++n5;
                }
            } else {
                this.setNextElement(fitsColumn, fitsColumn.represent(fitsColumn.unscale(object)));
            }
            this.fireTableModelEvent(n, n2);
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

