/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om;

import de.lehmannet.om.IObserver;
import de.lehmannet.om.SchemaElement;
import de.lehmannet.om.util.FloatUtil;
import de.lehmannet.om.util.SchemaException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Observer
extends SchemaElement
implements IObserver {
    public static final String ACCOUNT_DSL = "www.deepskyliste.de";
    public static final String ACCOUNT_AAVSO = "www.aavso.org";
    public static final String ACCOUNT_DEEPSKYLOG = "www.deepskylog.org";
    private String name = new String();
    private String surname = new String();
    private LinkedList contacts = new LinkedList();
    private HashMap accounts = new HashMap();
    private float fstOffset = Float.NaN;

    public Observer(Node observer) throws SchemaException, IllegalArgumentException {
        int te;
        if (observer == null) {
            throw new IllegalArgumentException("Parameter observer node cannot be NULL. ");
        }
        Element observerElement = (Element)observer;
        Element child = null;
        NodeList children = null;
        NamedNodeMap attributes = observerElement.getAttributes();
        if (attributes == null || attributes.getLength() == 0) {
            throw new SchemaException("Observer must have a unique ID. ");
        }
        String ID = observerElement.getAttribute("id");
        super.setID(ID);
        children = observerElement.getElementsByTagName("name");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Observer must have exact one name. ");
        }
        child = (Element)children.item(0);
        String name = "";
        if (child == null) {
            throw new SchemaException("Observer must have a name. ");
        }
        if (child.getFirstChild() != null) {
            NodeList textElements = child.getChildNodes();
            if (textElements != null && textElements.getLength() > 0) {
                for (int te2 = 0; te2 < textElements.getLength(); ++te2) {
                    name = name + textElements.item(te2).getNodeValue();
                }
                this.setName(name);
            }
        } else {
            this.setName("");
        }
        child = null;
        children = observerElement.getElementsByTagName("surname");
        if (children == null || children.getLength() != 1) {
            throw new SchemaException("Observer must have exact one surname. ");
        }
        child = (Element)children.item(0);
        String surname = "";
        if (child == null) {
            throw new SchemaException("Observer must have a surname. ");
        }
        NodeList textElements = child.getChildNodes();
        if (textElements != null && textElements.getLength() > 0) {
            for (int te3 = 0; te3 < textElements.getLength(); ++te3) {
                surname = surname + textElements.item(te3).getNodeValue();
            }
            this.setSurname(surname);
        }
        child = null;
        children = observerElement.getElementsByTagName("contact");
        if (children != null) {
            for (int x = 0; x < children.getLength(); ++x) {
                child = (Element)children.item(x);
                if (child != null) {
                    String contactEntry = "";
                    NodeList textElements2 = child.getChildNodes();
                    if (textElements2 == null || textElements2.getLength() <= 0) continue;
                    for (te = 0; te < textElements2.getLength(); ++te) {
                        contactEntry = contactEntry + textElements2.item(te).getNodeValue();
                    }
                    this.addContact(contactEntry);
                    continue;
                }
                throw new SchemaException("Problem retrieving contact information from Observer. ");
            }
        }
        child = null;
        children = observerElement.getElementsByTagName("DSL");
        String DSLCode = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child != null) {
                    NodeList textElements3 = child.getChildNodes();
                    if (textElements3 != null && textElements3.getLength() > 0) {
                        for (int te4 = 0; te4 < textElements3.getLength(); ++te4) {
                            DSLCode = DSLCode + textElements3.item(te4).getNodeValue();
                        }
                        this.accounts.put(ACCOUNT_DSL, DSLCode);
                    }
                } else {
                    System.err.println("Problem while retrieving DSL code from observer: " + this.getID() + "\nAs this element is deprecated, error will be ignored.");
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observer can have only one DSL Code. ");
            }
        }
        child = null;
        children = observerElement.getElementsByTagName("fstOffset");
        String fstOffset = "";
        if (children != null) {
            if (children.getLength() == 1) {
                child = (Element)children.item(0);
                if (child != null) {
                    NodeList textElements4 = child.getChildNodes();
                    if (textElements4 != null && textElements4.getLength() > 0) {
                        for (te = 0; te < textElements4.getLength(); ++te) {
                            fstOffset = fstOffset + textElements4.item(te).getNodeValue();
                        }
                        this.fstOffset = FloatUtil.parseFloat((String)fstOffset);
                    }
                } else {
                    System.err.println("Problem while retrieving fst Offset from observer: " + this.getID());
                }
            } else if (children.getLength() > 1) {
                throw new SchemaException("Observer can have only one fst Offset. ");
            }
        }
        child = null;
        children = observerElement.getElementsByTagName("account");
        if (children != null) {
            for (int x = 0; x < children.getLength(); ++x) {
                child = (Element)children.item(x);
                if (child != null) {
                    String accountName = child.getAttribute("name");
                    String accountID = "";
                    NodeList textElements5 = child.getChildNodes();
                    if (textElements5 == null || textElements5.getLength() <= 0) continue;
                    for (int te5 = 0; te5 < textElements5.getLength(); ++te5) {
                        accountID = accountID + textElements5.item(te5).getNodeValue();
                    }
                    this.addAccount(accountName, accountID);
                    continue;
                }
                throw new SchemaException("Problem retrieving account information from Observer. " + this.getID());
            }
        }
    }

    public Observer(String name, String surname) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null. ");
        }
        this.name = name;
        if (surname == null) {
            throw new IllegalArgumentException("Surname cannot be null. ");
        }
        this.surname = surname;
    }

    public String getDisplayName() {
        return this.getSurname() + ", " + this.getName();
    }

    public String toString() {
        Iterator<Object> iterator;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Observer: Name=");
        buffer.append(this.name);
        buffer.append(" Surname=");
        buffer.append(this.surname);
        buffer.append(" Contacts=");
        if (this.contacts != null && !this.contacts.isEmpty()) {
            iterator = this.contacts.listIterator();
            while (iterator.hasNext()) {
                buffer.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                buffer.append(" --- ");
            }
        }
        buffer.append(" Accounts=");
        if (this.accounts != null && !this.accounts.isEmpty()) {
            iterator = this.accounts.keySet().iterator();
            String key = null;
            String value = null;
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                value = (String)this.accounts.get(key);
                buffer.append(key + ": " + value);
                if (!iterator.hasNext()) continue;
                buffer.append(" --- ");
            }
        }
        buffer.append(" fstOffset=");
        buffer.append(this.fstOffset);
        return buffer.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Element addToXmlElement(Element element) {
        Iterator<Object> iterator;
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        NodeList nodeList = element.getElementsByTagName("observer");
        if (nodeList.getLength() > 0) {
            Node currentNode = null;
            NamedNodeMap attributes = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                currentNode = nodeList.item(i);
                attributes = currentNode.getAttributes();
                Node idAttribute = attributes.getNamedItem("id");
                if (idAttribute == null || !idAttribute.getNodeValue().trim().equals(super.getID().trim())) continue;
                return element;
            }
        }
        Element e_Observer = ownerDoc.createElement("observer");
        e_Observer.setAttribute("id", super.getID());
        element.appendChild(e_Observer);
        Element e_Name = ownerDoc.createElement("name");
        CDATASection n_NameText = ownerDoc.createCDATASection(this.name);
        e_Name.appendChild(n_NameText);
        e_Observer.appendChild(e_Name);
        Element e_Surname = ownerDoc.createElement("surname");
        CDATASection n_SurnameText = ownerDoc.createCDATASection(this.surname);
        e_Surname.appendChild(n_SurnameText);
        e_Observer.appendChild(e_Surname);
        if (this.contacts != null && !this.contacts.isEmpty()) {
            Element e_Contact = null;
            iterator = this.contacts.listIterator();
            String contact = null;
            while (iterator.hasNext()) {
                contact = (String)iterator.next();
                e_Contact = ownerDoc.createElement("contact");
                CDATASection n_ContactText = ownerDoc.createCDATASection(contact);
                e_Contact.appendChild(n_ContactText);
                e_Observer.appendChild(e_Contact);
            }
        }
        if (this.accounts != null && !this.accounts.isEmpty()) {
            Element e_Account = null;
            iterator = this.accounts.keySet().iterator();
            String account = null;
            String value = null;
            while (iterator.hasNext()) {
                account = (String)iterator.next();
                value = (String)this.accounts.get(account);
                e_Account = ownerDoc.createElement("account");
                e_Account.setAttribute("name", account);
                CDATASection n_AccountText = ownerDoc.createCDATASection(value);
                e_Account.appendChild(n_AccountText);
                e_Observer.appendChild(e_Account);
            }
        }
        if (!Float.isNaN(this.fstOffset)) {
            Element e_fstOffset = ownerDoc.createElement("fstOffset");
            Text n_fstOffset = ownerDoc.createTextNode(Float.toString(this.fstOffset));
            e_fstOffset.appendChild(n_fstOffset);
            e_Observer.appendChild(e_fstOffset);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element, String nameOfLinkElement, boolean addElementToContainer) {
        if (element == null) {
            return null;
        }
        Document ownerDoc = element.getOwnerDocument();
        Element e_Link = ownerDoc.createElement(nameOfLinkElement);
        Text n_LinkText = ownerDoc.createTextNode(super.getID());
        e_Link.appendChild(n_LinkText);
        element.appendChild(e_Link);
        if (addElementToContainer) {
            Element e_Observers = null;
            NodeList nodeList = ownerDoc.getElementsByTagName("observers");
            if (nodeList.getLength() == 0) {
                e_Observers = ownerDoc.createElement("observers");
                ownerDoc.getDocumentElement().appendChild(e_Observers);
            } else {
                e_Observers = (Element)nodeList.item(0);
            }
            this.addToXmlElement(e_Observers);
        }
        return element;
    }

    public Element addAsLinkToXmlElement(Element element, String nameOfLinkElement) {
        return this.addAsLinkToXmlElement(element, nameOfLinkElement, false);
    }

    public List getContacts() {
        return this.contacts;
    }

    public boolean addContact(String newContact) {
        if (newContact == null || "".equals(newContact)) {
            return false;
        }
        this.contacts.add(newContact);
        return true;
    }

    public boolean setContacts(List newContacts) {
        if (newContacts == null) {
            return false;
        }
        this.contacts = new LinkedList(newContacts);
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getDSLCode() {
        return this.getUsernameForAccount(ACCOUNT_DSL);
    }

    public String getSurname() {
        return this.surname;
    }

    public void setDSLCode(String DSLCode) {
        this.addAccount(ACCOUNT_DSL, DSLCode);
    }

    public void setName(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null. ");
        }
        this.name = name;
    }

    public void setSurname(String surname) {
        if (surname == null) {
            throw new IllegalArgumentException("Surname cannot be null. ");
        }
        this.surname = surname;
    }

    public Map getAccounts() {
        return (Map)this.accounts.clone();
    }

    public boolean addAccount(String accountName, String username) {
        if (accountName == null || "".equals(accountName.trim()) || username == null || "".equals(username.trim())) {
            return false;
        }
        this.accounts.put(accountName, username);
        return true;
    }

    public boolean removeAccount(String accountName) {
        this.accounts.remove(accountName);
        return true;
    }

    public boolean setAccounts(Map newAccounts) {
        if (newAccounts == null) {
            newAccounts = new HashMap();
        }
        this.accounts = new HashMap(newAccounts);
        return true;
    }

    public String getUsernameForAccount(String accountName) {
        return (String)this.accounts.get(accountName);
    }

    public void setFSTOffset(float fstOffset) {
        if (Float.isNaN(fstOffset)) {
            this.fstOffset = Float.NaN;
            return;
        }
        this.fstOffset = fstOffset;
    }

    public float getFSTOffset() {
        return this.fstOffset;
    }

    private List sortContactList(List contacts) {
        Collections.sort(contacts, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.compareTo(s2);
            }

            public boolean equals(Object obj) {
                return false;
            }
        });
        return contacts;
    }
}

