/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.util;

import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IImager;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ITargetContaining;
import de.lehmannet.om.ui.util.SchemaElementCacheEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

class CacheEntry {
    private String xmlPath = null;
    private SchemaElementCacheEntry[] observation = new SchemaElementCacheEntry[0];
    private SchemaElementCacheEntry[] eyepiece = new SchemaElementCacheEntry[0];
    private SchemaElementCacheEntry[] imager = new SchemaElementCacheEntry[0];
    private SchemaElementCacheEntry[] filter = new SchemaElementCacheEntry[0];
    private SchemaElementCacheEntry[] coObserver = new SchemaElementCacheEntry[0];
    private SchemaElementCacheEntry[] observer = new SchemaElementCacheEntry[0];
    private SchemaElementCacheEntry[] scope = new SchemaElementCacheEntry[0];
    private SchemaElementCacheEntry[] session = new SchemaElementCacheEntry[0];
    private SchemaElementCacheEntry[] site = new SchemaElementCacheEntry[0];
    private SchemaElementCacheEntry[] target = new SchemaElementCacheEntry[0];
    private SchemaElementCacheEntry[] lens = new SchemaElementCacheEntry[0];
    private SchemaElementCacheEntry[] targetContaining = new SchemaElementCacheEntry[0];

    public CacheEntry() {
    }

    public CacheEntry(String xmlPath, IObservation[] observation, IEyepiece[] eyepiece, IFilter[] filter, IImager[] imager, IObserver[] observer, IScope[] scope, ISession[] session, ISite[] site, ITarget[] target, ILens[] lens) {
        int i;
        int i2;
        this.xmlPath = xmlPath;
        this.observation = new SchemaElementCacheEntry[observation.length];
        for (i2 = 0; i2 < observation.length; ++i2) {
            this.observation[i2] = new SchemaElementCacheEntry((ISchemaElement)observation[i2]);
        }
        this.eyepiece = new SchemaElementCacheEntry[eyepiece.length];
        for (i2 = 0; i2 < eyepiece.length; ++i2) {
            this.eyepiece[i2] = new SchemaElementCacheEntry((ISchemaElement)eyepiece[i2]);
        }
        this.filter = new SchemaElementCacheEntry[filter.length];
        for (i2 = 0; i2 < filter.length; ++i2) {
            this.filter[i2] = new SchemaElementCacheEntry((ISchemaElement)filter[i2]);
        }
        this.imager = new SchemaElementCacheEntry[imager.length];
        for (i2 = 0; i2 < imager.length; ++i2) {
            this.imager[i2] = new SchemaElementCacheEntry((ISchemaElement)imager[i2]);
        }
        this.observer = new SchemaElementCacheEntry[observer.length];
        this.coObserver = new SchemaElementCacheEntry[observer.length];
        for (i2 = 0; i2 < observer.length; ++i2) {
            this.observer[i2] = new SchemaElementCacheEntry((ISchemaElement)observer[i2]);
            this.coObserver[i2] = new SchemaElementCacheEntry((ISchemaElement)observer[i2]);
        }
        this.scope = new SchemaElementCacheEntry[scope.length];
        for (i2 = 0; i2 < scope.length; ++i2) {
            this.scope[i2] = new SchemaElementCacheEntry((ISchemaElement)scope[i2]);
        }
        this.session = new SchemaElementCacheEntry[session.length];
        for (i2 = 0; i2 < session.length; ++i2) {
            this.session[i2] = new SchemaElementCacheEntry((ISchemaElement)session[i2]);
        }
        this.site = new SchemaElementCacheEntry[site.length];
        for (i2 = 0; i2 < site.length; ++i2) {
            this.site[i2] = new SchemaElementCacheEntry((ISchemaElement)site[i2]);
        }
        this.target = new SchemaElementCacheEntry[target.length];
        ArrayList<SchemaElementCacheEntry> helper = new ArrayList<SchemaElementCacheEntry>();
        for (i = 0; i < target.length; ++i) {
            this.target[i] = new SchemaElementCacheEntry((ISchemaElement)target[i]);
            if (!(target[i] instanceof ITargetContaining)) continue;
            SchemaElementCacheEntry entry = new SchemaElementCacheEntry((ISchemaElement)target[i]);
            entry.addReferencedElements(((ITargetContaining)target[i]).getComponentTargets(target));
            helper.add(entry);
        }
        this.targetContaining = helper.toArray(new SchemaElementCacheEntry[0]);
        this.lens = new SchemaElementCacheEntry[lens.length];
        for (i = 0; i < lens.length; ++i) {
            this.lens[i] = new SchemaElementCacheEntry((ISchemaElement)lens[i]);
        }
        for (i = 0; i < this.observation.length; ++i) {
            this.addAllObservationElements(this.observation[i]);
        }
    }

    public String getXmlPath() {
        return this.xmlPath;
    }

    public List getReferedElements(ISchemaElement element) {
        block11: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block10: {
                                                if (!(element instanceof IObservation)) break block10;
                                                for (int i = 0; i < this.observation.length; ++i) {
                                                    if (!this.observation[i].getSchemaElement().equals(element)) continue;
                                                    return this.observation[i].getReferencedElements();
                                                }
                                                break block11;
                                            }
                                            if (!(element instanceof IEyepiece)) break block12;
                                            for (int i = 0; i < this.eyepiece.length; ++i) {
                                                if (!this.eyepiece[i].getSchemaElement().equals(element)) continue;
                                                return this.eyepiece[i].getReferencedElements();
                                            }
                                            break block11;
                                        }
                                        if (!(element instanceof IImager)) break block13;
                                        for (int i = 0; i < this.imager.length; ++i) {
                                            if (!this.imager[i].getSchemaElement().equals(element)) continue;
                                            return this.imager[i].getReferencedElements();
                                        }
                                        break block11;
                                    }
                                    if (!(element instanceof IFilter)) break block14;
                                    for (int i = 0; i < this.filter.length; ++i) {
                                        if (!this.filter[i].getSchemaElement().equals(element)) continue;
                                        return this.filter[i].getReferencedElements();
                                    }
                                    break block11;
                                }
                                if (!(element instanceof IObserver)) break block15;
                                for (int i = 0; i < this.observer.length; ++i) {
                                    if (!this.observer[i].getSchemaElement().equals(element)) continue;
                                    return this.observer[i].getReferencedElements();
                                }
                                break block11;
                            }
                            if (!(element instanceof IScope)) break block16;
                            for (int i = 0; i < this.scope.length; ++i) {
                                if (!this.scope[i].getSchemaElement().equals(element)) continue;
                                return this.scope[i].getReferencedElements();
                            }
                            break block11;
                        }
                        if (!(element instanceof ISession)) break block17;
                        for (int i = 0; i < this.session.length; ++i) {
                            if (!this.session[i].getSchemaElement().equals(element)) continue;
                            return this.session[i].getReferencedElements();
                        }
                        break block11;
                    }
                    if (!(element instanceof ISite)) break block18;
                    for (int i = 0; i < this.site.length; ++i) {
                        if (!this.site[i].getSchemaElement().equals(element)) continue;
                        return this.site[i].getReferencedElements();
                    }
                    break block11;
                }
                if (!(element instanceof ITarget)) break block19;
                for (int i = 0; i < this.target.length; ++i) {
                    if (!this.target[i].getSchemaElement().equals(element)) continue;
                    return this.target[i].getReferencedElements();
                }
                break block11;
            }
            if (!(element instanceof ILens)) break block11;
            for (int i = 0; i < this.lens.length; ++i) {
                if (!this.lens[i].getSchemaElement().equals(element)) continue;
                return this.lens[i].getReferencedElements();
            }
        }
        return null;
    }

    public List getReferencedObservationsForCoObserver(IObserver coObserver) {
        for (int i = 0; i < this.coObserver.length; ++i) {
            if (!this.coObserver[i].getSchemaElement().equals(coObserver)) continue;
            ArrayList re = new ArrayList(this.coObserver[i].getReferencedElements());
            ListIterator iterator = re.listIterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof ISession)) continue;
                iterator.remove();
            }
            return re;
        }
        return null;
    }

    public IObservation[] getObservations() {
        IObservation[] result = new IObservation[this.observation.length];
        for (int i = 0; i < this.observation.length; ++i) {
            result[i] = (IObservation)this.observation[i].getSchemaElement();
        }
        return result;
    }

    public IEyepiece[] getEyepieces() {
        IEyepiece[] result = new IEyepiece[this.eyepiece.length];
        for (int i = 0; i < this.eyepiece.length; ++i) {
            result[i] = (IEyepiece)this.eyepiece[i].getSchemaElement();
        }
        return result;
    }

    public IImager[] getImagers() {
        IImager[] result = new IImager[this.imager.length];
        for (int i = 0; i < this.imager.length; ++i) {
            result[i] = (IImager)this.imager[i].getSchemaElement();
        }
        return result;
    }

    public IFilter[] getFilters() {
        IFilter[] result = new IFilter[this.filter.length];
        for (int i = 0; i < this.filter.length; ++i) {
            result[i] = (IFilter)this.filter[i].getSchemaElement();
        }
        return result;
    }

    public IObserver[] getObservers() {
        IObserver[] result = new IObserver[this.observer.length];
        for (int i = 0; i < this.observer.length; ++i) {
            result[i] = (IObserver)this.observer[i].getSchemaElement();
        }
        return result;
    }

    public IObserver[] getCoObservers() {
        IObserver[] result = new IObserver[this.observer.length];
        for (int i = 0; i < this.observer.length; ++i) {
            result[i] = (IObserver)this.observer[i].getSchemaElement();
        }
        return result;
    }

    public IScope[] getScopes() {
        IScope[] result = new IScope[this.scope.length];
        for (int i = 0; i < this.scope.length; ++i) {
            result[i] = (IScope)this.scope[i].getSchemaElement();
        }
        return result;
    }

    public ISession[] getSessions() {
        ISession[] result = new ISession[this.session.length];
        for (int i = 0; i < this.session.length; ++i) {
            result[i] = (ISession)this.session[i].getSchemaElement();
        }
        return result;
    }

    public ISite[] getSites() {
        ISite[] result = new ISite[this.site.length];
        for (int i = 0; i < this.site.length; ++i) {
            result[i] = (ISite)this.site[i].getSchemaElement();
        }
        return result;
    }

    public ITarget[] getTargets() {
        ITarget[] result = new ITarget[this.target.length];
        for (int i = 0; i < this.target.length; ++i) {
            result[i] = (ITarget)this.target[i].getSchemaElement();
        }
        return result;
    }

    public ILens[] getLenses() {
        ILens[] result = new ILens[this.lens.length];
        for (int i = 0; i < this.lens.length; ++i) {
            result[i] = (ILens)this.lens[i].getSchemaElement();
        }
        return result;
    }

    public void addEyepiece(IEyepiece eyepiece) {
        if (!this.doublicateCheck(this.eyepiece, (ISchemaElement)eyepiece)) {
            SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.eyepiece.length + 1];
            System.arraycopy(this.eyepiece, 0, newArray, 0, this.eyepiece.length);
            newArray[newArray.length - 1] = new SchemaElementCacheEntry((ISchemaElement)eyepiece);
            this.eyepiece = newArray;
        }
    }

    public void addImager(IImager imager) {
        if (!this.doublicateCheck(this.imager, (ISchemaElement)imager)) {
            SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.imager.length + 1];
            System.arraycopy(this.imager, 0, newArray, 0, this.imager.length);
            newArray[newArray.length - 1] = new SchemaElementCacheEntry((ISchemaElement)imager);
            this.imager = newArray;
        }
    }

    public void addFilter(IFilter filter) {
        if (!this.doublicateCheck(this.filter, (ISchemaElement)filter)) {
            SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.filter.length + 1];
            System.arraycopy(this.filter, 0, newArray, 0, this.filter.length);
            newArray[newArray.length - 1] = new SchemaElementCacheEntry((ISchemaElement)filter);
            this.filter = newArray;
        }
    }

    public void addObservation(IObservation observation) {
        for (int i = 0; i < this.observation.length; ++i) {
            if (!this.observation[i].getSchemaElement().equals(observation)) continue;
            return;
        }
        SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.observation.length + 1];
        System.arraycopy(this.observation, 0, newArray, 0, this.observation.length);
        newArray[newArray.length - 1] = new SchemaElementCacheEntry((ISchemaElement)observation);
        this.observation = newArray;
        this.addAllObservationElements(newArray[newArray.length - 1]);
    }

    public void addObserver(IObserver observer) {
        if (!this.doublicateCheck(this.observer, (ISchemaElement)observer)) {
            SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.observer.length + 1];
            System.arraycopy(this.observer, 0, newArray, 0, this.observer.length);
            newArray[newArray.length - 1] = new SchemaElementCacheEntry((ISchemaElement)observer);
            this.observer = newArray;
            SchemaElementCacheEntry[] newCoObsArray = new SchemaElementCacheEntry[this.coObserver.length + 1];
            System.arraycopy(this.coObserver, 0, newCoObsArray, 0, this.coObserver.length);
            newCoObsArray[newCoObsArray.length - 1] = new SchemaElementCacheEntry((ISchemaElement)observer);
            this.coObserver = newCoObsArray;
        }
    }

    public void addScope(IScope scope) {
        if (!this.doublicateCheck(this.scope, (ISchemaElement)scope)) {
            SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.scope.length + 1];
            System.arraycopy(this.scope, 0, newArray, 0, this.scope.length);
            newArray[newArray.length - 1] = new SchemaElementCacheEntry((ISchemaElement)scope);
            this.scope = newArray;
        }
    }

    public void addSession(ISession session) {
        if (!this.doublicateCheck(this.session, (ISchemaElement)session)) {
            SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.session.length + 1];
            System.arraycopy(this.session, 0, newArray, 0, this.session.length);
            newArray[newArray.length - 1] = new SchemaElementCacheEntry((ISchemaElement)session);
            this.session = newArray;
        }
    }

    public void addSite(ISite site) {
        if (!this.doublicateCheck(this.site, (ISchemaElement)site)) {
            SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.site.length + 1];
            System.arraycopy(this.site, 0, newArray, 0, this.site.length);
            newArray[newArray.length - 1] = new SchemaElementCacheEntry((ISchemaElement)site);
            this.site = newArray;
        }
    }

    public void addTarget(ITarget target) {
        if (!this.doublicateCheck(this.target, (ISchemaElement)target)) {
            SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.target.length + 1];
            System.arraycopy(this.target, 0, newArray, 0, this.target.length);
            newArray[newArray.length - 1] = new SchemaElementCacheEntry((ISchemaElement)target);
            this.target = newArray;
            if (target instanceof ITargetContaining) {
                SchemaElementCacheEntry[] newContainingArray = new SchemaElementCacheEntry[this.targetContaining.length + 1];
                System.arraycopy(this.targetContaining, 0, newContainingArray, 0, this.targetContaining.length);
                newContainingArray[newContainingArray.length - 1] = new SchemaElementCacheEntry((ISchemaElement)target);
                newContainingArray[newContainingArray.length - 1].addReferencedElements(((ITargetContaining)target).getComponentTargets(this.getTargets()));
                this.targetContaining = newContainingArray;
            }
        }
    }

    public void addLens(ILens lens) {
        if (!this.doublicateCheck(this.lens, (ISchemaElement)lens)) {
            SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.lens.length + 1];
            System.arraycopy(this.lens, 0, newArray, 0, this.lens.length);
            newArray[newArray.length - 1] = new SchemaElementCacheEntry((ISchemaElement)lens);
            this.lens = newArray;
        }
    }

    public void updateObservation(IObservation observation) {
        SchemaElementCacheEntry cacheEntry = null;
        for (int i = 0; i < this.observation.length; ++i) {
            if (!observation.getID().equals(this.observation[i].getSchemaElement().getID())) continue;
            cacheEntry = this.observation[i];
            break;
        }
        if (cacheEntry == null) {
            return;
        }
        List referedElements = cacheEntry.getReferencedElements();
        ListIterator iterator = referedElements.listIterator();
        ISchemaElement current = null;
        ArrayList<ISchemaElement> removeList = new ArrayList<ISchemaElement>();
        ArrayList<Object> addList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            ListIterator listIterator;
            int x;
            current = (ISchemaElement)iterator.next();
            removeList.add(current);
            if (current instanceof IEyepiece) {
                addList.add(observation.getEyepiece());
                for (x = 0; x < this.eyepiece.length; ++x) {
                    if (this.eyepiece[x].getSchemaElement().equals(current)) {
                        this.eyepiece[x].removeReferencedElement((ISchemaElement)observation);
                    }
                    if (!this.eyepiece[x].getSchemaElement().equals(observation.getEyepiece())) continue;
                    this.eyepiece[x].addReferencedElement((ISchemaElement)observation);
                }
                continue;
            }
            if (current instanceof IImager) {
                addList.add(observation.getImager());
                for (x = 0; x < this.imager.length; ++x) {
                    if (this.imager[x].getSchemaElement().equals(current)) {
                        this.imager[x].removeReferencedElement((ISchemaElement)observation);
                    }
                    if (!this.imager[x].getSchemaElement().equals(observation.getImager())) continue;
                    this.imager[x].addReferencedElement((ISchemaElement)observation);
                }
                continue;
            }
            if (current instanceof IFilter) {
                addList.add(observation.getFilter());
                for (x = 0; x < this.filter.length; ++x) {
                    if (this.filter[x].getSchemaElement().equals(current)) {
                        this.filter[x].removeReferencedElement((ISchemaElement)observation);
                    }
                    if (!this.filter[x].getSchemaElement().equals(observation.getFilter())) continue;
                    this.filter[x].addReferencedElement((ISchemaElement)observation);
                }
                continue;
            }
            if (current instanceof IScope) {
                addList.add(observation.getScope());
                for (x = 0; x < this.scope.length; ++x) {
                    if (this.scope[x].getSchemaElement().equals(current)) {
                        this.scope[x].removeReferencedElement((ISchemaElement)observation);
                    }
                    if (!this.scope[x].getSchemaElement().equals(observation.getScope())) continue;
                    this.scope[x].addReferencedElement((ISchemaElement)observation);
                }
                continue;
            }
            if (current instanceof ISession) {
                addList.add(observation.getSession());
                for (x = 0; x < this.session.length; ++x) {
                    int i;
                    IObserver currentObserver;
                    List coObservers;
                    if (this.session[x].getSchemaElement().equals(current)) {
                        this.session[x].removeReferencedElement((ISchemaElement)observation);
                        if (((ISession)current).getCoObservers() != null && !((ISession)current).getCoObservers().isEmpty()) {
                            coObservers = ((ISession)current).getCoObservers();
                            listIterator = coObservers.listIterator();
                            currentObserver = null;
                            block7: while (listIterator.hasNext()) {
                                currentObserver = (IObserver)listIterator.next();
                                for (i = 0; i < this.coObserver.length; ++i) {
                                    if (!this.coObserver[i].getSchemaElement().equals(currentObserver)) continue;
                                    this.coObserver[i].removeReferencedElement((ISchemaElement)observation);
                                    continue block7;
                                }
                            }
                        }
                    }
                    if (!this.session[x].getSchemaElement().equals(observation.getSession())) continue;
                    this.session[x].addReferencedElement((ISchemaElement)observation);
                    if (observation.getSession().getCoObservers() == null || observation.getSession().getCoObservers().isEmpty()) continue;
                    coObservers = observation.getSession().getCoObservers();
                    listIterator = coObservers.listIterator();
                    currentObserver = null;
                    block9: while (listIterator.hasNext()) {
                        currentObserver = (IObserver)listIterator.next();
                        for (i = 0; i < this.coObserver.length; ++i) {
                            if (!this.coObserver[i].getSchemaElement().equals(currentObserver)) continue;
                            this.coObserver[i].addReferencedElement((ISchemaElement)observation);
                            this.coObserver[i].addReferencedElement((ISchemaElement)observation.getSession());
                            continue block9;
                        }
                    }
                }
                continue;
            }
            if (current instanceof IObserver) {
                addList.add(observation.getObserver());
                for (x = 0; x < this.observer.length; ++x) {
                    if (this.observer[x].getSchemaElement().equals(current)) {
                        this.observer[x].removeReferencedElement((ISchemaElement)observation);
                    }
                    if (!this.observer[x].getSchemaElement().equals(observation.getObserver())) continue;
                    this.observer[x].addReferencedElement((ISchemaElement)observation);
                }
                continue;
            }
            if (current instanceof ISite) {
                addList.add(observation.getSite());
                for (x = 0; x < this.site.length; ++x) {
                    if (this.site[x].getSchemaElement().equals(current)) {
                        this.site[x].removeReferencedElement((ISchemaElement)observation);
                    }
                    if (!this.site[x].getSchemaElement().equals(observation.getSite())) continue;
                    this.site[x].addReferencedElement((ISchemaElement)observation);
                }
                continue;
            }
            if (current instanceof ITarget) {
                addList.add(observation.getTarget());
                for (x = 0; x < this.target.length; ++x) {
                    int ci;
                    ITarget ct;
                    List containingTargets;
                    if (this.target[x].getSchemaElement().equals(current)) {
                        this.target[x].removeReferencedElement((ISchemaElement)observation);
                        if (this.target[x].getSchemaElement() instanceof ITargetContaining) {
                            containingTargets = ((ITargetContaining)this.target[x].getSchemaElement()).getComponentTargets(this.getTargets());
                            listIterator = containingTargets.listIterator();
                            ct = null;
                            while (listIterator.hasNext()) {
                                ct = (ITarget)listIterator.next();
                                for (ci = 0; ci < this.target.length; ++ci) {
                                    if (!this.target[ci].getSchemaElement().equals(ct)) continue;
                                    this.target[ci].removeReferencedElement((ISchemaElement)observation);
                                }
                            }
                        }
                    }
                    if (!this.target[x].getSchemaElement().equals(observation.getTarget())) continue;
                    this.target[x].addReferencedElement((ISchemaElement)observation);
                    if (!(this.target[x].getSchemaElement() instanceof ITargetContaining)) continue;
                    containingTargets = ((ITargetContaining)this.target[x].getSchemaElement()).getComponentTargets(this.getTargets());
                    listIterator = containingTargets.listIterator();
                    ct = null;
                    while (listIterator.hasNext()) {
                        ct = (ITarget)listIterator.next();
                        for (ci = 0; ci < this.target.length; ++ci) {
                            if (!this.target[ci].getSchemaElement().equals(ct)) continue;
                            this.target[ci].addReferencedElement((ISchemaElement)observation);
                        }
                    }
                }
                continue;
            }
            if (!(current instanceof ILens)) continue;
            addList.add(observation.getLens());
            for (x = 0; x < this.lens.length; ++x) {
                if (this.lens[x].getSchemaElement().equals(current)) {
                    this.lens[x].removeReferencedElement((ISchemaElement)observation);
                }
                if (!this.lens[x].getSchemaElement().equals(observation.getLens())) continue;
                this.lens[x].addReferencedElement((ISchemaElement)observation);
            }
        }
        ListIterator removeIterator = removeList.listIterator();
        while (removeIterator.hasNext()) {
            cacheEntry.removeReferencedElement((ISchemaElement)removeIterator.next());
        }
        ListIterator addIterator = addList.listIterator();
        while (addIterator.hasNext()) {
            cacheEntry.addReferencedElement((ISchemaElement)addIterator.next());
        }
        if (!addList.contains(observation.getEyepiece())) {
            cacheEntry.addReferencedElement((ISchemaElement)observation.getEyepiece());
            for (int x = 0; x < this.eyepiece.length; ++x) {
                if (!this.eyepiece[x].getSchemaElement().equals(observation.getEyepiece())) continue;
                this.eyepiece[x].addReferencedElement((ISchemaElement)observation);
            }
        }
        if (!addList.contains(observation.getImager())) {
            cacheEntry.addReferencedElement((ISchemaElement)observation.getImager());
            for (int x = 0; x < this.imager.length; ++x) {
                if (!this.imager[x].getSchemaElement().equals(observation.getImager())) continue;
                this.imager[x].addReferencedElement((ISchemaElement)observation);
            }
        }
        if (!addList.contains(observation.getFilter())) {
            cacheEntry.addReferencedElement((ISchemaElement)observation.getFilter());
            for (int x = 0; x < this.filter.length; ++x) {
                if (!this.filter[x].getSchemaElement().equals(observation.getFilter())) continue;
                this.filter[x].addReferencedElement((ISchemaElement)observation);
            }
        }
        if (!addList.contains(observation.getObserver())) {
            cacheEntry.addReferencedElement((ISchemaElement)observation.getObserver());
            for (int x = 0; x < this.observer.length; ++x) {
                if (!this.observer[x].getSchemaElement().equals(observation.getObserver())) continue;
                this.observer[x].addReferencedElement((ISchemaElement)observation);
            }
        }
        if (!addList.contains(observation.getScope())) {
            cacheEntry.addReferencedElement((ISchemaElement)observation.getScope());
            for (int x = 0; x < this.scope.length; ++x) {
                if (!this.scope[x].getSchemaElement().equals(observation.getScope())) continue;
                this.scope[x].addReferencedElement((ISchemaElement)observation);
            }
        }
        if (!addList.contains(observation.getSession())) {
            cacheEntry.addReferencedElement((ISchemaElement)observation.getSession());
            for (int x = 0; x < this.session.length; ++x) {
                if (!this.session[x].getSchemaElement().equals(observation.getSession())) continue;
                this.session[x].addReferencedElement((ISchemaElement)observation);
                if (observation.getSession().getCoObservers() == null || observation.getSession().getCoObservers().isEmpty()) continue;
                List coObservers = observation.getSession().getCoObservers();
                ListIterator listIterator = coObservers.listIterator();
                IObserver currentObserver = null;
                block27: while (listIterator.hasNext()) {
                    currentObserver = (IObserver)listIterator.next();
                    for (int i = 0; i < this.coObserver.length; ++i) {
                        if (!this.coObserver[i].getSchemaElement().equals(currentObserver)) continue;
                        this.coObserver[i].addReferencedElement((ISchemaElement)observation);
                        continue block27;
                    }
                }
            }
        }
        if (!addList.contains(observation.getSite())) {
            cacheEntry.addReferencedElement((ISchemaElement)observation.getSite());
            for (int x = 0; x < this.site.length; ++x) {
                if (!this.site[x].getSchemaElement().equals(observation.getSite())) continue;
                this.site[x].addReferencedElement((ISchemaElement)observation);
            }
        }
        if (!addList.contains(observation.getTarget())) {
            cacheEntry.addReferencedElement((ISchemaElement)observation.getTarget());
            for (int x = 0; x < this.target.length; ++x) {
                if (!this.target[x].getSchemaElement().equals(observation.getTarget())) continue;
                this.target[x].addReferencedElement((ISchemaElement)observation);
            }
        }
        if (!addList.contains(observation.getLens())) {
            cacheEntry.addReferencedElement((ISchemaElement)observation.getLens());
            for (int x = 0; x < this.lens.length; ++x) {
                if (!this.lens[x].getSchemaElement().equals(observation.getLens())) continue;
                this.lens[x].addReferencedElement((ISchemaElement)observation);
            }
        }
    }

    public void updateSession(IObservation[] observations, ISession session) {
        List oldReferedElements = null;
        ListIterator oldReferedElementsIterator = null;
        ISchemaElement currentSE = null;
        ArrayList<Object> removeList = new ArrayList<Object>();
        for (int i = 0; i < this.coObserver.length; ++i) {
            oldReferedElements = this.coObserver[i].getReferencedElements();
            oldReferedElementsIterator = oldReferedElements.listIterator();
            while (oldReferedElementsIterator.hasNext()) {
                currentSE = (ISchemaElement)oldReferedElementsIterator.next();
                if (!(currentSE instanceof ISession) || !session.getID().equals(currentSE.getID()) || session.getCoObservers().contains(this.coObserver[i].getSchemaElement())) continue;
                removeList.add(session);
                removeList.addAll(Arrays.asList(observations));
            }
            this.coObserver[i].removeReferencedElements(removeList);
            removeList.clear();
            if (!session.getCoObservers().contains(this.coObserver[i].getSchemaElement()) || this.coObserver[i].getReferencedElements().contains(session)) continue;
            this.coObserver[i].addReferencedElements(Arrays.asList(observations));
            this.coObserver[i].addReferencedElement((ISchemaElement)session);
        }
    }

    public void updateTarget(ITarget target) {
        List newComponents = ((ITargetContaining)target).getComponentTargets(this.getTargets());
        ArrayList oldComponents = new ArrayList();
        for (int x = 0; x < this.targetContaining.length; ++x) {
            if (!this.targetContaining[x].getSchemaElement().equals(target)) continue;
            oldComponents = new ArrayList(this.targetContaining[x].getReferencedElements());
            this.targetContaining[x].clearAllReferences();
            this.targetContaining[x].addReferencedElements(((ITargetContaining)target).getComponentTargets(this.getTargets()));
            break;
        }
        if (oldComponents.containsAll(newComponents) && newComponents.containsAll(oldComponents)) {
            return;
        }
        ArrayList removedComponent = new ArrayList(oldComponents);
        ArrayList<ITarget> addedComponent = new ArrayList<ITarget>();
        ListIterator newIterator = newComponents.listIterator();
        ITarget current = null;
        while (newIterator.hasNext()) {
            current = (ITarget)newIterator.next();
            if (!removedComponent.contains(current)) {
                addedComponent.add(current);
                continue;
            }
            removedComponent.remove(current);
        }
        ListIterator addedIterator = addedComponent.listIterator();
        ITarget addedTarget = null;
        block2: while (addedIterator.hasNext()) {
            addedTarget = (ITarget)addedIterator.next();
            for (int i = 0; i < this.target.length; ++i) {
                if (!addedTarget.equals(this.target[i].getSchemaElement())) continue;
                List observation = this.getReferedElements((ISchemaElement)target);
                this.target[i].addReferencedElements(observation);
                continue block2;
            }
        }
        ListIterator removedterator = removedComponent.listIterator();
        ITarget removedTarget = null;
        block4: while (removedterator.hasNext()) {
            removedTarget = (ITarget)removedterator.next();
            for (int i = 0; i < this.target.length; ++i) {
                if (!removedTarget.equals(this.target[i].getSchemaElement())) continue;
                List observation = this.getReferedElements((ISchemaElement)target);
                this.target[i].removeReferencedElements(observation);
                continue block4;
            }
        }
    }

    public List removeEyepiece(IEyepiece eyepiece) {
        ArrayList<ISchemaElement> dependencyList = new ArrayList<ISchemaElement>();
        SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.eyepiece.length - 1];
        boolean foundDependency = false;
        boolean foundElement = false;
        for (int i = 0; i < this.eyepiece.length; ++i) {
            if (this.eyepiece[i].getSchemaElement().equals(eyepiece)) {
                foundElement = true;
                IEyepiece e = null;
                for (int j = 0; j < this.observation.length; ++j) {
                    e = ((IObservation)this.observation[j].getSchemaElement()).getEyepiece();
                    if (e == null || !e.equals(eyepiece)) continue;
                    foundDependency = true;
                    dependencyList.add(this.observation[j].getSchemaElement());
                }
                continue;
            }
            if (foundElement && !foundDependency) {
                newArray[i - 1] = this.eyepiece[i];
                continue;
            }
            if (i >= newArray.length) continue;
            newArray[i] = this.eyepiece[i];
        }
        if (foundElement && !foundDependency) {
            this.eyepiece = newArray;
        }
        return dependencyList;
    }

    public List removeImager(IImager imager) {
        ArrayList<ISchemaElement> dependencyList = new ArrayList<ISchemaElement>();
        SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.imager.length - 1];
        boolean foundDependency = false;
        boolean foundElement = false;
        for (int i = 0; i < this.imager.length; ++i) {
            if (this.imager[i].getSchemaElement().equals(imager)) {
                foundElement = true;
                IImager e = null;
                for (int j = 0; j < this.observation.length; ++j) {
                    e = ((IObservation)this.observation[j].getSchemaElement()).getImager();
                    if (e == null || !e.equals(imager)) continue;
                    foundDependency = true;
                    dependencyList.add(this.observation[j].getSchemaElement());
                }
                continue;
            }
            if (foundElement && !foundDependency) {
                newArray[i - 1] = this.imager[i];
                continue;
            }
            if (i >= newArray.length) continue;
            newArray[i] = this.imager[i];
        }
        if (foundElement && !foundDependency) {
            this.imager = newArray;
        }
        return dependencyList;
    }

    public List removeFilter(IFilter filter) {
        ArrayList<ISchemaElement> dependencyList = new ArrayList<ISchemaElement>();
        SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.filter.length - 1];
        boolean foundDependency = false;
        boolean foundElement = false;
        for (int i = 0; i < this.filter.length; ++i) {
            if (this.filter[i].getSchemaElement().equals(filter)) {
                foundElement = true;
                IFilter e = null;
                for (int j = 0; j < this.observation.length; ++j) {
                    e = ((IObservation)this.observation[j].getSchemaElement()).getFilter();
                    if (e == null || !e.equals(filter)) continue;
                    foundDependency = true;
                    dependencyList.add(this.observation[j].getSchemaElement());
                }
                continue;
            }
            if (foundElement && !foundDependency) {
                newArray[i - 1] = this.filter[i];
                continue;
            }
            if (i >= newArray.length) continue;
            newArray[i] = this.filter[i];
        }
        if (foundElement && !foundDependency) {
            this.filter = newArray;
        }
        return dependencyList;
    }

    public List removeObservation(IObservation observation) {
        ILens lens;
        ITarget target;
        ISite site;
        ISession session;
        IScope scope;
        IObserver observer;
        IFilter filter;
        IImager imager;
        SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.observation.length - 1];
        boolean foundElement = false;
        for (int i = 0; i < this.observation.length; ++i) {
            if (this.observation[i].getSchemaElement().equals(observation)) {
                foundElement = true;
                continue;
            }
            if (foundElement) {
                newArray[i - 1] = this.observation[i];
                continue;
            }
            if (i >= newArray.length) continue;
            newArray[i] = this.observation[i];
        }
        if (!foundElement) {
            return new ArrayList();
        }
        this.observation = newArray;
        IEyepiece e = observation.getEyepiece();
        if (e != null) {
            for (int i = 0; i < this.eyepiece.length; ++i) {
                if (!e.equals(this.eyepiece[i].getSchemaElement())) continue;
                this.eyepiece[i].removeReferencedElement((ISchemaElement)observation);
                break;
            }
        }
        if ((imager = observation.getImager()) != null) {
            for (int i = 0; i < this.imager.length; ++i) {
                if (!imager.equals(this.imager[i].getSchemaElement())) continue;
                this.imager[i].removeReferencedElement((ISchemaElement)observation);
                break;
            }
        }
        if ((filter = observation.getFilter()) != null) {
            for (int i = 0; i < this.filter.length; ++i) {
                if (!filter.equals(this.filter[i].getSchemaElement())) continue;
                this.filter[i].removeReferencedElement((ISchemaElement)observation);
                break;
            }
        }
        if ((observer = observation.getObserver()) != null) {
            for (int i = 0; i < this.observer.length; ++i) {
                if (!observer.equals(this.observer[i].getSchemaElement())) continue;
                this.observer[i].removeReferencedElement((ISchemaElement)observation);
                break;
            }
        }
        if ((scope = observation.getScope()) != null) {
            for (int i = 0; i < this.scope.length; ++i) {
                if (!scope.equals(this.scope[i].getSchemaElement())) continue;
                this.scope[i].removeReferencedElement((ISchemaElement)observation);
                break;
            }
        }
        if ((session = observation.getSession()) != null) {
            for (int i = 0; i < this.session.length; ++i) {
                if (session.getCoObservers() != null && !session.getCoObservers().isEmpty()) {
                    List coObservers = session.getCoObservers();
                    ListIterator iterator = coObservers.listIterator();
                    IObserver current = null;
                    block7: while (iterator.hasNext()) {
                        current = (IObserver)iterator.next();
                        int x = 0;
                        while (i < this.coObserver.length) {
                            if (this.coObserver[x].getSchemaElement().equals(current)) {
                                this.coObserver[x].removeReferencedElement((ISchemaElement)observation);
                                continue block7;
                            }
                            ++x;
                        }
                    }
                }
                if (!session.equals(this.session[i].getSchemaElement())) continue;
                this.session[i].removeReferencedElement((ISchemaElement)observation);
                break;
            }
        }
        if ((site = observation.getSite()) != null) {
            for (int i = 0; i < this.site.length; ++i) {
                if (!site.equals(this.site[i].getSchemaElement())) continue;
                this.site[i].removeReferencedElement((ISchemaElement)observation);
                break;
            }
        }
        if ((target = observation.getTarget()) != null) {
            for (int i = 0; i < this.target.length; ++i) {
                if (!target.equals(this.target[i].getSchemaElement())) continue;
                this.target[i].removeReferencedElement((ISchemaElement)observation);
                if (!(this.target[i].getSchemaElement() instanceof ITargetContaining)) break;
                List containingTargets = ((ITargetContaining)this.target[i].getSchemaElement()).getComponentTargets(this.getTargets());
                ListIterator listIterator = containingTargets.listIterator();
                ITarget ct = null;
                while (listIterator.hasNext()) {
                    ct = (ITarget)listIterator.next();
                    for (int ci = 0; ci < this.target.length; ++ci) {
                        if (!this.target[ci].getSchemaElement().equals(ct)) continue;
                        this.target[ci].removeReferencedElement((ISchemaElement)observation);
                    }
                }
                break;
            }
        }
        if ((lens = observation.getLens()) != null) {
            for (int i = 0; i < this.lens.length; ++i) {
                if (!lens.equals(this.lens[i].getSchemaElement())) continue;
                this.lens[i].removeReferencedElement((ISchemaElement)observation);
                break;
            }
        }
        return new ArrayList();
    }

    public List removeObserver(IObserver observer) {
        ArrayList<ISchemaElement> dependencyList = new ArrayList<ISchemaElement>();
        SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.observer.length - 1];
        SchemaElementCacheEntry[] newCoObserverArray = new SchemaElementCacheEntry[this.coObserver.length - 1];
        boolean foundDependency = false;
        boolean foundElement = false;
        for (int i = 0; i < this.observer.length; ++i) {
            if (this.observer[i].getSchemaElement().equals(observer)) {
                foundElement = true;
                IObserver e = null;
                for (int j = 0; j < this.observation.length; ++j) {
                    e = ((IObservation)this.observation[j].getSchemaElement()).getObserver();
                    if (e == null || !e.equals(observer)) continue;
                    foundDependency = true;
                    dependencyList.add(this.observation[j].getSchemaElement());
                }
                List coObs = null;
                block2: for (int j = 0; j < this.session.length; ++j) {
                    coObs = ((ISession)this.session[j].getSchemaElement()).getCoObservers();
                    if (coObs == null || coObs.isEmpty()) continue;
                    ListIterator iterator = coObs.listIterator();
                    while (iterator.hasNext()) {
                        if (!observer.equals(iterator.next())) continue;
                        foundDependency = true;
                        dependencyList.add(this.session[j].getSchemaElement());
                        continue block2;
                    }
                }
                continue;
            }
            if (foundElement && !foundDependency) {
                newArray[i - 1] = this.observer[i];
                newCoObserverArray[i - 1] = this.coObserver[i];
                continue;
            }
            if (i >= newArray.length) continue;
            newArray[i] = this.observer[i];
            newCoObserverArray[i] = this.coObserver[i];
        }
        if (foundElement && !foundDependency) {
            this.observer = newArray;
            this.coObserver = newCoObserverArray;
        }
        return dependencyList;
    }

    public List removeScope(IScope scope) {
        ArrayList<ISchemaElement> dependencyList = new ArrayList<ISchemaElement>();
        SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.scope.length - 1];
        boolean foundDependency = false;
        boolean foundElement = false;
        for (int i = 0; i < this.scope.length; ++i) {
            if (this.scope[i].getSchemaElement().equals(scope)) {
                foundElement = true;
                IScope e = null;
                for (int j = 0; j < this.observation.length; ++j) {
                    e = ((IObservation)this.observation[j].getSchemaElement()).getScope();
                    if (e == null || !e.equals(scope)) continue;
                    foundDependency = true;
                    dependencyList.add(this.observation[j].getSchemaElement());
                }
                continue;
            }
            if (foundElement && !foundDependency) {
                newArray[i - 1] = this.scope[i];
                continue;
            }
            if (i >= newArray.length) continue;
            newArray[i] = this.scope[i];
        }
        if (foundElement && !foundDependency) {
            this.scope = newArray;
        }
        return dependencyList;
    }

    public List removeSession(ISession session) {
        ArrayList<ISchemaElement> dependencyList = new ArrayList<ISchemaElement>();
        SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.session.length - 1];
        boolean foundDependency = false;
        boolean foundElement = false;
        for (int i = 0; i < this.session.length; ++i) {
            if (this.session[i].getSchemaElement().equals(session)) {
                foundElement = true;
                ISession e = null;
                for (int j = 0; j < this.observation.length; ++j) {
                    e = ((IObservation)this.observation[j].getSchemaElement()).getSession();
                    if (e == null || !e.equals(session)) continue;
                    foundDependency = true;
                    dependencyList.add(this.observation[j].getSchemaElement());
                }
                continue;
            }
            if (foundElement && !foundDependency) {
                newArray[i - 1] = this.session[i];
                continue;
            }
            if (i >= newArray.length) continue;
            newArray[i] = this.session[i];
        }
        if (foundElement && !foundDependency) {
            this.session = newArray;
        }
        return dependencyList;
    }

    public List removeSite(ISite site) {
        ArrayList<ISchemaElement> dependencyList = new ArrayList<ISchemaElement>();
        SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.site.length - 1];
        boolean foundDependency = false;
        boolean foundElement = false;
        for (int i = 0; i < this.site.length; ++i) {
            if (this.site[i].getSchemaElement().equals(site)) {
                int j;
                foundElement = true;
                ISite e = null;
                for (j = 0; j < this.observation.length; ++j) {
                    e = ((IObservation)this.observation[j].getSchemaElement()).getSite();
                    if (e == null || !e.equals(site)) continue;
                    foundDependency = true;
                    dependencyList.add(this.observation[j].getSchemaElement());
                }
                for (j = 0; j < this.session.length; ++j) {
                    e = ((ISession)this.session[j].getSchemaElement()).getSite();
                    if (e == null || !e.equals(site)) continue;
                    foundDependency = true;
                    dependencyList.add(this.session[j].getSchemaElement());
                }
                continue;
            }
            if (foundElement && !foundDependency) {
                newArray[i - 1] = this.site[i];
                continue;
            }
            if (i >= newArray.length) continue;
            newArray[i] = this.site[i];
        }
        if (foundElement && !foundDependency) {
            this.site = newArray;
        }
        return dependencyList;
    }

    public List removeTarget(ITarget target) {
        ArrayList<ISchemaElement> dependencyList = new ArrayList<ISchemaElement>();
        SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.target.length - 1];
        boolean foundDependency = false;
        boolean foundElement = false;
        for (int i = 0; i < this.target.length; ++i) {
            if (this.target[i].getSchemaElement().equals(target)) {
                foundElement = true;
                ITarget e = null;
                for (int j = 0; j < this.observation.length; ++j) {
                    e = ((IObservation)this.observation[j].getSchemaElement()).getTarget();
                    if (e == null || !e.equalsID((Object)target)) continue;
                    foundDependency = true;
                    dependencyList.add(this.observation[j].getSchemaElement());
                }
                continue;
            }
            if (this.target[i].getSchemaElement() instanceof ITargetContaining) {
                List containingTargets = ((ITargetContaining)this.target[i].getSchemaElement()).getComponentTargets(this.getTargets());
                ListIterator listIterator = containingTargets.listIterator();
                ITarget ct = null;
                while (listIterator.hasNext()) {
                    ct = (ITarget)listIterator.next();
                    if (!ct.equals(target)) continue;
                    foundDependency = true;
                    dependencyList.add(this.target[i].getSchemaElement());
                }
            }
            if (foundElement && !foundDependency) {
                newArray[i - 1] = this.target[i];
                continue;
            }
            if (i >= newArray.length) continue;
            newArray[i] = this.target[i];
        }
        if (foundElement && !foundDependency) {
            this.target = newArray;
            ArrayList<SchemaElementCacheEntry> tcList = new ArrayList<SchemaElementCacheEntry>(Arrays.asList(this.targetContaining));
            for (int i = 0; i < this.targetContaining.length; ++i) {
                if (!target.equals(this.targetContaining[i].getSchemaElement())) continue;
                tcList.remove(this.targetContaining[i]);
                break;
            }
            this.targetContaining = tcList.toArray(new SchemaElementCacheEntry[0]);
        }
        return dependencyList;
    }

    public List removeLens(ILens lens) {
        ArrayList<ISchemaElement> dependencyList = new ArrayList<ISchemaElement>();
        SchemaElementCacheEntry[] newArray = new SchemaElementCacheEntry[this.lens.length - 1];
        boolean foundDependency = false;
        boolean foundElement = false;
        for (int i = 0; i < this.lens.length; ++i) {
            if (this.lens[i].getSchemaElement().equals(lens)) {
                foundElement = true;
                ILens e = null;
                for (int j = 0; j < this.observation.length; ++j) {
                    e = ((IObservation)this.observation[j].getSchemaElement()).getLens();
                    if (e == null || !e.equals(lens)) continue;
                    foundDependency = true;
                    dependencyList.add(this.observation[j].getSchemaElement());
                }
                continue;
            }
            if (foundElement && !foundDependency) {
                newArray[i - 1] = this.lens[i];
                continue;
            }
            if (i >= newArray.length) continue;
            newArray[i] = this.lens[i];
        }
        if (foundElement && !foundDependency) {
            this.lens = newArray;
        }
        return dependencyList;
    }

    public void setXMLPath(String path) {
        this.xmlPath = path;
    }

    private boolean doublicateCheck(SchemaElementCacheEntry[] array, ISchemaElement e) {
        if (array == null || e == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].getSchemaElement().equals(e)) continue;
            return true;
        }
        return false;
    }

    private void addAllObservationElements(SchemaElementCacheEntry observationCacheEntry) {
        ILens l;
        ITarget t;
        ISite si;
        ISession s;
        IScope sc;
        IObserver o;
        IImager im;
        IFilter f;
        IObservation observation = (IObservation)observationCacheEntry.getSchemaElement();
        if (observation == null) {
            return;
        }
        IEyepiece e = observation.getEyepiece();
        if (e != null) {
            for (int x = 0; x < this.eyepiece.length; ++x) {
                if (!this.eyepiece[x].getSchemaElement().equals(e)) continue;
                this.eyepiece[x].addReferencedElement((ISchemaElement)observation);
                observationCacheEntry.addReferencedElement((ISchemaElement)e);
                break;
            }
        }
        if ((f = observation.getFilter()) != null) {
            for (int x = 0; x < this.filter.length; ++x) {
                if (!this.filter[x].getSchemaElement().equals(f)) continue;
                this.filter[x].addReferencedElement((ISchemaElement)observation);
                observationCacheEntry.addReferencedElement((ISchemaElement)f);
                break;
            }
        }
        if ((im = observation.getImager()) != null) {
            for (int x = 0; x < this.imager.length; ++x) {
                if (!this.imager[x].getSchemaElement().equals(im)) continue;
                this.imager[x].addReferencedElement((ISchemaElement)observation);
                observationCacheEntry.addReferencedElement((ISchemaElement)im);
                break;
            }
        }
        if ((o = observation.getObserver()) != null) {
            for (int x = 0; x < this.observer.length; ++x) {
                if (!this.observer[x].getSchemaElement().equals(o)) continue;
                this.observer[x].addReferencedElement((ISchemaElement)observation);
                observationCacheEntry.addReferencedElement((ISchemaElement)o);
                break;
            }
        }
        if ((sc = observation.getScope()) != null) {
            for (int x = 0; x < this.scope.length; ++x) {
                if (!this.scope[x].getSchemaElement().equals(sc)) continue;
                this.scope[x].addReferencedElement((ISchemaElement)observation);
                observationCacheEntry.addReferencedElement((ISchemaElement)sc);
                break;
            }
        }
        if ((s = observation.getSession()) != null) {
            for (int x = 0; x < this.session.length; ++x) {
                if (!this.session[x].getSchemaElement().equals(s)) continue;
                if (s.getCoObservers() != null && !s.getCoObservers().isEmpty()) {
                    List coObservers = s.getCoObservers();
                    ListIterator iterator = coObservers.listIterator();
                    IObserver current = null;
                    block6: while (iterator.hasNext()) {
                        current = (IObserver)iterator.next();
                        for (int i = 0; i < this.coObserver.length; ++i) {
                            if (!this.coObserver[i].getSchemaElement().equals(current)) continue;
                            this.coObserver[i].addReferencedElement((ISchemaElement)observation);
                            if (this.coObserver[i].contains((ISchemaElement)observation.getSession())) continue block6;
                            this.coObserver[i].addReferencedElement((ISchemaElement)observation.getSession());
                            continue block6;
                        }
                    }
                }
                this.session[x].addReferencedElement((ISchemaElement)observation);
                observationCacheEntry.addReferencedElement((ISchemaElement)s);
                break;
            }
        }
        if ((si = observation.getSite()) != null) {
            for (int x = 0; x < this.site.length; ++x) {
                if (!this.site[x].getSchemaElement().equals(si)) continue;
                this.site[x].addReferencedElement((ISchemaElement)observation);
                observationCacheEntry.addReferencedElement((ISchemaElement)si);
                break;
            }
        }
        if ((t = observation.getTarget()) != null) {
            for (int x = 0; x < this.target.length; ++x) {
                if (!this.target[x].getSchemaElement().equals(t)) continue;
                this.target[x].addReferencedElement((ISchemaElement)observation);
                if (t instanceof ITargetContaining) {
                    List containedTargets = ((ITargetContaining)t).getComponentTargets(this.getTargets());
                    ListIterator iterator = containedTargets.listIterator();
                    ITarget ct = null;
                    while (iterator.hasNext()) {
                        ct = (ITarget)iterator.next();
                        for (int cx = 0; cx < this.target.length; ++cx) {
                            if (!this.target[cx].getSchemaElement().equals(ct)) continue;
                            this.target[cx].addReferencedElement((ISchemaElement)observation);
                        }
                    }
                }
                observationCacheEntry.addReferencedElement((ISchemaElement)t);
                break;
            }
        }
        if ((l = observation.getLens()) != null) {
            for (int x = 0; x < this.lens.length; ++x) {
                if (!this.lens[x].getSchemaElement().equals(l)) continue;
                this.lens[x].addReferencedElement((ISchemaElement)observation);
                observationCacheEntry.addReferencedElement((ISchemaElement)l);
                break;
            }
        }
    }
}

