/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.statistics;

import de.lehmannet.om.IObservation;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ui.dialog.AbstractDialog;
import de.lehmannet.om.ui.dialog.ProgressDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.statistics.DetailPanel;
import de.lehmannet.om.ui.statistics.ObservationStatisticsTableModel;
import de.lehmannet.om.ui.statistics.TargetObservations;
import de.lehmannet.om.ui.util.Worker;
import de.lehmannet.om.ui.util.XMLFileLoader;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.w3c.dom.Document;

public class StatisticsDetailsDialog
extends AbstractDialog {
    private static final long serialVersionUID = -9088082984657164772L;
    private TargetObservations[] targetObservations = null;
    private String catalogName = null;
    private JMenu exportMenu = null;
    private JMenu exportObserved = null;
    private JMenu exportMissing = null;
    private JMenuItem exportObservedOAL = null;
    private JMenuItem exportObservedHTML = null;
    private JMenuItem exportMissingOAL = null;
    private JMenuItem exportMissingHTML = null;

    public StatisticsDetailsDialog(ObservationManager om, ObservationStatisticsTableModel model) {
        super(om, new DetailPanel(om, model), true);
        this.targetObservations = model.getTargetObservations();
        this.catalogName = model.getCatalogName();
        Cursor defaultCursor = new Cursor(3);
        om.setCursor(defaultCursor);
        super.setCursor(defaultCursor);
        super.setTitle(AbstractDialog.bundle.getString("dialog.statistics.title"));
        this.cancel.setText(AbstractDialog.bundle.getString("dialog.button.ok"));
        super.setSize(-9088082984657164772L, 400, 310);
        defaultCursor = new Cursor(0);
        om.setCursor(defaultCursor);
        super.setCursor(defaultCursor);
        this.createMenu();
        super.setVisible(true);
    }

    private void createMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.exportMenu = new JMenu(AbstractDialog.bundle.getString("dialog.statistics.menu.title"));
        this.exportMenu.setMnemonic('e');
        menuBar.add(this.exportMenu);
        this.exportObserved = new JMenu(AbstractDialog.bundle.getString("dialog.statistics.menu.observed"));
        this.exportObserved.setMnemonic('o');
        this.exportMenu.add(this.exportObserved);
        this.exportMissing = new JMenu(AbstractDialog.bundle.getString("dialog.statistics.menu.missing"));
        this.exportMissing.setMnemonic('m');
        this.exportMenu.add(this.exportMissing);
        this.exportObservedOAL = new JMenuItem(AbstractDialog.bundle.getString("dialog.statistics.menu.observed.xml"));
        this.exportObservedOAL.setMnemonic('x');
        this.exportObservedOAL.addActionListener(this);
        this.exportObserved.add(this.exportObservedOAL);
        this.exportObservedHTML = new JMenuItem(AbstractDialog.bundle.getString("dialog.statistics.menu.observed.html"));
        this.exportObservedHTML.setMnemonic('h');
        this.exportObservedHTML.addActionListener(this);
        this.exportObserved.add(this.exportObservedHTML);
        this.exportMissingOAL = new JMenuItem(AbstractDialog.bundle.getString("dialog.statistics.menu.missing.xml"));
        this.exportMissingOAL.setMnemonic('a');
        this.exportMissingOAL.addActionListener(this);
        this.exportMissing.add(this.exportMissingOAL);
        this.exportMissingHTML = new JMenuItem(AbstractDialog.bundle.getString("dialog.statistics.menu.missing.html"));
        this.exportMissingHTML.setMnemonic('t');
        this.exportMissingHTML.addActionListener(this);
        this.exportMissing.add(this.exportMissingHTML);
        this.setJMenuBar(menuBar);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JMenuItem) {
            if (source.equals(this.exportObservedOAL)) {
                this.exportObservedAsXML();
            } else if (source.equals(this.exportObservedHTML)) {
                this.exportObservedAsHTML();
            } else if (source.equals(this.exportMissingOAL)) {
                this.exportMissingTargetAsXML();
            } else if (source.equals(this.exportMissingHTML)) {
                this.exportMissingTargetAsHTML();
            }
        }
        super.actionPerformed(e);
    }

    private void exportObservedAsXML() {
        Worker calculation = new Worker(){
            private String message = null;
            private byte returnValue = 0;

            public void run() {
                XMLFileLoader xmlHelper = new XMLFileLoader(new File(".exportTempFile"));
                List observations = null;
                ListIterator iterator = null;
                for (int x = 0; x < StatisticsDetailsDialog.this.targetObservations.length; ++x) {
                    if (StatisticsDetailsDialog.this.targetObservations[x].getObservations() == null) continue;
                    observations = StatisticsDetailsDialog.this.targetObservations[x].getObservations();
                    iterator = observations.listIterator();
                    while (iterator.hasNext()) {
                        xmlHelper.addSchemaElement((ISchemaElement)((IObservation)iterator.next()), true);
                    }
                }
                String file = StatisticsDetailsDialog.this.getExportFile(StatisticsDetailsDialog.this.catalogName + "_observed", "xml").getAbsolutePath();
                boolean result = xmlHelper.save(file);
                if (result) {
                    this.message = bundle.getString("dialog.statistics.observed.export.ok") + file;
                    this.returnValue = 0;
                } else {
                    this.message = bundle.getString("dialog.statistics.observed.export.nok");
                    this.returnValue = (byte)2;
                }
            }

            public String getReturnMessage() {
                return this.message;
            }

            public byte getReturnType() {
                return this.returnValue;
            }
        };
        new ProgressDialog(this.observationManager, AbstractDialog.bundle.getString("progress.wait.title"), AbstractDialog.bundle.getString("progress.wait.xml.info"), calculation);
        if (calculation.getReturnType() == 0) {
            if (calculation.getReturnMessage() != null) {
                this.observationManager.createInfo(calculation.getReturnMessage());
            }
        } else {
            this.observationManager.createWarning(calculation.getReturnMessage());
        }
    }

    private void exportObservedAsHTML() {
        final XMLFileLoader xmlHelper = new XMLFileLoader(new File(".exportTempFile"));
        Worker calculation = new Worker(){
            private String message = null;
            private byte returnValue = 0;

            public void run() {
                List observations = null;
                ListIterator iterator = null;
                for (int x = 0; x < StatisticsDetailsDialog.this.targetObservations.length; ++x) {
                    if (StatisticsDetailsDialog.this.targetObservations[x].getObservations() == null) continue;
                    observations = StatisticsDetailsDialog.this.targetObservations[x].getObservations();
                    iterator = observations.listIterator();
                    while (iterator.hasNext()) {
                        xmlHelper.addSchemaElement((ISchemaElement)((IObservation)iterator.next()), true);
                    }
                }
            }

            public String getReturnMessage() {
                return this.message;
            }

            public byte getReturnType() {
                return this.returnValue;
            }
        };
        new ProgressDialog(this.observationManager, AbstractDialog.bundle.getString("progress.wait.title"), AbstractDialog.bundle.getString("progress.wait.html.info"), calculation);
        if (calculation.getReturnType() == 0) {
            if (calculation.getReturnMessage() != null) {
                this.observationManager.createInfo(calculation.getReturnMessage());
            }
        } else {
            this.observationManager.createWarning(calculation.getReturnMessage());
        }
        this.observationManager.createHTML(xmlHelper.getDocument(), this.getExportFile(this.catalogName + "_observed", "html"), null);
    }

    private void exportMissingTargetAsXML() {
        Worker calculation = new Worker(){
            private String message = null;
            private byte returnValue = 0;

            public void run() {
                XMLFileLoader xmlHelper = new XMLFileLoader(new File(".exportTempFile"));
                for (int x = 0; x < StatisticsDetailsDialog.this.targetObservations.length; ++x) {
                    if (StatisticsDetailsDialog.this.targetObservations[x].getObservations() != null) continue;
                    xmlHelper.addSchemaElement((ISchemaElement)StatisticsDetailsDialog.this.targetObservations[x].getTarget());
                }
                String file = StatisticsDetailsDialog.this.getExportFile(StatisticsDetailsDialog.this.catalogName + "_missing", "xml").getAbsolutePath();
                boolean result = xmlHelper.save(file);
                if (result) {
                    this.message = bundle.getString("dialog.statistics.missing.export.ok") + file;
                    this.returnValue = 0;
                } else {
                    this.message = bundle.getString("dialog.statistics.missing.export.nok");
                    this.returnValue = (byte)2;
                }
            }

            public String getReturnMessage() {
                return this.message;
            }

            public byte getReturnType() {
                return this.returnValue;
            }
        };
        new ProgressDialog(this.observationManager, AbstractDialog.bundle.getString("progress.wait.title"), AbstractDialog.bundle.getString("progress.wait.xml.info"), calculation);
        if (calculation.getReturnType() == 0) {
            if (calculation.getReturnMessage() != null) {
                this.observationManager.createInfo(calculation.getReturnMessage());
            }
        } else {
            this.observationManager.createWarning(calculation.getReturnMessage());
        }
    }

    private void exportMissingTargetAsHTML() {
        class MyWorker
        implements Worker {
            private String message = null;
            private byte returnValue = 0;
            private XMLFileLoader xmlHelper = new XMLFileLoader(new File(".exportTempFile"));
            private Document document = null;

            MyWorker() {
            }

            public void run() {
                for (int x = 0; x < StatisticsDetailsDialog.this.targetObservations.length; ++x) {
                    if (StatisticsDetailsDialog.this.targetObservations[x].getObservations() != null) continue;
                    this.xmlHelper.addSchemaElement((ISchemaElement)StatisticsDetailsDialog.this.targetObservations[x].getTarget());
                }
                this.document = this.xmlHelper.getDocument();
            }

            public String getReturnMessage() {
                return this.message;
            }

            public byte getReturnType() {
                return this.returnValue;
            }

            public Document getDocument() {
                return this.document;
            }
        }
        MyWorker calculation = new MyWorker();
        new ProgressDialog(this.observationManager, AbstractDialog.bundle.getString("progress.wait.title"), AbstractDialog.bundle.getString("progress.wait.html.info"), calculation);
        if (calculation.getReturnType() == 0) {
            if (calculation.getReturnMessage() != null) {
                this.observationManager.createInfo(calculation.getReturnMessage());
            }
        } else {
            this.observationManager.createWarning(calculation.getReturnMessage());
        }
        this.observationManager.createHTML(calculation.getDocument(), this.getExportFile(this.catalogName + "_missing", "html"), this.getXSLFile());
    }

    private File getExportFile(String filename, String extension) {
        String path = null;
        path = this.observationManager.getXmlCache().getAllOpenedFiles() != null && this.observationManager.getXmlCache().getAllOpenedFiles().length > 0 ? new File(this.observationManager.getXmlCache().getAllOpenedFiles()[0]).getParent() : this.observationManager.getInstallDir().getParent();
        path = path + File.separator;
        File file = new File(path + filename + "." + extension);
        int i = 2;
        while (file.exists()) {
            file = new File(path + filename + "(" + i + ")." + extension);
            ++i;
        }
        return file;
    }

    private File getXSLFile() {
        File path;
        String XSLFILENAME = "targetsOnly";
        String selectedTemplate = this.observationManager.getConfiguration().getConfig("om.transform.xsl.template");
        if (selectedTemplate == null || "".equals(selectedTemplate.trim())) {
            selectedTemplate = "oal2html";
        }
        if (!(path = new File(this.observationManager.getInstallDir().getAbsolutePath() + File.separator + "xsl" + File.separator + selectedTemplate + File.separator + "targetOnly")).exists()) {
            this.observationManager.createWarning(AbstractDialog.bundle.getString("warning.xslTemplate.dirDoesNotExist") + "\n" + path.getAbsolutePath());
            return null;
        }
        File xslFile = new File(path.getAbsolutePath() + File.separator + XSLFILENAME + "_" + Locale.getDefault().getLanguage() + ".xsl");
        if (!xslFile.exists() && !(xslFile = new File(path.getAbsolutePath() + File.separator + XSLFILENAME + ".xsl")).exists()) {
            this.observationManager.createWarning(AbstractDialog.bundle.getString("warning.xslTemplate.noFileFoundWithName") + "\n" + path.getAbsolutePath() + File.separator + "targetsOnly" + ".xsl\n" + path.getAbsolutePath() + File.separator + "targetsOnly" + "_" + Locale.getDefault().getLanguage() + ".xsl");
            return null;
        }
        return xslFile;
    }
}

