/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.panel;

import de.lehmannet.om.ui.panel.AbstractPanel;
import de.lehmannet.om.ui.panel.AccountListRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;

class AccountTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8689281626651639913L;
    private String[] accounts = new String[0];
    private String[] userNames = new String[0];
    private boolean tableEditable = false;
    private JComboBox box = null;

    public AccountTableModel(HashMap map, boolean tableEditable, JComboBox box) {
        if (map.size() > this.accounts.length) {
            this.accounts = new String[map.size()];
            this.userNames = new String[map.size()];
        }
        Iterator iterator = map.keySet().iterator();
        String currentAccount = null;
        int i = 0;
        while (iterator.hasNext()) {
            this.accounts[i] = currentAccount = (String)iterator.next();
            this.userNames[i++] = (String)map.get(currentAccount);
        }
        this.tableEditable = tableEditable;
        this.box = box;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.accounts.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                String value = this.accounts[rowIndex];
                if ("".equals(value) || value == null) {
                    this.box.setEditable(true);
                    return AccountListRenderer.EMPTY_LIST_ENTRY;
                }
                return value;
            }
            case 1: {
                String value = this.userNames[rowIndex];
                if ("".equals(value)) {
                    return "";
                }
                return value;
            }
        }
        return "";
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            if (!Arrays.asList(this.accounts).contains(value)) {
                this.accounts[row] = (String)value;
            }
        } else {
            this.userNames[row] = (String)value;
        }
        this.fireTableCellUpdated(row, col);
    }

    public String getColumnName(int column) {
        String name = "";
        switch (column) {
            case 0: {
                name = AbstractPanel.bundle.getString("table.header.observerAccount.account");
                break;
            }
            case 1: {
                name = AbstractPanel.bundle.getString("table.header.observerAccount.username");
            }
        }
        return name;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.tableEditable;
    }

    public HashMap getAllEntries() {
        HashMap<String, String> result = new HashMap<String, String>();
        String account = null;
        String user = null;
        for (int i = 0; i < this.accounts.length; ++i) {
            account = this.accounts[i];
            if (account == null || "".equals(account) || AccountListRenderer.EMPTY_LIST_ENTRY.equals(account) || (user = this.userNames[i]) == null || "".equals(user)) continue;
            result.put(account, user);
        }
        return result;
    }

    public void addNewRow() {
        String[] newAccount = new String[this.accounts.length + 1];
        String[] newUsernames = new String[this.userNames.length + 1];
        System.arraycopy(this.accounts, 0, newAccount, 0, this.accounts.length);
        System.arraycopy(this.userNames, 0, newUsernames, 0, this.userNames.length);
        this.accounts = newAccount;
        this.userNames = newUsernames;
        for (int i = 0; i < this.accounts.length; ++i) {
            this.box.removeItem(this.accounts[i]);
        }
        this.fireTableRowsInserted(this.accounts.length - 1, this.accounts.length);
    }

    public void deleteRow(int row) {
        if (row == -1) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.accounts));
        list.remove(row);
        this.accounts = list.toArray(new String[0]);
        ArrayList<String> list2 = new ArrayList<String>(Arrays.asList(this.userNames));
        list2.remove(row);
        this.userNames = list2.toArray(new String[0]);
        this.fireTableRowsDeleted(row - 1, row);
    }
}

