/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.navigation;

import de.lehmannet.om.IEyepiece;
import de.lehmannet.om.IFilter;
import de.lehmannet.om.IImager;
import de.lehmannet.om.ILens;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.IObserver;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.IScope;
import de.lehmannet.om.ISession;
import de.lehmannet.om.ISite;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.dialog.EyepieceDialog;
import de.lehmannet.om.ui.dialog.FilterDialog;
import de.lehmannet.om.ui.dialog.IImagerDialog;
import de.lehmannet.om.ui.dialog.ITargetDialog;
import de.lehmannet.om.ui.dialog.LensDialog;
import de.lehmannet.om.ui.dialog.ObservationDialog;
import de.lehmannet.om.ui.dialog.ObserverDialog;
import de.lehmannet.om.ui.dialog.ScopeDialog;
import de.lehmannet.om.ui.dialog.SessionDialog;
import de.lehmannet.om.ui.dialog.SiteDialog;
import de.lehmannet.om.ui.extension.PopupMenuExtension;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.util.ExtenableSchemaElementSelector;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PopupMenuHandler
implements ActionListener {
    public static final byte CREATE = 1;
    public static final byte EDIT = 2;
    public static final byte DELETE = 4;
    public static final byte CREATE_HTML = 8;
    public static final byte CREATE_NEW_OBSERVATION = 16;
    public static final byte EXTENSIONS = 32;
    public static final byte CREATE_XML = 64;
    private final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ObservationManager observationManager = null;
    private ISchemaElement element = null;
    private JMenuItem create = null;
    private JMenuItem edit = null;
    private JMenuItem delete = null;
    private JMenuItem createHTML = null;
    private JMenuItem createNewObservation = null;
    private JMenuItem createXML = null;
    private int createType = -1;

    public PopupMenuHandler(ObservationManager om, ISchemaElement se, int x, int y, byte operation, int createType, PopupMenuExtension[] extensions) {
        int xSize = 150;
        int ySize = 25;
        int entries = 1;
        this.observationManager = om;
        this.element = se;
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuTitle = null;
        int seType = -1;
        if (se instanceof IObservation || createType == 2) {
            menuTitle = new JMenuItem(this.bundle.getString("observation"));
            seType = 2;
        } else if (se instanceof IObserver || createType == 6) {
            menuTitle = new JMenuItem(this.bundle.getString("observer"));
            seType = 6;
        } else if (se instanceof ISite || createType == 4) {
            menuTitle = new JMenuItem(this.bundle.getString("site"));
            seType = 4;
        } else if (se instanceof ISession || createType == 5) {
            menuTitle = new JMenuItem(this.bundle.getString("session"));
            seType = 5;
        } else if (se instanceof IScope || createType == 1) {
            menuTitle = new JMenuItem(this.bundle.getString("scope"));
            seType = 1;
        } else if (se instanceof IEyepiece || createType == 0) {
            menuTitle = new JMenuItem(this.bundle.getString("eyepiece"));
            seType = 0;
        } else if (se instanceof IFilter || createType == 8) {
            menuTitle = new JMenuItem(this.bundle.getString("filter"));
            seType = 8;
        } else if (se instanceof ILens || createType == 9) {
            menuTitle = createType == 9 ? new JMenuItem(this.bundle.getString("lens")) : (((ILens)se).getFactor() > 1.0f ? new JMenuItem(this.bundle.getString("lens.barlow")) : (((ILens)se).getFactor() < 1.0f ? new JMenuItem(this.bundle.getString("lens.sharpley")) : new JMenuItem(this.bundle.getString("lens"))));
            seType = 9;
        } else if (se instanceof IImager || createType == 3) {
            menuTitle = new JMenuItem(this.bundle.getString("imager"));
            seType = 3;
        } else if (se instanceof ITarget || createType == 7) {
            menuTitle = new JMenuItem(this.bundle.getString("target"));
            seType = 7;
        }
        if (menuTitle == null) {
            return;
        }
        menuTitle.setEnabled(false);
        popupMenu.add(menuTitle);
        popupMenu.addSeparator();
        if ((operation & 1) == 1 && createType >= 0 && createType < 10) {
            this.createType = createType;
            this.create = new JMenuItem(this.bundle.getString("create"));
            this.create.addActionListener(this);
            popupMenu.add(this.create);
            ++entries;
        }
        if ((operation & 2) == 2) {
            this.edit = new JMenuItem(this.bundle.getString("edit"));
            this.edit.addActionListener(this);
            popupMenu.add(this.edit);
            ++entries;
        }
        if ((operation & 4) == 4) {
            this.delete = new JMenuItem(this.bundle.getString("delete"));
            this.delete.addActionListener(this);
            popupMenu.add(this.delete);
            ++entries;
        }
        if ((operation & 8) == 8 && (operation & 0x40) == 64) {
            JMenu export = new JMenu(this.bundle.getString("menu.export"));
            this.createHTML = new JMenuItem(this.bundle.getString("menu.htmlExport"));
            this.createHTML.addActionListener(this);
            export.add(this.createHTML);
            this.createXML = new JMenuItem(this.bundle.getString("menu.oalExport"));
            this.createXML.addActionListener(this);
            export.add(this.createXML);
            ++entries;
            popupMenu.add(export);
        } else {
            if ((operation & 8) == 8) {
                this.createHTML = new JMenuItem(this.bundle.getString("menu.htmlExport"));
                this.createHTML.addActionListener(this);
                popupMenu.add(this.createHTML);
                ++entries;
            }
            if ((operation & 0x40) == 64) {
                this.createXML = new JMenuItem(this.bundle.getString("menu.oalExport"));
                this.createXML.addActionListener(this);
                popupMenu.add(this.createXML);
                ++entries;
            }
        }
        if ((operation & 0x10) == 16) {
            this.createNewObservation = new JMenuItem(this.bundle.getString("menu.newObservation"));
            this.createNewObservation.addActionListener(this);
            popupMenu.add(this.createNewObservation);
            ++entries;
        }
        if ((operation & 0x20) == 32 && extensions != null && extensions.length > 0) {
            int[] schemaElementTypes = null;
            int contained = -1;
            boolean found = false;
            for (int i = 0; i < extensions.length; ++i) {
                schemaElementTypes = extensions[i].getSchemaElementTypes();
                contained = Arrays.binarySearch(schemaElementTypes, seType);
                if (contained < 0) continue;
                if (!found) {
                    popupMenu.addSeparator();
                }
                found = true;
                popupMenu.add(extensions[i].getMenu());
                ++entries;
            }
        }
        popupMenu.setPopupSize(150, entries * 25);
        popupMenu.show(this.observationManager, x, y);
    }

    public void actionPerformed(ActionEvent e) {
        block24: {
            JMenuItem source;
            block25: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    block29: {
                                        block28: {
                                            block27: {
                                                block26: {
                                                    if (!(e.getSource() instanceof JMenuItem)) break block24;
                                                    source = (JMenuItem)e.getSource();
                                                    if (!source.equals(this.edit)) break block25;
                                                    if (!(this.element instanceof IObservation)) break block26;
                                                    ObservationDialog dialog = new ObservationDialog(this.observationManager, (IObservation)this.element);
                                                    while (dialog == null || dialog != null && dialog.isCreateAdditionalObservation()) {
                                                        dialog = new ObservationDialog(this.observationManager, null);
                                                        this.observationManager.update((ISchemaElement)dialog.getObservation());
                                                    }
                                                    break block24;
                                                }
                                                if (!(this.element instanceof ITarget)) break block27;
                                                ITarget target = (ITarget)this.element;
                                                ITargetDialog dialog = this.observationManager.getExtensionLoader().getSchemaUILoader().getTargetDialog(target.getXSIType(), target, null);
                                                break block24;
                                            }
                                            if (!(this.element instanceof IScope)) break block28;
                                            ScopeDialog dialog = new ScopeDialog(this.observationManager, (IScope)this.element);
                                            break block24;
                                        }
                                        if (!(this.element instanceof IEyepiece)) break block29;
                                        EyepieceDialog dialog = new EyepieceDialog(this.observationManager, (IEyepiece)this.element);
                                        break block24;
                                    }
                                    if (!(this.element instanceof IImager)) break block30;
                                    IImager imager = (IImager)this.element;
                                    IImagerDialog dialog = (IImagerDialog)((Object)this.observationManager.getExtensionLoader().getSchemaUILoader().getSchemaElementDialog(imager.getXSIType(), 3, (ISchemaElement)imager, true));
                                    break block24;
                                }
                                if (!(this.element instanceof ISite)) break block31;
                                SiteDialog dialog = new SiteDialog(this.observationManager, (ISite)this.element);
                                break block24;
                            }
                            if (!(this.element instanceof IFilter)) break block32;
                            FilterDialog dialog = new FilterDialog(this.observationManager, (IFilter)this.element);
                            break block24;
                        }
                        if (!(this.element instanceof ISession)) break block33;
                        SessionDialog dialog = new SessionDialog(this.observationManager, (ISession)this.element);
                        break block24;
                    }
                    if (!(this.element instanceof IObserver)) break block34;
                    ObserverDialog dialog = new ObserverDialog(this.observationManager, (IObserver)this.element);
                    break block24;
                }
                if (!(this.element instanceof ILens)) break block24;
                LensDialog dialog = new LensDialog(this.observationManager, (ILens)this.element);
                break block24;
            }
            if (source.equals(this.create)) {
                switch (this.createType) {
                    case 0: {
                        EyepieceDialog dialog = new EyepieceDialog(this.observationManager, null);
                        this.observationManager.update((ISchemaElement)dialog.getEyepiece());
                        break;
                    }
                    case 1: {
                        ScopeDialog dialog = new ScopeDialog(this.observationManager, null);
                        this.observationManager.update((ISchemaElement)dialog.getScope());
                        break;
                    }
                    case 2: {
                        ObservationDialog dialog = null;
                        while (dialog == null || dialog != null && dialog.isCreateAdditionalObservation()) {
                            dialog = new ObservationDialog(this.observationManager, null);
                            this.observationManager.update((ISchemaElement)dialog.getObservation());
                        }
                        break;
                    }
                    case 3: {
                        ExtenableSchemaElementSelector is = new ExtenableSchemaElementSelector(this.observationManager, this.observationManager.getExtensionLoader().getSchemaUILoader(), 3);
                        if (!is.getResult()) break;
                        IImagerDialog imagerDialog = (IImagerDialog)((Object)is.getDialog());
                        this.observationManager.update((ISchemaElement)imagerDialog.getImager());
                        break;
                    }
                    case 4: {
                        SiteDialog dialog = new SiteDialog(this.observationManager, null);
                        this.observationManager.update((ISchemaElement)dialog.getSite());
                        break;
                    }
                    case 5: {
                        SessionDialog dialog = new SessionDialog(this.observationManager, null);
                        this.observationManager.update((ISchemaElement)dialog.getSession());
                        break;
                    }
                    case 6: {
                        ObserverDialog dialog = new ObserverDialog(this.observationManager, null);
                        this.observationManager.update((ISchemaElement)dialog.getObserver());
                        break;
                    }
                    case 8: {
                        FilterDialog dialog = new FilterDialog(this.observationManager, null);
                        this.observationManager.update((ISchemaElement)dialog.getFilter());
                        break;
                    }
                    case 7: {
                        ExtenableSchemaElementSelector ts = new ExtenableSchemaElementSelector(this.observationManager, this.observationManager.getExtensionLoader().getSchemaUILoader(), 7);
                        if (!ts.getResult()) break;
                        ITargetDialog targetDialog = (ITargetDialog)ts.getDialog();
                        this.observationManager.update((ISchemaElement)targetDialog.getTarget());
                        break;
                    }
                    case 9: {
                        LensDialog dialog = new LensDialog(this.observationManager, null);
                        this.observationManager.update((ISchemaElement)dialog.getLens());
                        break;
                    }
                }
            } else if (source.equals(this.delete)) {
                this.observationManager.deleteSchemaElement(this.element);
            } else if (source.equals(this.createHTML)) {
                this.observationManager.createHTMLForSchemaElement(this.element);
            } else if (source.equals(this.createXML)) {
                this.observationManager.createXMLForSchemaElement(this.element);
            } else if (source.equals(this.createNewObservation)) {
                ObservationDialog dialog = null;
                while (dialog == null || dialog != null && dialog.isCreateAdditionalObservation()) {
                    dialog = new ObservationDialog(this.observationManager, null, this.element);
                    this.observationManager.update((ISchemaElement)dialog.getObservation());
                }
            }
        }
    }
}

