/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.comparator.TargetComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

class TargetSelectionModel
extends AbstractTableModel {
    private TreeMap targetMap = new TreeMap(new TargetComparator());

    public TargetSelectionModel(ITarget[] targets, String targetFilter, List preSelectedTargets) {
        for (int i = 0; i < targets.length; ++i) {
            if (!targets[i].getXSIType().equals(targetFilter)) continue;
            if (preSelectedTargets.contains(targets[i])) {
                this.targetMap.put(targets[i], new Boolean(true));
                continue;
            }
            this.targetMap.put(targets[i], new Boolean(false));
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        if (this.targetMap == null) {
            return 5;
        }
        return this.targetMap.size();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ITarget keyTarget = this.targetMap.keySet().toArray(new ITarget[0])[rowIndex];
        if (keyTarget == null) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                return keyTarget.getDisplayName();
            }
            case 1: {
                return this.targetMap.get(keyTarget);
            }
        }
        return "";
    }

    public void setValueAt(Object o, int row, int column) {
        if (column == 1 && o instanceof Boolean) {
            this.setSelection(row, (Boolean)o);
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public void setSelection(int row, boolean selection) {
        ITarget keyTarget = this.targetMap.keySet().toArray(new ITarget[0])[row];
        this.targetMap.remove(keyTarget);
        this.targetMap.put(keyTarget, new Boolean(selection));
    }

    public List getAllSelectedTargets() {
        ArrayList<ITarget> result = new ArrayList<ITarget>();
        Iterator keyIterator = this.targetMap.keySet().iterator();
        ITarget current = null;
        Boolean currentValue = null;
        while (keyIterator.hasNext()) {
            current = (ITarget)keyIterator.next();
            currentValue = (Boolean)this.targetMap.get(current);
            if (!currentValue.booleanValue()) continue;
            result.add(current);
        }
        return result;
    }
}

