/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ui.dialog.NewDocumentDialog;
import de.lehmannet.om.ui.dialog.SchemaElementLeaf;
import java.awt.EventQueue;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTree;

class CheckBoxNode
extends Vector {
    private String text = null;
    private boolean selected = false;
    private Icon expandedIcon = null;
    private Icon collapsedIcon = null;
    private NewDocumentDialog dialog = null;
    private int selectedChildren = 0;

    public CheckBoxNode(NewDocumentDialog dialog, String text, boolean selected, ISchemaElement[] elements, Icon expanded, Icon collapsed) {
        this.dialog = dialog;
        this.text = text;
        this.selected = selected;
        this.expandedIcon = expanded;
        this.collapsedIcon = collapsed;
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                super.add(new SchemaElementLeaf(this.dialog, this, elements[i], selected));
            }
            if (selected) {
                this.selectedChildren = elements.length;
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean newValue) {
        this.selected = newValue;
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            ((SchemaElementLeaf)iterator.next()).setSelected(newValue);
        }
        this.selectedChildren = newValue ? super.size() : 0;
        final JTree tree = this.dialog.getTree();
        if (tree != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    tree.updateUI();
                }
            });
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newValue) {
        this.text = newValue;
    }

    public String toString() {
        return this.text;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    public void childChangedToSelected() {
        ++this.selectedChildren;
        this.selected = this.selectedChildren != 0;
    }

    public void childChangedToUnselected() {
        --this.selectedChildren;
        this.selected = this.selectedChildren != 0;
    }
}

