/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.catalog;

import de.lehmannet.om.ui.dialog.OMDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JProgressBar;

class WaitPopup
extends OMDialog {
    private static final long serialVersionUID = 4130578764471183037L;
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private ThreadGroup threadGroup = null;
    private JProgressBar progressBar = null;

    public WaitPopup(ThreadGroup threadGroup, ObservationManager om) {
        super(om);
        super.setLocationRelativeTo(om);
        super.setTitle(this.bundle.getString("catalogLoader.info.waitOnLoaders"));
        this.threadGroup = threadGroup;
        super.getContentPane().setLayout(new BorderLayout());
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setIndeterminate(true);
        super.getContentPane().add((Component)this.progressBar, "Center");
        this.setSize(4130578764471183037L, 250, 60);
        Runnable wait = new Runnable(){

            public void run() {
                WaitPopup.this.waitForCatalogLoaders();
            }
        };
        Thread waitThread = new Thread(wait, "ProjectLoader: WaitPopup");
        waitThread.start();
        this.setVisible(true);
    }

    private void waitForCatalogLoaders() {
        while (this.threadGroup.activeCount() > 0) {
            try {
                this.threadGroup.wait(300L);
            }
            catch (InterruptedException ie) {
                System.err.println("Interrupted while waiting for ThreadGroup.\n" + ie);
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {}
        }
        this.dispose();
    }
}

