/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.catalog;

import de.lehmannet.om.ui.catalog.ICatalog;
import de.lehmannet.om.ui.extension.IExtension;
import java.io.File;
import java.util.Map;

class CatalogLoaderRunnable
implements Runnable {
    private IExtension extension = null;
    private Map resultMap = null;
    private File catalogDir = null;
    private boolean debug = false;

    public CatalogLoaderRunnable(IExtension extension, Map resultMap, File catalogDir, boolean debug) {
        this.extension = extension;
        this.resultMap = resultMap;
        this.catalogDir = catalogDir;
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ICatalog[] currentCatalogs;
        if (this.debug) {
            System.out.println("Catalog loading start: " + this.extension.getName() + " " + System.currentTimeMillis());
        }
        if ((currentCatalogs = this.extension.getCatalogs(this.catalogDir)) != null) {
            Map map = this.resultMap;
            synchronized (map) {
                for (int i = 0; i < currentCatalogs.length; ++i) {
                    this.resultMap.put(currentCatalogs[i].getName(), currentCatalogs[i]);
                }
            }
        }
        if (this.debug) {
            System.out.println("Catalog loading done: " + this.extension.getName() + " " + System.currentTimeMillis());
        }
    }
}

