/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.catalog;

import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.catalog.CatalogLoaderRunnable;
import de.lehmannet.om.ui.catalog.ICatalog;
import de.lehmannet.om.ui.catalog.IListableCatalog;
import de.lehmannet.om.ui.catalog.WaitPopup;
import de.lehmannet.om.ui.extension.IExtension;
import de.lehmannet.om.ui.navigation.ObservationManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class CatalogLoader {
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private static final String CATALOG_DIR = "catalog";
    private ObservationManager observationManager = null;
    private List extensions = null;
    private HashMap catalogMap = new HashMap();
    private HashMap knownExtensions = new HashMap();
    ThreadGroup loadCatalogs = new ThreadGroup("Load all catalogs");

    public CatalogLoader(ObservationManager om, List extensions) {
        this.observationManager = om;
        this.extensions = extensions;
        this.loadCatalogues();
    }

    public String[] getCatalogNames() {
        this.waitForCatalogLoaders();
        return this.catalogMap.keySet().toArray(new String[0]);
    }

    public String[] getListableCatalogNames() {
        this.waitForCatalogLoaders();
        Iterator iterator = this.catalogMap.keySet().iterator();
        ICatalog cat = null;
        String currentKey = null;
        ArrayList<String> result = new ArrayList<String>();
        while (iterator.hasNext()) {
            currentKey = (String)iterator.next();
            cat = (ICatalog)this.catalogMap.get(currentKey);
            if (!(cat instanceof IListableCatalog)) continue;
            result.add(currentKey);
        }
        return result.toArray(new String[0]);
    }

    public ITarget getTarget(String catalogName, String objectID) {
        this.waitForCatalogLoaders();
        ICatalog catalog = this.getCatalog(catalogName);
        if (catalog != null) {
            return catalog.getTarget(objectID);
        }
        return null;
    }

    public ICatalog getCatalog(String catalogName) {
        this.waitForCatalogLoaders();
        if (!this.catalogMap.containsKey(catalogName)) {
            if (catalogName != null) {
                Iterator catIterator = this.catalogMap.values().iterator();
                ICatalog current = null;
                while (catIterator.hasNext()) {
                    current = (ICatalog)catIterator.next();
                    if (!catalogName.equals(current.getAbbreviation())) continue;
                    return current;
                }
            } else {
                return null;
            }
        }
        return (ICatalog)this.catalogMap.get(catalogName);
    }

    public void update() {
        this.waitForCatalogLoaders();
        this.loadCatalogues();
    }

    public boolean isLoading() {
        return this.loadCatalogs.activeCount() > 0;
    }

    private void waitForCatalogLoaders() {
        if (this.isLoading()) {
            new WaitPopup(this.loadCatalogs, this.observationManager);
        }
    }

    private void loadCatalogues() {
        boolean makeCatDir;
        File catalogDir = new File(this.observationManager.getInstallDir().getAbsolutePath() + File.separator + CATALOG_DIR);
        if (!catalogDir.exists() && !(makeCatDir = catalogDir.mkdir())) {
            System.err.println("Catalog directory not found: " + catalogDir);
            this.observationManager.createWarning(this.bundle.getString("catalogLoader.warning.noCatalogDir"));
            return;
        }
        Iterator iterator = this.extensions.iterator();
        IExtension current = null;
        ArrayList<Thread> catalogs = new ArrayList<Thread>();
        while (iterator.hasNext()) {
            float version;
            float knownVersion;
            current = (IExtension)iterator.next();
            if (this.knownExtensions.containsKey(current.getName()) && (knownVersion = ((Float)this.knownExtensions.get(current.getName())).floatValue()) >= (version = current.getVersion())) continue;
            CatalogLoaderRunnable runnable = new CatalogLoaderRunnable(current, this.catalogMap, catalogDir, this.observationManager.isDebug());
            Thread thread = new Thread(this.loadCatalogs, runnable, "Load catalog " + current.getName());
            catalogs.add(thread);
            this.knownExtensions.put(current.getName(), new Float(current.getVersion()));
        }
        Iterator iter = catalogs.iterator();
        while (iter.hasNext()) {
            ((Thread)iter.next()).start();
        }
    }
}

