/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.Const;
import boplanets.gui.FrmDocu;
import boplanets.gui.FrmLocation;
import boplanets.gui.PlanetsPanel;
import boplanets.gui.PnlAbout;
import boplanets.gui.PnlOrbitalParameters;
import boplanets.gui.PnlRiseTransSet;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class PlanetsView
extends JFrame {
    private ButtonGroup btnGrpDirections;
    private ButtonGroup btnGrpPlaneOptions;
    private ButtonGroup btnGrpRunOptions;
    private ButtonGroup btnGrpViews;
    private JCheckBoxMenuItem chkMnuBackward;
    private JCheckBoxMenuItem chkMnuContinous;
    private JCheckBoxMenuItem chkMnuForward;
    private JCheckBoxMenuItem chkMnuPLaneX_Z;
    private JCheckBoxMenuItem chkMnuPlaneX_Y;
    private JCheckBoxMenuItem chkMnuPlaneY_Z;
    private JCheckBoxMenuItem chkMnuSingleStep;
    private JCheckBoxMenuItem chkMnuVector;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JLabel lblPlanet0;
    private JLabel lblPlanet1;
    private JLabel lblPlanet2;
    private JLabel lblPlanet3;
    private JLabel lblPlanet4;
    private JLabel lblPlanet5;
    private JLabel lblPlanet6;
    private JLabel lblPlanet7;
    private JLabel lblPlanet8;
    private JLabel lblPlanet9;
    private JMenuBar menuBar;
    private JMenuItem mitAbout;
    private JMenuItem mitClose;
    private JMenuItem mitHelpPlanets;
    private JMenuItem mitLocation;
    private JCheckBoxMenuItem mitchkEcliptic;
    private JCheckBoxMenuItem mitchkEquatorial;
    private JCheckBoxMenuItem mitchkHorizontal;
    private JCheckBoxMenuItem mitchkLogEcliptic;
    private JMenu mnuFile;
    private JMenu mnuHelp;
    private JMenu mnuOptions;
    private JMenu mnuParameters;
    private JMenu mnuRiseTransSet;
    private JMenu mnuViews;
    private static final int FRM_VERTICAL_GAP = 1;
    private static final int FRM_HORIZONTAL_GAP = 5;
    private static final int WIDTH_PLANET_LABEL = 51;
    private static final int HEIGHT_PLANET_LABEL = 40;
    private static final String ECLIPTIC = "Ecliptic View";
    private static final String LOG_ECLIPTIC = "Logarithmic Ecliptic View";
    private static final String EQUATORIAL = "Equatorial View";
    private static final String HORIZONTAL = "Horizontal View";
    private int _iAbsciss;
    private int _iOrdinate;
    private URL _iconImgUrl = this.getClass().getResource("images/Venus.jpg");
    private PlanetsPanel _planetsPanel;
    private JLabel _lastPlanetLabel;
    private int _heightInsetsMenubar;
    private int _heightInsetsBottom;
    private int _noSelectedPlanets;
    private FrmLocation _frmLocation = null;
    private FrmDocu _frmDocu = null;
    private int _viewType;

    public PlanetsView(int n, int[] nArray) {
        this.initComponents();
        this.setSize(820, 650);
        this.setLocationRelativeTo(null);
        this.createPlanetImages(n, nArray);
        this._noSelectedPlanets = nArray.length;
        this._lastPlanetLabel = (JLabel)this.getContentPane().getComponent(this._noSelectedPlanets);
        this._heightInsetsMenubar = this.getInsets().top + this.menuBar.getHeight() + 1;
        this._heightInsetsBottom = this.getInsets().bottom;
        this.mitchkLogEcliptic.setSelected(true);
        this._viewType = 1;
        this.chkMnuPlaneX_Y.setSelected(true);
        this.chkMnuForward.setSelected(true);
        this._iAbsciss = 0;
        this._iOrdinate = 1;
        this._planetsPanel = new PlanetsPanel(800, 420, n, nArray);
        this.getContentPane().add(this._planetsPanel);
        this.setTitle("BoPlanets: Logarithmic Ecliptic View");
        this._planetsPanel.setRadiusVector(this.chkMnuVector.isSelected());
        this._planetsPanel.setTimeForward(this.chkMnuForward.isSelected());
    }

    private void initComponents() {
        this.btnGrpViews = new ButtonGroup();
        this.btnGrpPlaneOptions = new ButtonGroup();
        this.btnGrpDirections = new ButtonGroup();
        this.btnGrpRunOptions = new ButtonGroup();
        this.lblPlanet0 = new JLabel();
        this.lblPlanet1 = new JLabel();
        this.lblPlanet2 = new JLabel();
        this.lblPlanet3 = new JLabel();
        this.lblPlanet4 = new JLabel();
        this.lblPlanet5 = new JLabel();
        this.lblPlanet6 = new JLabel();
        this.lblPlanet7 = new JLabel();
        this.lblPlanet8 = new JLabel();
        this.lblPlanet9 = new JLabel();
        this.menuBar = new JMenuBar();
        this.mnuFile = new JMenu();
        this.mitClose = new JMenuItem();
        this.mnuViews = new JMenu();
        this.mitchkEcliptic = new JCheckBoxMenuItem();
        this.mitchkLogEcliptic = new JCheckBoxMenuItem();
        this.mitchkEquatorial = new JCheckBoxMenuItem();
        this.mitchkHorizontal = new JCheckBoxMenuItem();
        this.mitLocation = new JMenuItem();
        this.mnuOptions = new JMenu();
        this.chkMnuPlaneX_Y = new JCheckBoxMenuItem();
        this.chkMnuPLaneX_Z = new JCheckBoxMenuItem();
        this.chkMnuPlaneY_Z = new JCheckBoxMenuItem();
        this.jSeparator1 = new JSeparator();
        this.chkMnuVector = new JCheckBoxMenuItem();
        this.jSeparator2 = new JSeparator();
        this.chkMnuForward = new JCheckBoxMenuItem();
        this.chkMnuBackward = new JCheckBoxMenuItem();
        this.jSeparator3 = new JSeparator();
        this.chkMnuSingleStep = new JCheckBoxMenuItem();
        this.chkMnuContinous = new JCheckBoxMenuItem();
        this.mnuParameters = new JMenu();
        this.mnuRiseTransSet = new JMenu();
        this.mnuHelp = new JMenu();
        this.mitHelpPlanets = new JMenuItem();
        this.mitAbout = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setIconImage(new ImageIcon(this._iconImgUrl).getImage());
        this.setMinimumSize(new Dimension(300, 400));
        this.setName("PlanetsViewFrame");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PlanetsView.this.PlanetsView_WindowClosed(windowEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PlanetsView.this.PlanetsViewResized(componentEvent);
            }
        });
        this.getContentPane().setLayout(new FlowLayout(1, 5, 1));
        this.lblPlanet0.setFont(new Font("Arial", 0, 11));
        this.lblPlanet0.setFocusable(false);
        this.getContentPane().add(this.lblPlanet0);
        this.lblPlanet1.setFont(new Font("Arial", 0, 11));
        this.lblPlanet1.setFocusable(false);
        this.getContentPane().add(this.lblPlanet1);
        this.lblPlanet2.setFont(new Font("Arial", 0, 11));
        this.lblPlanet2.setFocusable(false);
        this.getContentPane().add(this.lblPlanet2);
        this.lblPlanet3.setFont(new Font("Arial", 0, 11));
        this.lblPlanet3.setFocusable(false);
        this.getContentPane().add(this.lblPlanet3);
        this.lblPlanet4.setFont(new Font("Arial", 0, 11));
        this.lblPlanet4.setFocusable(false);
        this.getContentPane().add(this.lblPlanet4);
        this.lblPlanet5.setFont(new Font("Arial", 0, 11));
        this.lblPlanet5.setFocusable(false);
        this.getContentPane().add(this.lblPlanet5);
        this.lblPlanet6.setFont(new Font("Arial", 0, 11));
        this.lblPlanet6.setFocusable(false);
        this.getContentPane().add(this.lblPlanet6);
        this.lblPlanet7.setFont(new Font("Arial", 0, 11));
        this.lblPlanet7.setFocusable(false);
        this.getContentPane().add(this.lblPlanet7);
        this.lblPlanet8.setFont(new Font("Arial", 0, 11));
        this.lblPlanet8.setFocusable(false);
        this.getContentPane().add(this.lblPlanet8);
        this.lblPlanet9.setFont(new Font("Arial", 0, 11));
        this.lblPlanet9.setFocusable(false);
        this.getContentPane().add(this.lblPlanet9);
        this.menuBar.setFont(new Font("Arial", 0, 11));
        this.mnuFile.setBorder(null);
        this.mnuFile.setMnemonic('F');
        this.mnuFile.setText("File");
        this.mnuFile.setFont(new Font("Arial", 0, 11));
        this.mitClose.setFont(new Font("Arial", 0, 11));
        this.mitClose.setText("Close");
        this.mitClose.setBorder(null);
        this.mitClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.mitCloseActionPeformed(actionEvent);
            }
        });
        this.mnuFile.add(this.mitClose);
        this.menuBar.add(this.mnuFile);
        this.mnuViews.setBorder(null);
        this.mnuViews.setMnemonic('V');
        this.mnuViews.setText("Views");
        this.mnuViews.setFont(new Font("Arial", 0, 11));
        this.btnGrpViews.add(this.mitchkEcliptic);
        this.mitchkEcliptic.setFont(new Font("Arial", 0, 11));
        this.mitchkEcliptic.setMnemonic('E');
        this.mitchkEcliptic.setText(ECLIPTIC);
        this.mitchkEcliptic.setToolTipText("shows the planets in the ecliptic plane");
        this.mitchkEcliptic.setBorder(null);
        this.mitchkEcliptic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.mitchkEcliptic_ActionPerformed(actionEvent);
            }
        });
        this.mnuViews.add(this.mitchkEcliptic);
        this.btnGrpViews.add(this.mitchkLogEcliptic);
        this.mitchkLogEcliptic.setFont(new Font("Arial", 0, 11));
        this.mitchkLogEcliptic.setMnemonic('L');
        this.mitchkLogEcliptic.setSelected(true);
        this.mitchkLogEcliptic.setText(LOG_ECLIPTIC);
        this.mitchkLogEcliptic.setToolTipText("shows the planets in the ecliptic plane with logarithmic scaling");
        this.mitchkLogEcliptic.setBorder(null);
        this.mitchkLogEcliptic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.mitchkLogEcliptic_ActionPerformed(actionEvent);
            }
        });
        this.mnuViews.add(this.mitchkLogEcliptic);
        this.btnGrpViews.add(this.mitchkEquatorial);
        this.mitchkEquatorial.setFont(new Font("Arial", 0, 11));
        this.mitchkEquatorial.setMnemonic('Q');
        this.mitchkEquatorial.setText(EQUATORIAL);
        this.mitchkEquatorial.setToolTipText("shows the planets in the equatorial plane");
        this.mitchkEquatorial.setBorder(null);
        this.mitchkEquatorial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.mitchkEquatorial_ActionPerformed(actionEvent);
            }
        });
        this.mnuViews.add(this.mitchkEquatorial);
        this.btnGrpViews.add(this.mitchkHorizontal);
        this.mitchkHorizontal.setFont(new Font("Arial", 0, 11));
        this.mitchkHorizontal.setText(HORIZONTAL);
        this.mitchkHorizontal.setToolTipText("shows the planets in the horizontal plane of a given location on the observing planet.");
        this.mitchkHorizontal.setBorder(null);
        this.mitchkHorizontal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.mitchkHorizontal_ActionPerformed(actionEvent);
            }
        });
        this.mnuViews.add(this.mitchkHorizontal);
        this.mitLocation.setFont(new Font("Arial", 0, 11));
        this.mitLocation.setMnemonic('L');
        this.mitLocation.setText("Location");
        this.mitLocation.setToolTipText("Select a location on the observer for the horizontal view");
        this.mitLocation.setBorder(null);
        this.mitLocation.setEnabled(false);
        this.mitLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.mitLocation_ActionPerformed(actionEvent);
            }
        });
        this.mnuViews.add(this.mitLocation);
        this.menuBar.add(this.mnuViews);
        this.mnuOptions.setBorder(null);
        this.mnuOptions.setMnemonic('P');
        this.mnuOptions.setText("Options");
        this.mnuOptions.setFont(new Font("Arial", 0, 11));
        this.btnGrpPlaneOptions.add(this.chkMnuPlaneX_Y);
        this.chkMnuPlaneX_Y.setFont(new Font("Arial", 0, 11));
        this.chkMnuPlaneX_Y.setSelected(true);
        this.chkMnuPlaneX_Y.setText("X-Y plane");
        this.chkMnuPlaneX_Y.setToolTipText("show X-Y plane in ecliptic view");
        this.chkMnuPlaneX_Y.setBorder(null);
        this.chkMnuPlaneX_Y.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.chkMnuPlaneX_Y_ActionPerformed(actionEvent);
            }
        });
        this.mnuOptions.add(this.chkMnuPlaneX_Y);
        this.btnGrpPlaneOptions.add(this.chkMnuPLaneX_Z);
        this.chkMnuPLaneX_Z.setFont(new Font("Arial", 0, 11));
        this.chkMnuPLaneX_Z.setText("X-Z plane");
        this.chkMnuPLaneX_Z.setToolTipText("show X-Z plane in ecliptic view");
        this.chkMnuPLaneX_Z.setBorder(null);
        this.chkMnuPLaneX_Z.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.chkMnuPlaneX_Z_ActionPerformed(actionEvent);
            }
        });
        this.mnuOptions.add(this.chkMnuPLaneX_Z);
        this.btnGrpPlaneOptions.add(this.chkMnuPlaneY_Z);
        this.chkMnuPlaneY_Z.setFont(new Font("Arial", 0, 11));
        this.chkMnuPlaneY_Z.setText("Y-Z plane");
        this.chkMnuPlaneY_Z.setToolTipText("show Y-Z plane in ecliptic view");
        this.chkMnuPlaneY_Z.setBorder(null);
        this.chkMnuPlaneY_Z.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.chkMnuPlaneY_Z_ActionPerformed(actionEvent);
            }
        });
        this.mnuOptions.add(this.chkMnuPlaneY_Z);
        this.mnuOptions.add(this.jSeparator1);
        this.chkMnuVector.setFont(new Font("Arial", 0, 11));
        this.chkMnuVector.setSelected(true);
        this.chkMnuVector.setText("show radius vector");
        this.chkMnuVector.setToolTipText("show the vector from origin to the planet");
        this.chkMnuVector.setBorder(null);
        this.chkMnuVector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.chkMnuVector_ActionPerformed(actionEvent);
            }
        });
        this.mnuOptions.add(this.chkMnuVector);
        this.mnuOptions.add(this.jSeparator2);
        this.btnGrpDirections.add(this.chkMnuForward);
        this.chkMnuForward.setFont(new Font("Arial", 0, 11));
        this.chkMnuForward.setSelected(true);
        this.chkMnuForward.setText("run forwards");
        this.chkMnuForward.setToolTipText("run forward in time");
        this.chkMnuForward.setBorder(null);
        this.chkMnuForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.chkMnuForward_ActionPerformed(actionEvent);
            }
        });
        this.mnuOptions.add(this.chkMnuForward);
        this.btnGrpDirections.add(this.chkMnuBackward);
        this.chkMnuBackward.setFont(new Font("Arial", 0, 11));
        this.chkMnuBackward.setText("run backwards");
        this.chkMnuBackward.setToolTipText("run backward in time");
        this.chkMnuBackward.setBorder(null);
        this.chkMnuBackward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.chkMnuBackward_ActionPerformed(actionEvent);
            }
        });
        this.mnuOptions.add(this.chkMnuBackward);
        this.mnuOptions.add(this.jSeparator3);
        this.btnGrpRunOptions.add(this.chkMnuSingleStep);
        this.chkMnuSingleStep.setFont(new Font("Arial", 0, 11));
        this.chkMnuSingleStep.setSelected(true);
        this.chkMnuSingleStep.setText("run stepwise");
        this.chkMnuSingleStep.setToolTipText("run the planets stepwise by pressing the left mouse");
        this.chkMnuSingleStep.setBorder(null);
        this.chkMnuSingleStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.chkMnuSingleStep_ActionPerformed(actionEvent);
            }
        });
        this.mnuOptions.add(this.chkMnuSingleStep);
        this.btnGrpRunOptions.add(this.chkMnuContinous);
        this.chkMnuContinous.setFont(new Font("Arial", 0, 11));
        this.chkMnuContinous.setText("run continuously");
        this.chkMnuContinous.setToolTipText("run the planets continuously by clicking the left mouse");
        this.chkMnuContinous.setBorder(null);
        this.chkMnuContinous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.chkMnuContinous_ActionPerformed(actionEvent);
            }
        });
        this.mnuOptions.add(this.chkMnuContinous);
        this.menuBar.add(this.mnuOptions);
        this.mnuParameters.setBorder(null);
        this.mnuParameters.setMnemonic('O');
        this.mnuParameters.setText("OrbitalParmeters");
        this.mnuParameters.setToolTipText("Shows the orbital parameters of planets.");
        this.mnuParameters.setFont(new Font("Arial", 0, 11));
        this.mnuParameters.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PlanetsView.this.mnuParameters_MouseClicked(mouseEvent);
            }
        });
        this.menuBar.add(this.mnuParameters);
        this.mnuRiseTransSet.setBorder(null);
        this.mnuRiseTransSet.setMnemonic('R');
        this.mnuRiseTransSet.setText("Rise&Transit&Set");
        this.mnuRiseTransSet.setToolTipText("Determines rise, transit and set time.");
        this.mnuRiseTransSet.setFont(new Font("Arial", 0, 11));
        this.mnuRiseTransSet.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PlanetsView.this.mnuRiseTransSet_MouseClicked(mouseEvent);
            }
        });
        this.menuBar.add(this.mnuRiseTransSet);
        this.mnuHelp.setBorder(null);
        this.mnuHelp.setMnemonic('H');
        this.mnuHelp.setText("Help");
        this.mnuHelp.setFont(new Font("Arial", 0, 11));
        this.mitHelpPlanets.setFont(new Font("Arial", 0, 11));
        this.mitHelpPlanets.setMnemonic('H');
        this.mitHelpPlanets.setText("Help about BoPlanets");
        this.mitHelpPlanets.setToolTipText("");
        this.mitHelpPlanets.setBorder(null);
        this.mitHelpPlanets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.mitHelpPlanets_ActionPerformed(actionEvent);
            }
        });
        this.mnuHelp.add(this.mitHelpPlanets);
        this.mitAbout.setFont(new Font("Arial", 0, 11));
        this.mitAbout.setMnemonic('A');
        this.mitAbout.setText("About BoPlanets");
        this.mitAbout.setToolTipText("");
        this.mitAbout.setBorder(null);
        this.mitAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsView.this.mitAbout_ActionPerformed(actionEvent);
            }
        });
        this.mnuHelp.add(this.mitAbout);
        this.menuBar.add(this.mnuHelp);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void mnuRiseTransSet_MouseClicked(MouseEvent mouseEvent) {
        if (this.mnuRiseTransSet.isEnabled()) {
            this.mnuRiseTransSet.setEnabled(false);
            new PnlRiseTransSet(this, this._planetsPanel);
        }
    }

    private void mnuParameters_MouseClicked(MouseEvent mouseEvent) {
        if (this.mnuParameters.isEnabled()) {
            new PnlOrbitalParameters(this, this._planetsPanel);
            this.mnuParameters.setEnabled(false);
        }
    }

    private void mitHelpPlanets_ActionPerformed(ActionEvent actionEvent) {
        if (FrmDocu.frmDocuInstances == 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlanetsView.this._frmDocu = new FrmDocu();
                }
            });
        }
    }

    private void mitAbout_ActionPerformed(ActionEvent actionEvent) {
        new PnlAbout(this);
    }

    private void PlanetsView_WindowClosed(WindowEvent windowEvent) {
        if (FrmDocu.frmDocuInstances > 0 && this._frmDocu != null) {
            this._frmDocu.dispose();
            this._frmDocu = null;
        }
        this.cancelFrmLocation();
        this._planetsPanel.stopThread();
    }

    private void chkMnuContinous_ActionPerformed(ActionEvent actionEvent) {
        this._planetsPanel.setRunMode(false);
    }

    private void chkMnuSingleStep_ActionPerformed(ActionEvent actionEvent) {
        this._planetsPanel.setRunMode(true);
    }

    private void chkMnuBackward_ActionPerformed(ActionEvent actionEvent) {
        this._planetsPanel.setTimeForward(false);
    }

    private void chkMnuForward_ActionPerformed(ActionEvent actionEvent) {
        this._planetsPanel.setTimeForward(true);
    }

    private void chkMnuPlaneY_Z_ActionPerformed(ActionEvent actionEvent) {
        this._iAbsciss = 1;
        this._iOrdinate = 2;
        this._planetsPanel.setAxisOfEcliptic(this._iAbsciss, this._iOrdinate);
    }

    private void chkMnuPlaneX_Z_ActionPerformed(ActionEvent actionEvent) {
        this._iAbsciss = 0;
        this._iOrdinate = 2;
        this._planetsPanel.setAxisOfEcliptic(this._iAbsciss, this._iOrdinate);
    }

    private void chkMnuPlaneX_Y_ActionPerformed(ActionEvent actionEvent) {
        this._iAbsciss = 0;
        this._iOrdinate = 1;
        this._planetsPanel.setAxisOfEcliptic(this._iAbsciss, this._iOrdinate);
    }

    private void chkMnuVector_ActionPerformed(ActionEvent actionEvent) {
        this._planetsPanel.setRadiusVector(this.chkMnuVector.isSelected());
    }

    private void mitLocation_ActionPerformed(ActionEvent actionEvent) {
        if (this._frmLocation == null) {
            this._frmLocation = new FrmLocation(this);
        }
        this._frmLocation.setVisible(true);
    }

    private void mitchkHorizontal_ActionPerformed(ActionEvent actionEvent) {
        if (this._viewType != 3) {
            this._viewType = 3;
            this._frmLocation = new FrmLocation(this);
            double d = this._frmLocation.getLongitude();
            double d2 = this._frmLocation.getLatitude();
            int n = this._frmLocation.getTimeZone();
            this.setStateMnuPlaneOptions(false);
            this.setHorizontal(d, d2, n);
            this._frmLocation.setVisible(true);
        }
    }

    private void mitchkEquatorial_ActionPerformed(ActionEvent actionEvent) {
        if (this._viewType != 2) {
            this._viewType = 2;
            this._planetsPanel.setEquatorial();
            this.setTitle("BoPlanets: Equatorial View");
            this.cancelFrmLocation();
            this.setStateMnuPlaneOptions(false);
        }
    }

    private void mitchkLogEcliptic_ActionPerformed(ActionEvent actionEvent) {
        if (this._viewType != 1) {
            this._viewType = 1;
            this._planetsPanel.setLogEcliptic(this._iAbsciss, this._iOrdinate);
            this.setTitle("BoPlanets: Logarithmic Ecliptic View");
            this.cancelFrmLocation();
            this.setStateMnuPlaneOptions(true);
        }
    }

    private void mitchkEcliptic_ActionPerformed(ActionEvent actionEvent) {
        if (this._viewType != 0) {
            this._viewType = 0;
            this._planetsPanel.setEcliptic(this._iAbsciss, this._iOrdinate);
            this.setTitle("BoPlanets: Ecliptic View");
            this.cancelFrmLocation();
            this.setStateMnuPlaneOptions(true);
        }
    }

    private void PlanetsViewResized(ComponentEvent componentEvent) {
        int n = this.getWidth();
        int n2 = n / 56;
        int n3 = (this._noSelectedPlanets + n2) / n2;
        int n4 = this.getHeight() - 41 * n3 - this._heightInsetsMenubar - this._heightInsetsBottom - 1;
        if (this._planetsPanel != null) {
            this._planetsPanel.resizePanel(n - 10, n4);
        }
    }

    private void mitCloseActionPeformed(ActionEvent actionEvent) {
        this.dispose();
    }

    protected void FormLocationClosed() {
        this.mitLocation.setEnabled(true);
    }

    protected void PnlOrbitalParametersClosed() {
        this.mnuParameters.setEnabled(true);
    }

    protected void PnlRiseTransSetClosed() {
        this.mnuRiseTransSet.setEnabled(true);
    }

    protected void FormLocation_LocationChanged(double d, double d2, int n) {
        this.setHorizontal(d, d2, n);
    }

    private void setHorizontal(double d, double d2, int n) {
        this._planetsPanel.setHorizontal(d, d2, n);
        String string = "BoPlanets: Horizontal View";
        string = string + ", longitude: " + d;
        string = string + ", latitude: " + d2;
        string = string + ", time zone: " + n;
        this.setTitle(string);
    }

    private void createPlanetImages(int n, int[] nArray) {
        String string;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            string = Const.planetNames[n3];
            this.createPlanetImage(i, string);
        }
        string = Const.planetNames[n];
        this.createPlanetImage(n2, string);
    }

    private void createPlanetImage(int n, String string) {
        JLabel jLabel = (JLabel)this.getContentPane().getComponent(n);
        jLabel.setSize(51, 40);
        jLabel.setVisible(true);
        jLabel.setToolTipText(string);
        String string2 = "images/" + string + ".jpg";
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL uRL = this.getClass().getResource(string2);
        if (uRL != null) {
            try {
                Image image = toolkit.getImage(uRL);
                Image image2 = image.getScaledInstance(51, 40, 1);
                jLabel.setIcon(new ImageIcon(image2, string));
            }
            catch (SecurityException securityException) {
                System.out.println("Exception:" + string2);
            }
        }
    }

    private void setStateMnuPlaneOptions(boolean bl) {
        this.chkMnuPlaneX_Y.setEnabled(bl);
        this.chkMnuPLaneX_Z.setEnabled(bl);
        this.chkMnuPlaneY_Z.setEnabled(bl);
    }

    private void cancelFrmLocation() {
        if (this._frmLocation != null) {
            this._frmLocation.disposeFrame();
            this._frmLocation = null;
            this.mitLocation.setEnabled(false);
        }
    }
}

