/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.gui.EquatorSystem;
import boplanets.planetSystem.Planet;
import boplanets.util.AstroMath;

public class HorizontSystem
extends EquatorSystem {
    private static final double MIN_AZI = -180.0;
    private static final double MAX_AZI = 180.0;
    private static final double[] MIN_MAX_AZI = new double[]{-180.0, 180.0};
    private double[] _minMaxAlt;
    private double _minDec;
    private double _maxDec;
    private Planet _objObserver;
    private Planet[] _arrPlanets;
    private double _latitudeObs;
    private double _longitudeObs;

    public HorizontSystem(Planet[] planetArray, double d, double d2) {
        super(planetArray);
        this._viewType = 3;
        this._longitudeObs = d * (Math.PI / 180);
        this._latitudeObs = d2 * (Math.PI / 180);
        int n = planetArray.length - 1;
        this._objObserver = planetArray[n];
        this._arrPlanets = planetArray;
        this.setMinMaxCoordinates(planetArray);
    }

    public void setLongitudeAndLatitude(double d, double d2) {
        this._longitudeObs = d * (Math.PI / 180);
        this._latitudeObs = d2 * (Math.PI / 180);
        this.setMinMaxCoordinates(this._arrPlanets);
    }

    @Override
    public void setMinMaxCoordinates(Planet[] planetArray) {
        double[] dArray = EquatorSystem.getMinMaxEquatorCoordinates(planetArray);
        this._minDec = dArray[2];
        this._maxDec = dArray[3];
        this._minMaxAlt = this.getMinMaxAltitude(this._latitudeObs * 57.29577951308232, this._minDec, this._maxDec);
    }

    @Override
    public double[] getNextCoordinates(Planet planet, double[] dArray) {
        double[] dArray2 = super.getNextCoordinates(planet, dArray);
        double d = dArray2[0] * (Math.PI / 180);
        double d2 = dArray2[1] * (Math.PI / 180);
        double d3 = this._objObserver.gmstRad;
        double d4 = (d3 + this._longitudeObs) % (Math.PI * 2);
        double[] dArray3 = AstroMath.equatorToHorizon(d4, d, d2, this._latitudeObs);
        double d5 = dArray3[0] * 57.29577951308232;
        double d6 = dArray3[1] * 57.29577951308232;
        planet.azi = d5;
        planet.alt = d6;
        double[] dArray4 = new double[]{d5, d6};
        return dArray4;
    }

    public double[] getAziAltAtDate(long l, Planet planet, Planet planet2) {
        double[] dArray = super.getRaDecDerivAtDate(l, planet, planet2);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = planet2.getGmst(l);
        double d4 = (d3 + this._longitudeObs) % (Math.PI * 2);
        double[] dArray2 = AstroMath.equatorToHorizon(d4, d, d2, this._latitudeObs);
        return dArray2;
    }

    @Override
    protected double[] getSpecMapParams(int n, int n2) {
        double[] dArray = HorizontSystem.getMapParams(n, n2, MIN_MAX_AZI, this._minMaxAlt);
        return dArray;
    }

    private double[] getMinMaxAltitude(double d, double d2, double d3) {
        double d4;
        double d5;
        if (d >= 0.0) {
            d5 = d <= d3 ? 90.0 : d3 + (90.0 - d);
            d4 = d > Math.abs(d2) ? -Math.abs(d2) - (90.0 - d) : -90.0;
        } else {
            double d6 = Math.abs(d);
            d5 = d6 <= Math.abs(d2) ? 90.0 : Math.abs(d2) + (90.0 - d6);
            d4 = d6 <= Math.abs(d3) ? -90.0 : -(d3 + (90.0 - d6));
        }
        d5 = (Math.floor((d5 - 0.01) / 2.0) + 1.0) * 2.0;
        d4 = (Math.ceil((d4 + 0.01) / 2.0) - 1.0) * 2.0;
        double[] dArray = new double[]{d4, d5};
        return dArray;
    }
}

