/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.gui.ILocationReceiver;
import boplanets.gui.Location;
import boplanets.gui.PlanetsView;
import boplanets.gui.PnlLocations;
import boplanets.util.NumberConverter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;

public class FrmLocation
extends JFrame
implements ILocationReceiver {
    private JButton btnClose;
    private JButton btnOk;
    private JPanel pnlInput;
    private JTextField txtLat;
    private JTextField txtLong;
    private JTextField txtTimeZone;
    private PlanetsView _parent;
    private PnlLocations _locations;
    private URL _iconImgUrl;
    private double _longitude;
    private double _latitude;
    private int _timeZone;
    private static final String VALUE_NOT_VALID = "value not valid.";
    private static final double MAX_LONGITUDE = 180.0;
    private static final double MIN_LONGITUDE = -180.0;
    private static final double MIN_LATITUDE = -90.0;
    private static final double MAX_LATITUDE = 90.0;
    private static final double MIN_TIME_ZONE = -12.0;
    private static final double MAX_TIME_ZONE = 12.0;
    private static final String TREE_TITLE = "Observing Locations";

    public FrmLocation(PlanetsView planetsView) {
        this._parent = planetsView;
        this._iconImgUrl = this.getClass().getResource("images/observe.gif");
        this.initComponents();
        this._locations = new PnlLocations(this);
        this.getContentPane().add(this._locations);
        this.setSize(220, 500);
    }

    private void initComponents() {
        this.pnlInput = new JPanel();
        this.txtLong = new JTextField();
        this.txtLat = new JTextField();
        this.txtTimeZone = new JTextField();
        this.btnOk = new JButton();
        this.btnClose = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Observer Locations");
        this.setFont(new Font("Arial", 0, 11));
        this.setIconImage(new ImageIcon(this._iconImgUrl).getImage());
        this.setMinimumSize(new Dimension(200, 300));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FrmLocation.this.FrmLocation_Closing(windowEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                FrmLocation.this.frame_ComponentResized(componentEvent);
            }
        });
        this.getContentPane().setLayout(new FlowLayout(1, 5, 10));
        this.pnlInput.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")));
        this.pnlInput.setFont(new Font("Arial", 0, 11));
        this.pnlInput.setPreferredSize(new Dimension(205, 90));
        this.txtLong.setFont(new Font("Arial", 0, 11));
        this.txtLong.setToolTipText("enter longitude of the observer in degrees: -180<= longitude >= 180");
        this.txtLong.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "longitude", 0, 0, new Font("Arial", 0, 11), UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")));
        this.txtLong.setPreferredSize(new Dimension(60, 45));
        this.txtLong.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                FrmLocation.this.txtLong_FocusLost(focusEvent);
            }
        });
        this.pnlInput.add(this.txtLong);
        this.txtLat.setFont(new Font("Arial", 0, 11));
        this.txtLat.setToolTipText("enter latitude of the observer: -90 <= lat >= 90");
        this.txtLat.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "latitude", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.txtLat.setPreferredSize(new Dimension(60, 45));
        this.txtLat.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                FrmLocation.this.txtLat_FocusLost(focusEvent);
            }
        });
        this.pnlInput.add(this.txtLat);
        this.txtTimeZone.setFont(new Font("Arial", 0, 11));
        this.txtTimeZone.setToolTipText("enter time zone of the observer as integer: -12 <= tz <= 12");
        this.txtTimeZone.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "time zone", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.txtTimeZone.setPreferredSize(new Dimension(60, 45));
        this.txtTimeZone.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                FrmLocation.this.txtTimeZone_FocusLost(focusEvent);
            }
        });
        this.pnlInput.add(this.txtTimeZone);
        this.btnOk.setFont(new Font("Arial", 0, 11));
        this.btnOk.setText("Apply");
        this.btnOk.setToolTipText("apply actual coordinates and time zone");
        this.btnOk.setBorder(new SoftBevelBorder(0));
        this.btnOk.setPreferredSize(new Dimension(62, 22));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrmLocation.this.btnOk_ActionPerformed(actionEvent);
            }
        });
        this.pnlInput.add(this.btnOk);
        this.btnClose.setFont(new Font("Arial", 0, 11));
        this.btnClose.setText("Close");
        this.btnClose.setToolTipText("close the location window without applying the actual values");
        this.btnClose.setBorder(new SoftBevelBorder(0));
        this.btnClose.setPreferredSize(new Dimension(62, 22));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrmLocation.this.btnCloseActionPerformed(actionEvent);
            }
        });
        this.pnlInput.add(this.btnClose);
        this.getContentPane().add(this.pnlInput);
        this.pack();
    }

    private void FrmLocation_Closing(WindowEvent windowEvent) {
        this.setVisible(false);
        this._parent.FormLocationClosed();
    }

    private void btnOk_ActionPerformed(ActionEvent actionEvent) {
        this._parent.FormLocation_LocationChanged(this._longitude, this._latitude, this._timeZone);
    }

    private void txtTimeZone_FocusLost(FocusEvent focusEvent) {
        String string = this.txtTimeZone.getText();
        try {
            int n = Integer.valueOf(string);
            if (n >= -12 && n <= 12) {
                if (n != this._timeZone) {
                    this._timeZone = n;
                    this._locations.clearSelection();
                }
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Toolkit.getDefaultToolkit().beep();
        this.txtTimeZone.setText(String.valueOf(this._timeZone));
        this.txtTimeZone.requestFocusInWindow();
    }

    private void txtLat_FocusLost(FocusEvent focusEvent) {
        String string = this.txtLat.getText();
        try {
            double d = NumberConverter.checkDecimalValue(string, -90.0, 90.0);
            if (d == this._latitude) {
                return;
            }
            this._latitude = d;
            this._locations.clearSelection();
        }
        catch (NumberFormatException numberFormatException) {
            Toolkit.getDefaultToolkit().beep();
            this.txtLat.requestFocusInWindow();
        }
        string = NumberConverter.format(this._latitude);
        this.txtLat.setText(string);
    }

    private void txtLong_FocusLost(FocusEvent focusEvent) {
        String string = this.txtLong.getText();
        try {
            double d = NumberConverter.checkDecimalValue(string, -180.0, 180.0);
            if (d == this._longitude) {
                return;
            }
            this._longitude = d;
            this._locations.clearSelection();
        }
        catch (NumberFormatException numberFormatException) {
            Toolkit.getDefaultToolkit().beep();
            this.txtLong.requestFocusInWindow();
        }
        string = NumberConverter.format(this._longitude);
        this.txtLong.setText(string);
    }

    private void frame_ComponentResized(ComponentEvent componentEvent) {
        int n = this.getWidth() - 20;
        int n2 = this.getHeight() - this.pnlInput.getHeight() - 30 - this.getInsets().top - this.getInsets().bottom;
        this.pnlInput.setVisible(false);
        this._locations.setPreferredSize(new Dimension(n, n2));
        this.pnlInput.setVisible(true);
    }

    private void btnCloseActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this._parent.FormLocationClosed();
    }

    protected void disposeFrame() {
        this.dispose();
    }

    @Override
    public void setLocation(Location location) {
        this._longitude = location.geoLongitude;
        String string = NumberConverter.format(this._longitude);
        this.txtLong.setText(string);
        this._latitude = location.geoLatitude;
        string = NumberConverter.format(this._latitude);
        this.txtLat.setText(string);
        this._timeZone = location.timeZone;
        this.txtTimeZone.setText(String.valueOf(this._timeZone));
    }

    protected double getLongitude() {
        return this._longitude;
    }

    protected double getLatitude() {
        return this._latitude;
    }

    protected int getTimeZone() {
        return this._timeZone;
    }
}

