/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.MetaBean;
import weka.gui.beans.Visible;

public class BeanConnection
implements Serializable {
    private static final long serialVersionUID = 8804264241791332064L;
    private static ArrayList<Vector<BeanConnection>> TABBED_CONNECTIONS = new ArrayList();
    private final BeanInstance m_source;
    private final BeanInstance m_target;
    private final String m_eventName;
    private boolean m_hidden = false;

    public static void init() {
        TABBED_CONNECTIONS.clear();
        TABBED_CONNECTIONS.add(new Vector());
    }

    public static Vector<BeanConnection> getConnections(Integer ... tab) {
        Vector<BeanConnection> returnV = null;
        int index = 0;
        if (tab.length > 0) {
            index = tab[0];
        }
        if (TABBED_CONNECTIONS.size() > 0) {
            returnV = TABBED_CONNECTIONS.get(index);
        }
        return returnV;
    }

    public static void setConnections(Vector<BeanConnection> connections, Integer ... tab) {
        int index = 0;
        if (tab.length > 0) {
            index = tab[0];
        }
        if (index < TABBED_CONNECTIONS.size()) {
            TABBED_CONNECTIONS.set(index, connections);
        }
    }

    public static void addConnections(Vector<BeanConnection> connections) {
        TABBED_CONNECTIONS.add(connections);
    }

    public static void appendConnections(Vector<BeanConnection> connections, int tab) {
        if (tab < TABBED_CONNECTIONS.size()) {
            Vector<BeanConnection> cons = TABBED_CONNECTIONS.get(tab);
            for (int i = 0; i < connections.size(); ++i) {
                cons.add(connections.get(i));
            }
        }
    }

    private static boolean previousLink(BeanInstance source, BeanInstance target, int index, Integer ... tab) {
        int tabIndex = 0;
        if (tab.length > 0) {
            tabIndex = tab[0];
        }
        Vector<BeanConnection> connections = TABBED_CONNECTIONS.get(tabIndex);
        for (int i = 0; i < connections.size(); ++i) {
            BeanConnection bc = connections.elementAt(i);
            BeanInstance compSource = bc.getSource();
            BeanInstance compTarget = bc.getTarget();
            if (compSource != source || compTarget != target || index >= i) continue;
            return true;
        }
        return false;
    }

    private static boolean checkTargetConstraint(BeanInstance candidate, Vector<Object> listToCheck, Integer ... tab) {
        int tabIndex = 0;
        if (tab.length > 0) {
            tabIndex = tab[0];
        }
        Vector<BeanConnection> connections = TABBED_CONNECTIONS.get(tabIndex);
        for (int i = 0; i < connections.size(); ++i) {
            BeanConnection bc = connections.elementAt(i);
            if (bc.getTarget() != candidate) continue;
            for (int j = 0; j < listToCheck.size(); ++j) {
                BeanInstance tempSource = (BeanInstance)listToCheck.elementAt(j);
                if (bc.getSource() != tempSource) continue;
                return false;
            }
        }
        return true;
    }

    public static Vector<BeanConnection> associatedConnections(Vector<Object> subFlow, Integer ... tab) {
        int tabIndex = 0;
        if (tab.length > 0) {
            tabIndex = tab[0];
        }
        Vector<BeanConnection> connections = TABBED_CONNECTIONS.get(tabIndex);
        Vector<BeanConnection> associatedConnections = new Vector<BeanConnection>();
        block0: for (int i = 0; i < connections.size(); ++i) {
            BeanConnection bc = connections.elementAt(i);
            BeanInstance tempSource = bc.getSource();
            BeanInstance tempTarget = bc.getTarget();
            boolean sourceInSubFlow = false;
            boolean targetInSubFlow = false;
            for (int j = 0; j < subFlow.size(); ++j) {
                BeanInstance toCheck = (BeanInstance)subFlow.elementAt(j);
                if (toCheck == tempSource) {
                    sourceInSubFlow = true;
                }
                if (toCheck == tempTarget) {
                    targetInSubFlow = true;
                }
                if (!sourceInSubFlow || !targetInSubFlow) continue;
                associatedConnections.add(bc);
                continue block0;
            }
        }
        return associatedConnections;
    }

    public static Vector<Object> inputs(Vector<Object> subset, Integer ... tab) {
        Vector<Object> result = new Vector<Object>();
        for (int i = 0; i < subset.size(); ++i) {
            BeanInstance temp = (BeanInstance)subset.elementAt(i);
            if (!BeanConnection.checkTargetConstraint(temp, subset, tab)) continue;
            result.add(temp);
        }
        return result;
    }

    private static boolean checkForTarget(BeanInstance candidate, Vector<Object> listToCheck, Integer ... tab) {
        int tabIndex = 0;
        if (tab.length > 0) {
            tabIndex = tab[0];
        }
        Vector<BeanConnection> connections = TABBED_CONNECTIONS.get(tabIndex);
        for (int i = 0; i < connections.size(); ++i) {
            BeanConnection bc = connections.elementAt(i);
            if (bc.getTarget() != candidate) continue;
            for (int j = 0; j < listToCheck.size(); ++j) {
                BeanInstance tempSource = (BeanInstance)listToCheck.elementAt(j);
                if (bc.getSource() != tempSource) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInList(BeanInstance candidate, Vector<Object> listToCheck) {
        for (int i = 0; i < listToCheck.size(); ++i) {
            BeanInstance temp = (BeanInstance)listToCheck.elementAt(i);
            if (candidate != temp) continue;
            return true;
        }
        return false;
    }

    private static boolean checkSourceConstraint(BeanInstance candidate, Vector<Object> listToCheck, Integer ... tab) {
        int tabIndex = 0;
        if (tab.length > 0) {
            tabIndex = tab[0];
        }
        Vector<BeanConnection> connections = TABBED_CONNECTIONS.get(tabIndex);
        boolean result = true;
        for (int i = 0; i < connections.size(); ++i) {
            BeanConnection bc = connections.elementAt(i);
            if (bc.getSource() != candidate) continue;
            BeanInstance cTarget = bc.getTarget();
            if (!BeanConnection.isInList(cTarget, listToCheck)) {
                return true;
            }
            for (int j = 0; j < listToCheck.size(); ++j) {
                BeanInstance tempTarget = (BeanInstance)listToCheck.elementAt(j);
                if (bc.getTarget() != tempTarget) continue;
                result = false;
            }
        }
        return result;
    }

    public static Vector<Object> outputs(Vector<Object> subset, Integer ... tab) {
        Vector<Object> result = new Vector<Object>();
        for (int i = 0; i < subset.size(); ++i) {
            BeanInstance temp = (BeanInstance)subset.elementAt(i);
            if (!BeanConnection.checkForTarget(temp, subset, tab) || !BeanConnection.checkSourceConstraint(temp, subset, tab)) continue;
            try {
                BeanInfo bi = Introspector.getBeanInfo(temp.getBean().getClass());
                EventSetDescriptor[] esd = bi.getEventSetDescriptors();
                if (esd == null || esd.length <= 0) continue;
                result.add(temp);
                continue;
            }
            catch (IntrospectionException ex) {
                // empty catch block
            }
        }
        return result;
    }

    public static void paintConnections(Graphics gx, Integer ... tab) {
        int tabIndex = 0;
        if (tab.length > 0) {
            tabIndex = tab[0];
        }
        Vector<BeanConnection> connections = TABBED_CONNECTIONS.get(tabIndex);
        for (int i = 0; i < connections.size(); ++i) {
            double angle;
            BeanVisual targetVisual;
            BeanConnection bc = connections.elementAt(i);
            if (bc.isHidden()) continue;
            BeanInstance source = bc.getSource();
            BeanInstance target = bc.getTarget();
            EventSetDescriptor srcEsd = bc.getSourceEventSetDescriptor();
            BeanVisual sourceVisual = source.getBean() instanceof Visible ? ((Visible)source.getBean()).getVisual() : null;
            BeanVisual beanVisual = targetVisual = target.getBean() instanceof Visible ? ((Visible)target.getBean()).getVisual() : null;
            if (sourceVisual == null || targetVisual == null) continue;
            Point bestSourcePt = sourceVisual.getClosestConnectorPoint(new Point(target.getX() + target.getWidth() / 2, target.getY() + target.getHeight() / 2));
            Point bestTargetPt = targetVisual.getClosestConnectorPoint(new Point(source.getX() + source.getWidth() / 2, source.getY() + source.getHeight() / 2));
            gx.setColor(Color.red);
            boolean active = true;
            if (source.getBean() instanceof EventConstraints && !((EventConstraints)source.getBean()).eventGeneratable(srcEsd.getName())) {
                gx.setColor(Color.gray);
                active = false;
            }
            gx.drawLine((int)bestSourcePt.getX(), (int)bestSourcePt.getY(), (int)bestTargetPt.getX(), (int)bestTargetPt.getY());
            try {
                double a = (bestSourcePt.getY() - bestTargetPt.getY()) / (bestSourcePt.getX() - bestTargetPt.getX());
                angle = Math.atan(a);
            }
            catch (Exception ex) {
                angle = 1.5707963267948966;
            }
            Point arrowstart = new Point(bestTargetPt.x, bestTargetPt.y);
            Point arrowoffset = new Point((int)(7.0 * Math.cos(angle)), (int)(7.0 * Math.sin(angle)));
            Point arrowend = bestSourcePt.getX() >= bestTargetPt.getX() ? new Point(arrowstart.x + arrowoffset.x, arrowstart.y + arrowoffset.y) : new Point(arrowstart.x - arrowoffset.x, arrowstart.y - arrowoffset.y);
            int[] xs = new int[]{arrowstart.x, arrowend.x + (int)(7.0 * Math.cos(angle + 1.5707963267948966)), arrowend.x + (int)(7.0 * Math.cos(angle - 1.5707963267948966))};
            int[] ys = new int[]{arrowstart.y, arrowend.y + (int)(7.0 * Math.sin(angle + 1.5707963267948966)), arrowend.y + (int)(7.0 * Math.sin(angle - 1.5707963267948966))};
            gx.fillPolygon(xs, ys, 3);
            int midx = (int)bestSourcePt.getX();
            midx += (int)((bestTargetPt.getX() - bestSourcePt.getX()) / 2.0);
            int midy = (int)bestSourcePt.getY();
            midy += (int)((bestTargetPt.getY() - bestSourcePt.getY()) / 2.0) - 2;
            gx.setColor(active ? Color.blue : Color.gray);
            if (BeanConnection.previousLink(source, target, i, tab)) {
                midy -= 15;
            }
            gx.drawString(srcEsd.getName(), midx, midy);
        }
    }

    public static Vector<BeanConnection> getClosestConnections(Point pt, int delta, Integer ... tab) {
        int tabIndex = 0;
        if (tab.length > 0) {
            tabIndex = tab[0];
        }
        Vector<BeanConnection> connections = TABBED_CONNECTIONS.get(tabIndex);
        Vector<BeanConnection> closestConnections = new Vector<BeanConnection>();
        for (int i = 0; i < connections.size(); ++i) {
            BeanVisual targetVisual;
            BeanConnection bc = connections.elementAt(i);
            BeanInstance source = bc.getSource();
            BeanInstance target = bc.getTarget();
            bc.getSourceEventSetDescriptor();
            BeanVisual sourceVisual = source.getBean() instanceof Visible ? ((Visible)source.getBean()).getVisual() : null;
            BeanVisual beanVisual = targetVisual = target.getBean() instanceof Visible ? ((Visible)target.getBean()).getVisual() : null;
            if (sourceVisual == null || targetVisual == null) continue;
            Point bestSourcePt = sourceVisual.getClosestConnectorPoint(new Point(target.getX() + target.getWidth() / 2, target.getY() + target.getHeight() / 2));
            Point bestTargetPt = targetVisual.getClosestConnectorPoint(new Point(source.getX() + source.getWidth() / 2, source.getY() + source.getHeight() / 2));
            int minx = (int)Math.min(bestSourcePt.getX(), bestTargetPt.getX());
            int maxx = (int)Math.max(bestSourcePt.getX(), bestTargetPt.getX());
            int miny = (int)Math.min(bestSourcePt.getY(), bestTargetPt.getY());
            int maxy = (int)Math.max(bestSourcePt.getY(), bestTargetPt.getY());
            if (!(pt.getX() >= (double)(minx - delta)) || !(pt.getX() <= (double)(maxx + delta)) || !(pt.getY() >= (double)(miny - delta)) || !(pt.getY() <= (double)(maxy + delta))) continue;
            double a = bestSourcePt.getY() - bestTargetPt.getY();
            double b = bestTargetPt.getX() - bestSourcePt.getX();
            double c = bestSourcePt.getX() * bestTargetPt.getY() - bestTargetPt.getX() * bestSourcePt.getY();
            double distance = Math.abs(a * pt.getX() + b * pt.getY() + c);
            if (!((distance /= Math.abs(Math.sqrt(a * a + b * b))) <= (double)delta)) continue;
            closestConnections.addElement(bc);
        }
        return closestConnections;
    }

    public static void removeConnectionList(Integer tab) {
        TABBED_CONNECTIONS.remove(tab);
    }

    public static void removeConnections(BeanInstance instance, Integer ... tab) {
        int tabIndex = 0;
        if (tab.length > 0) {
            tabIndex = tab[0];
        }
        Vector<BeanConnection> connections = TABBED_CONNECTIONS.get(tabIndex);
        Vector<Object> instancesToRemoveFor = new Vector<BeanInstance>();
        if (instance.getBean() instanceof MetaBean) {
            instancesToRemoveFor = ((MetaBean)instance.getBean()).getBeansInSubFlow();
        } else {
            instancesToRemoveFor.add(instance);
        }
        Vector<BeanConnection> removeVector = new Vector<BeanConnection>();
        for (int j = 0; j < instancesToRemoveFor.size(); ++j) {
            BeanInstance tempInstance = (BeanInstance)instancesToRemoveFor.elementAt(j);
            for (int i = 0; i < connections.size(); ++i) {
                BeanConnection bc = connections.elementAt(i);
                BeanInstance tempTarget = bc.getTarget();
                BeanInstance tempSource = bc.getSource();
                EventSetDescriptor tempEsd = bc.getSourceEventSetDescriptor();
                if (tempInstance == tempTarget) {
                    try {
                        Method deregisterMethod = tempEsd.getRemoveListenerMethod();
                        Object targetBean = tempTarget.getBean();
                        Object[] args = new Object[]{targetBean};
                        deregisterMethod.invoke(tempSource.getBean(), args);
                        removeVector.addElement(bc);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (tempInstance != tempSource) continue;
                removeVector.addElement(bc);
                if (!(tempTarget.getBean() instanceof BeanCommon)) continue;
                ((BeanCommon)tempTarget.getBean()).disconnectionNotification(tempEsd.getName(), tempSource.getBean());
            }
        }
        for (int i = 0; i < removeVector.size(); ++i) {
            connections.removeElement(removeVector.elementAt(i));
        }
    }

    public static void doMetaConnection(BeanInstance source, BeanInstance target, final EventSetDescriptor esd, final JComponent displayComponent, final int tab) {
        Object targetBean = target.getBean();
        BeanInstance realTarget = null;
        final BeanInstance realSource = source;
        if (targetBean instanceof MetaBean) {
            Vector<BeanInstance> receivers = ((MetaBean)targetBean).getSuitableTargets(esd);
            if (receivers.size() == 1) {
                realTarget = receivers.elementAt(0);
                new BeanConnection(realSource, realTarget, esd, tab);
            } else {
                int menuItemCount = 0;
                JPopupMenu targetConnectionMenu = new JPopupMenu();
                targetConnectionMenu.insert(new JLabel("Select target", 0), menuItemCount++);
                for (int i = 0; i < receivers.size(); ++i) {
                    final BeanInstance tempTarget = receivers.elementAt(i);
                    String tName = "" + (i + 1) + ": " + (tempTarget.getBean() instanceof BeanCommon ? ((BeanCommon)tempTarget.getBean()).getCustomName() : tempTarget.getBean().getClass().getName());
                    JMenuItem targetItem = new JMenuItem(tName);
                    targetItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            new BeanConnection(realSource, tempTarget, esd, tab);
                            displayComponent.repaint();
                        }
                    });
                    targetConnectionMenu.add(targetItem);
                    ++menuItemCount;
                }
                targetConnectionMenu.show(displayComponent, target.getX(), target.getY());
            }
        }
    }

    public BeanConnection(BeanInstance source, BeanInstance target, EventSetDescriptor esd, Integer ... tab) {
        int tabIndex = 0;
        if (tab.length > 0) {
            tabIndex = tab[0];
        }
        Vector<BeanConnection> connections = TABBED_CONNECTIONS.get(tabIndex);
        this.m_source = source;
        this.m_target = target;
        this.m_eventName = esd.getName();
        Method registrationMethod = esd.getAddListenerMethod();
        Object targetBean = this.m_target.getBean();
        Object[] args = new Object[]{targetBean};
        Class<?> listenerClass = esd.getListenerType();
        if (listenerClass.isInstance(targetBean)) {
            try {
                registrationMethod.invoke(this.m_source.getBean(), args);
                if (targetBean instanceof BeanCommon) {
                    ((BeanCommon)targetBean).connectionNotification(esd.getName(), this.m_source.getBean());
                }
                connections.addElement(this);
            }
            catch (Exception ex) {
                System.err.println("[BeanConnection] Unable to connect beans");
                ex.printStackTrace();
            }
        } else {
            System.err.println("[BeanConnection] Unable to connect beans");
        }
    }

    public void setHidden(boolean hidden) {
        this.m_hidden = hidden;
    }

    public boolean isHidden() {
        return this.m_hidden;
    }

    public void remove(Integer ... tab) {
        int tabIndex = 0;
        if (tab.length > 0) {
            tabIndex = tab[0];
        }
        Vector<BeanConnection> connections = TABBED_CONNECTIONS.get(tabIndex);
        EventSetDescriptor tempEsd = this.getSourceEventSetDescriptor();
        try {
            Method deregisterMethod = tempEsd.getRemoveListenerMethod();
            Object targetBean = this.getTarget().getBean();
            Object[] args = new Object[]{targetBean};
            deregisterMethod.invoke(this.getSource().getBean(), args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.getTarget().getBean() instanceof BeanCommon) {
            ((BeanCommon)this.getTarget().getBean()).disconnectionNotification(tempEsd.getName(), this.getSource().getBean());
        }
        connections.remove(this);
    }

    public BeanInstance getSource() {
        return this.m_source;
    }

    public BeanInstance getTarget() {
        return this.m_target;
    }

    public String getEventName() {
        return this.m_eventName;
    }

    protected EventSetDescriptor getSourceEventSetDescriptor() {
        JComponent bc = (JComponent)this.m_source.getBean();
        try {
            BeanInfo sourceInfo = Introspector.getBeanInfo(bc.getClass());
            if (sourceInfo == null) {
                System.err.println("[BeanConnection] Error getting bean info, source info is null.");
            } else {
                EventSetDescriptor[] esds;
                for (EventSetDescriptor esd : esds = sourceInfo.getEventSetDescriptors()) {
                    if (esd.getName().compareTo(this.m_eventName) != 0) continue;
                    return esd;
                }
            }
        }
        catch (Exception ex) {
            System.err.println("[BeanConnection] Problem retrieving event set descriptor");
        }
        return null;
    }
}

