/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.IterativeClassifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.trees.J48;
import weka.core.BatchPredictor;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PartitionGenerator;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WekaException;
import weka.filters.Filter;
import weka.filters.supervised.attribute.AttributeSelection;
import weka.filters.supervised.attribute.Discretize;

public class FilteredClassifier
extends SingleClassifierEnhancer
implements Drawable,
PartitionGenerator,
IterativeClassifier,
BatchPredictor {
    static final long serialVersionUID = -4523450618538717400L;
    protected Filter m_Filter = new AttributeSelection();
    protected Instances m_FilteredInstances;

    public String globalInfo() {
        return "Class for running an arbitrary classifier on data that has been passed through an arbitrary filter. Like the classifier, the structure of the filter is based exclusively on the training data and test instances will be processed by the filter without changing their structure.";
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    protected String defaultFilterString() {
        return "weka.filters.supervised.attribute.Discretize";
    }

    public FilteredClassifier() {
        this.m_Classifier = new J48();
        this.m_Filter = new Discretize();
    }

    @Override
    public int graphType() {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graphType();
        }
        return 0;
    }

    @Override
    public String graph() throws Exception {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graph();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot be graphed");
    }

    @Override
    public void generatePartition(Instances data) throws Exception {
        if (!(this.m_Classifier instanceof PartitionGenerator)) {
            throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot generate a partition");
        }
        this.buildClassifier(data);
    }

    @Override
    public double[] getMembershipValues(Instance inst) throws Exception {
        if (this.m_Classifier instanceof PartitionGenerator) {
            Instance newInstance = this.filterInstance(inst);
            if (newInstance == null) {
                double[] unclassified = new double[this.numElements()];
                for (int i = 0; i < unclassified.length; ++i) {
                    unclassified[i] = Utils.missingValue();
                }
                return unclassified;
            }
            return ((PartitionGenerator)((Object)this.m_Classifier)).getMembershipValues(newInstance);
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot generate a partition");
    }

    @Override
    public int numElements() throws Exception {
        if (this.m_Classifier instanceof PartitionGenerator) {
            return ((PartitionGenerator)((Object)this.m_Classifier)).numElements();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot generate a partition");
    }

    @Override
    public void initializeClassifier(Instances data) throws Exception {
        if (!(this.m_Classifier instanceof IterativeClassifier)) {
            throw new Exception("Classifier: " + this.getClassifierSpec() + " is not an IterativeClassifier");
        }
        ((IterativeClassifier)this.m_Classifier).initializeClassifier(this.setUp(data));
    }

    @Override
    public boolean next() throws Exception {
        if (this.m_Classifier instanceof IterativeClassifier) {
            return ((IterativeClassifier)this.m_Classifier).next();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " is not an IterativeClassifier");
    }

    @Override
    public void done() throws Exception {
        if (!(this.m_Classifier instanceof IterativeClassifier)) {
            throw new Exception("Classifier: " + this.getClassifierSpec() + " is not an IterativeClassifier");
        }
        ((IterativeClassifier)this.m_Classifier).done();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tFull class name of filter to use, followed\n\tby filter options.\n\teg: \"weka.filters.unsupervised.attribute.Remove -V -R 1,2\"", "F", 1, "-F <filter specification>"));
        newVector.addAll(Collections.list(super.listOptions()));
        if (this.getFilter() instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.getFilter().getClass().getName() + ":"));
            newVector.addAll(Collections.list(this.getFilter().listOptions()));
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String[] filterSpec;
        String filterString = Utils.getOption('F', options);
        if (filterString.length() <= 0) {
            filterString = this.defaultFilterString();
        }
        if ((filterSpec = Utils.splitOptions(filterString)).length == 0) {
            throw new IllegalArgumentException("Invalid filter specification string");
        }
        String filterName = filterSpec[0];
        filterSpec[0] = "";
        this.setFilter((Filter)Utils.forName(Filter.class, filterName, filterSpec));
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-F");
        options.add("" + this.getFilterSpec());
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    protected String getFilterSpec() {
        Filter c = this.getFilter();
        if (c instanceof OptionHandler) {
            return c.getClass().getName() + " " + Utils.joinOptions(c.getOptions());
        }
        return c.getClass().getName();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.getFilter() == null ? super.getCapabilities() : this.getFilter().getCapabilities();
        result.disable(Capabilities.Capability.NO_CLASS);
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        return result;
    }

    protected Instances setUp(Instances data) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception("No base classifiers have been set!");
        }
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        this.m_Filter.setInputFormat(data);
        data = Filter.useFilter(data, this.m_Filter);
        this.getClassifier().getCapabilities().testWithFail(data);
        this.m_FilteredInstances = data.stringFreeStructure();
        return data;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.m_Classifier.buildClassifier(this.setUp(data));
    }

    protected Instance filterInstance(Instance instance) throws Exception {
        if (this.m_Filter.numPendingOutput() > 0) {
            throw new Exception("Filter output queue not empty!");
        }
        if (!this.m_Filter.input(instance)) {
            if (!this.m_Filter.mayRemoveInstanceAfterFirstBatchDone()) {
                throw new Exception("Filter didn't make the test instance immediately available!");
            }
            this.m_Filter.batchFinished();
            return null;
        }
        this.m_Filter.batchFinished();
        return this.m_Filter.output();
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        Instance newInstance = this.filterInstance(instance);
        if (newInstance == null) {
            double[] unclassified = null;
            unclassified = instance.classAttribute().isNumeric() ? new double[]{Utils.missingValue()} : new double[instance.classAttribute().numValues()];
            return unclassified;
        }
        return this.m_Classifier.distributionForInstance(newInstance);
    }

    @Override
    public String batchSizeTipText() {
        return "Batch size to use if base learner is a BatchPredictor";
    }

    @Override
    public void setBatchSize(String size) {
        if (this.getClassifier() instanceof BatchPredictor) {
            ((BatchPredictor)((Object)this.getClassifier())).setBatchSize(size);
        }
    }

    @Override
    public String getBatchSize() {
        if (this.getClassifier() instanceof BatchPredictor) {
            return ((BatchPredictor)((Object)this.getClassifier())).getBatchSize();
        }
        return "1";
    }

    @Override
    public double[][] distributionsForInstances(Instances insts) throws Exception {
        if (this.getClassifier() instanceof BatchPredictor) {
            Instances filteredInsts = Filter.useFilter(insts, this.m_Filter);
            if (filteredInsts.numInstances() != insts.numInstances()) {
                throw new WekaException("FilteredClassifier: filter has returned more/less instances than required.");
            }
            return ((BatchPredictor)((Object)this.getClassifier())).distributionsForInstances(filteredInsts);
        }
        double[][] result = new double[insts.numInstances()][insts.numClasses()];
        for (int i = 0; i < insts.numInstances(); ++i) {
            result[i] = this.distributionForInstance(insts.instance(i));
        }
        return result;
    }

    @Override
    public boolean implementsMoreEfficientBatchPrediction() {
        if (!(this.getClassifier() instanceof BatchPredictor)) {
            return false;
        }
        return ((BatchPredictor)((Object)this.getClassifier())).implementsMoreEfficientBatchPrediction();
    }

    public String toString() {
        if (this.m_FilteredInstances == null) {
            return "FilteredClassifier: No model built yet.";
        }
        String result = "FilteredClassifier using " + this.getClassifierSpec() + " on data filtered through " + this.getFilterSpec() + "\n\nFiltered Header\n" + this.m_FilteredInstances.toString() + "\n\nClassifier Model\n" + this.m_Classifier.toString();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11958 $");
    }

    public static void main(String[] argv) {
        FilteredClassifier.runClassifier(new FilteredClassifier(), argv);
    }
}

