/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.util.ArrayList;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class EvaluationUtils
implements RevisionHandler {
    private int m_Seed = 1;

    public void setSeed(int seed) {
        this.m_Seed = seed;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public ArrayList<Prediction> getCVPredictions(Classifier classifier, Instances data, int numFolds) throws Exception {
        ArrayList<Prediction> predictions = new ArrayList<Prediction>();
        Instances runInstances = new Instances(data);
        Random random = new Random(this.m_Seed);
        runInstances.randomize(random);
        if (runInstances.classAttribute().isNominal() && numFolds > 1) {
            runInstances.stratify(numFolds);
        }
        for (int fold = 0; fold < numFolds; ++fold) {
            Instances train = runInstances.trainCV(numFolds, fold, random);
            Instances test = runInstances.testCV(numFolds, fold);
            ArrayList<Prediction> foldPred = this.getTrainTestPredictions(classifier, train, test);
            predictions.addAll(foldPred);
        }
        return predictions;
    }

    public ArrayList<Prediction> getTrainTestPredictions(Classifier classifier, Instances train, Instances test) throws Exception {
        classifier.buildClassifier(train);
        return this.getTestPredictions(classifier, test);
    }

    public ArrayList<Prediction> getTestPredictions(Classifier classifier, Instances test) throws Exception {
        ArrayList<Prediction> predictions = new ArrayList<Prediction>();
        for (int i = 0; i < test.numInstances(); ++i) {
            if (test.instance(i).classIsMissing()) continue;
            predictions.add(this.getPrediction(classifier, test.instance(i)));
        }
        return predictions;
    }

    public Prediction getPrediction(Classifier classifier, Instance test) throws Exception {
        double actual = test.classValue();
        double[] dist = classifier.distributionForInstance(test);
        if (test.classAttribute().isNominal()) {
            return new NominalPrediction(actual, dist, test.weight());
        }
        return new NumericPrediction(actual, dist[0], test.weight());
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10153 $");
    }
}

