/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;
import xnap.plugin.PluginInfo;
import xnap.util.FileHelper;
import xnap.util.FiletypeFilter;
import xnap.util.StringHelper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JarClassLoader
extends URLClassLoader {
    protected static Logger logger;
    protected static JarClassLoader singleton;
    protected LinkedList pluginInfos;
    static /* synthetic */ Class class$xnap$util$JarClassLoader;

    public static JarClassLoader getInstance() {
        return singleton;
    }

    public void addJar(File file) throws IOException {
        this.addJar(file.toURL());
    }

    public void addJar(URL uRL) throws IOException {
        super.addURL(uRL);
    }

    public void init() {
        try {
            this.readProperties(FileHelper.getResourceAsStream("plugins.properties"));
        }
        catch (IOException iOException) {
            logger.error("plugin.properties not found", iOException);
        }
    }

    public void readDirectory(File file) {
        File[] fileArray = file.listFiles(new FiletypeFilter("properties"));
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (!fileArray[n].getName().equals("xnap.properties")) {
                    try {
                        this.readProperties(fileArray[n]);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                ++n;
            }
        }
    }

    public void readProperties(File file, InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Invalid input stream.");
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        String[] stringArray = StringHelper.toArray(properties.getProperty("plugins", ""), ";");
        int n = 0;
        while (n < stringArray.length) {
            PluginInfo pluginInfo = new PluginInfo(stringArray[n], properties);
            if (pluginInfo.getType() != 2) {
                logger.debug("adding plugin: " + pluginInfo.getClassName());
                this.pluginInfos.add(pluginInfo);
                if (file != null) {
                    try {
                        this.loadPlugin(file, pluginInfo);
                    }
                    catch (IOException iOException) {
                        logger.warn("could not load plugin", iOException);
                    }
                } else {
                    pluginInfo.setLoaded(true);
                }
            }
            ++n;
        }
    }

    public void readProperties(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.readProperties(file.getParentFile(), fileInputStream);
    }

    public void readProperties(InputStream inputStream) throws IOException {
        this.readProperties(null, inputStream);
    }

    public void loadPlugin(File file, PluginInfo pluginInfo) throws IOException {
        if (!pluginInfo.isLoaded()) {
            this.addJar(new File(file, pluginInfo.getFilename()));
            String[] stringArray = pluginInfo.getDepends();
            int n = 0;
            while (n < stringArray.length) {
                this.addJar(new File(file, stringArray[n]));
                ++n;
            }
            pluginInfo.setLoaded(true);
        }
    }

    public String[] getClassNames(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.pluginInfos.iterator();
        while (stringArray.hasNext()) {
            PluginInfo pluginInfo = (PluginInfo)stringArray.next();
            if (pluginInfo.getType() != n) continue;
            String[] stringArray2 = pluginInfo.getClassNames();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                arrayList.add(stringArray2[n2]);
                ++n2;
            }
        }
        stringArray = new String[arrayList.size()];
        System.arraycopy(arrayList.toArray(), 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public PluginInfo[] getPluginInfos() {
        PluginInfo[] pluginInfoArray = new PluginInfo[this.pluginInfos.size()];
        System.arraycopy(this.pluginInfos.toArray(), 0, pluginInfoArray, 0, pluginInfoArray.length);
        return pluginInfoArray;
    }

    public void addManifest(Manifest manifest) {
        Attributes attributes = manifest.getAttributes("XNap");
        boolean bl = false;
        if (attributes != null) {
            bl = true;
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pluginInfos = new LinkedList();
    }

    protected JarClassLoader() {
        super(new URL[0]);
        this.this();
    }

    static {
        Class clazz = class$xnap$util$JarClassLoader;
        if (clazz == null) {
            clazz = class$xnap$util$JarClassLoader = JarClassLoader.class$("[Lxnap.util.JarClassLoader;", false);
        }
        logger = Logger.getLogger(clazz);
        singleton = new JarClassLoader();
    }
}

