/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net.msg.server;

import xnap.cmdl.Console;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.server.InvalidMessageException;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.util.QuotedStringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WhoisResponseMessage
extends ServerMessage {
    public static final int TYPE = 604;
    public String nick;
    public String userLevel;
    public int connectDuration;
    public String channels;
    public String status;
    public int sharedCount;
    public int downloadCount;
    public int uploadCount;
    public int linkSpeed;
    public String clientInfo;
    public int totalDownload;
    public int totalUploads;
    public String ip;
    public int connectingPort;
    public int dataPort;
    public String email;
    public boolean extendedInfo;

    protected void parse(QuotedStringTokenizer quotedStringTokenizer) {
        this.nick = quotedStringTokenizer.nextToken();
        this.userLevel = quotedStringTokenizer.nextToken();
        this.connectDuration = new Long(quotedStringTokenizer.nextToken()).intValue();
        this.channels = quotedStringTokenizer.nextToken();
        this.status = quotedStringTokenizer.nextToken();
        this.sharedCount = Integer.parseInt(quotedStringTokenizer.nextToken());
        this.downloadCount = Integer.parseInt(quotedStringTokenizer.nextToken());
        this.uploadCount = Integer.parseInt(quotedStringTokenizer.nextToken());
        this.linkSpeed = Integer.parseInt(quotedStringTokenizer.nextToken());
        this.clientInfo = quotedStringTokenizer.nextToken();
        if (quotedStringTokenizer.countTokens() >= 6) {
            this.extendedInfo = true;
            this.totalDownload = Integer.parseInt(quotedStringTokenizer.nextToken());
            this.totalUploads = Integer.parseInt(quotedStringTokenizer.nextToken());
            this.ip = quotedStringTokenizer.nextToken();
            this.connectingPort = Integer.parseInt(quotedStringTokenizer.nextToken());
            this.dataPort = Integer.parseInt(quotedStringTokenizer.nextToken());
            this.email = quotedStringTokenizer.nextToken();
        }
    }

    public void received() {
        User user = this.server.getUser(this.nick);
        user.setClientInfo(this.clientInfo);
        user.setConnectDuration(this.connectDuration);
        user.setDownloadCount(this.downloadCount);
        user.setFileCount(this.sharedCount);
        user.setIP(this.ip);
        user.setLevel(this.userLevel);
        user.setLinkSpeed(this.linkSpeed);
        user.setStatus(this.status);
        user.setUploadCount(this.uploadCount);
        user.notifyWhoisReceived();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("=== whois " + this.nick + " ===");
        stringBuffer.append(this.nick);
        stringBuffer.append("server: ");
        stringBuffer.append(this.server);
        stringBuffer.append("\nuser: ");
        stringBuffer.append(this.nick);
        stringBuffer.append("\nuser level: ");
        stringBuffer.append(this.userLevel);
        stringBuffer.append("\nconnect duration: ");
        stringBuffer.append(this.connectDuration);
        stringBuffer.append("\nchannels: ");
        stringBuffer.append(this.channels);
        stringBuffer.append("\nstatus: ");
        stringBuffer.append(this.status);
        stringBuffer.append("\nshared: ");
        stringBuffer.append(this.sharedCount);
        stringBuffer.append("\ndownloads: ");
        stringBuffer.append(this.downloadCount);
        stringBuffer.append("\nuploads: ");
        stringBuffer.append(this.uploadCount);
        stringBuffer.append("\nlink speed: ");
        stringBuffer.append(this.linkSpeed);
        stringBuffer.append("\nclient: ");
        stringBuffer.append(this.clientInfo);
        Console.getInstance().println(stringBuffer.toString());
    }

    private final /* synthetic */ void this() {
        this.extendedInfo = false;
    }

    public WhoisResponseMessage(String string) throws InvalidMessageException {
        super(604, string, 10);
        this.this();
    }
}

