/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net.msg.server;

import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.server.InvalidMessageException;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.util.QuotedStringTokenizer;
import xnap.util.StringHelper;

public class SearchResponseMessage
extends ServerMessage {
    public static final int TYPE = 201;
    public String filename;
    public String md5;
    public long filesize;
    public int bitrate;
    public int frequency;
    public int length;
    public String nick;
    public String ip;
    public int linkSpeed;
    public int weight;
    public int queuePos;
    public String clientInfo;

    protected void parse(QuotedStringTokenizer quotedStringTokenizer) {
        this.filename = quotedStringTokenizer.nextToken();
        this.md5 = quotedStringTokenizer.nextToken();
        this.filesize = Long.parseLong(quotedStringTokenizer.nextToken());
        this.bitrate = Integer.parseInt(quotedStringTokenizer.nextToken());
        this.frequency = Integer.parseInt(quotedStringTokenizer.nextToken());
        this.length = Integer.parseInt(quotedStringTokenizer.nextToken());
        this.nick = quotedStringTokenizer.nextToken();
        this.ip = StringHelper.parseIP(quotedStringTokenizer.nextToken());
        this.linkSpeed = Integer.parseInt(quotedStringTokenizer.nextToken());
        this.weight = 0;
        this.queuePos = -1;
        if (quotedStringTokenizer.countTokens() >= 2) {
            try {
                this.queuePos = Integer.parseInt(quotedStringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.clientInfo = quotedStringTokenizer.nextToken();
        } else if (quotedStringTokenizer.hasMoreTokens()) {
            this.weight = Integer.parseInt(quotedStringTokenizer.nextToken());
        }
    }

    public void received() {
        User user = this.server.getUser(this.nick);
        user.setIP(this.ip);
        user.setLinkSpeed(this.linkSpeed);
        if (this.clientInfo != null) {
            user.setClientInfo(this.clientInfo);
        }
    }

    public SearchResponseMessage(String string) throws InvalidMessageException {
        super(201, string, 9);
    }
}

