/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import xnap.XNap;
import xnap.gui.AbstractPanel;
import xnap.gui.XNapFrame;
import xnap.gui.event.PopupListener;
import xnap.net.IChannel;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.gui.ServerEditorDialog;
import xnap.plugin.nap.gui.table.ServerTableModel;
import xnap.plugin.nap.net.Browse;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.util.Connector;
import xnap.plugin.nap.util.NapPreferences;
import xnap.plugin.nap.util.WSXServerFile;
import xnap.util.ChatManager;
import xnap.util.FileHelper;
import xnap.util.Preferences;
import xnap.util.SearchManager;
import xnap.util.event.StatusListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ServerPanel
extends AbstractPanel
implements StatusListener {
    private Preferences prefs;
    private NapPreferences napPrefs;
    private JScrollPane jsp;
    private JTable jta;
    private ServerTableModel stm;
    private JLabel jlMyStatus;
    private NapigatorAction acNapigator;
    private UseAutoConnectorAction acUseAutoConnector;
    private ConnectAction acConnect;
    private DisconnectAction acDisconnect;
    private AddServerAction acAddServer;
    private EditServerAction acEditServer;
    private RemoveServerAction acRemoveServer;
    private OpenHostsFileAction acOpenHostsFile;
    private SaveHostsFileAction acSaveHostsFile;
    private OpenWSXFileAction acOpenWSXFile;
    private SaveWSXFileAction acSaveWSXFile;

    private final void initialize() {
        this.setLayout(new BorderLayout());
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.acConnect);
        jPopupMenu.add(this.acDisconnect);
        jPopupMenu.addSeparator();
        jPopupMenu.add(new BrowseAction());
        jPopupMenu.add(new ChatAction());
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.acEditServer);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.acAddServer);
        jPopupMenu.add(this.acRemoveServer);
        this.stm = new ServerTableModel(Connector.getInstance());
        this.jta = this.stm.createJTable();
        this.jta.setShowGrid(false);
        this.jta.addMouseListener(new TableDataListener());
        PopupListener popupListener = new PopupListener(jPopupMenu);
        this.jta.addMouseListener(popupListener);
        this.jta.getInputMap().put(KeyStroke.getKeyStroke(10, 0), this.acConnect);
        this.jta.getActionMap().put(this.acConnect, this.acConnect);
        this.jsp = new JScrollPane();
        this.jsp.setViewportView(this.jta);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JButton jButton = new JButton(this.acNapigator);
        jPanel.add(jButton);
        JCheckBox jCheckBox = new JCheckBox(this.acUseAutoConnector);
        jCheckBox.setSelected(this.napPrefs.getUseAutoconnector());
        jPanel.add(jCheckBox);
        JCheckBox jCheckBox2 = new JCheckBox(new RemoveFailedServersAction());
        jCheckBox2.setSelected(this.napPrefs.getRemoveFailedServers());
        jPanel.add(jCheckBox2);
        this.jlMyStatus = new JLabel(XNap.tr("Not connected"));
        this.add((Component)this.jlMyStatus, "North");
        this.add((Component)this.jsp, "Center");
        this.add((Component)jPanel, "South");
        Connector.getInstance().addStatsListener(new StatsListener());
        Connector.getInstance().setStatusListener(this);
    }

    public void doLoadServersFile(String string, boolean bl) {
        if (bl) {
            new Thread(this, "LoadWSXFile", string){
                final /* synthetic */ ServerPanel this$0;
                final /* synthetic */ String val$filename;

                public final void run() {
                    try {
                        WSXServerFile wSXServerFile = new WSXServerFile();
                        Server[] serverArray = WSXServerFile.readServerlist(new File(this.val$filename));
                        int n = 0;
                        while (n < serverArray.length) {
                            Connector.getInstance().addServer(serverArray[n]);
                            ++n;
                        }
                    }
                    catch (IOException iOException) {
                        this.this$0.setStatus(XNap.tr("Could not read") + ' ' + this.val$filename + ": " + iOException.getMessage());
                    }
                }
                {
                    this.this$0 = serverPanel;
                    this.val$filename = string2;
                }
            }.start();
        } else {
            new Thread(this, "LoadServersFile", string){
                final /* synthetic */ ServerPanel this$0;
                final /* synthetic */ String val$filename;

                public final void run() {
                    try {
                        Connector.getInstance().addFromFile(this.val$filename, false);
                    }
                    catch (IOException iOException) {
                        this.this$0.setStatus(XNap.tr("Could not read") + ' ' + this.val$filename + ": " + iOException.getMessage());
                    }
                }
                {
                    this.this$0 = serverPanel;
                    this.val$filename = string2;
                }
            }.start();
        }
    }

    public void doSaveServersFile(String string, boolean bl) {
        if (bl) {
            new Thread(this, "SaveWSXFile", string){
                final /* synthetic */ ServerPanel this$0;
                final /* synthetic */ String val$filename;

                public final void run() {
                    try {
                        WSXServerFile wSXServerFile = new WSXServerFile();
                        Server[] serverArray = Connector.getInstance().getServers();
                        WSXServerFile.writeServerlist(new File(this.val$filename), serverArray);
                    }
                    catch (IOException iOException) {
                        this.this$0.setStatus(XNap.tr("Could not read") + ' ' + this.val$filename + ": " + iOException.getMessage());
                    }
                }
                {
                    this.this$0 = serverPanel;
                    this.val$filename = string2;
                }
            }.start();
        } else {
            new Thread(this, "SaveServersFile", string){
                final /* synthetic */ ServerPanel this$0;
                final /* synthetic */ String val$filename;

                public final void run() {
                    try {
                        Connector.getInstance().saveToFile(this.val$filename, false);
                    }
                    catch (IOException iOException) {
                        this.this$0.setStatus(XNap.tr("Could not save") + "  " + this.val$filename + ": " + iOException.getMessage());
                    }
                }
                {
                    this.this$0 = serverPanel;
                    this.val$filename = string2;
                }
            }.start();
        }
    }

    public AbstractAction getAskNapigatorAction() {
        return this.acNapigator;
    }

    public AbstractAction getUseAutoConnectorAction() {
        return this.acUseAutoConnector;
    }

    public void doAskNapigator() {
        this.setStatus(Plugin.tr("Downloading list of servers") + "...");
        new Thread(this, "AskNapigator"){
            final /* synthetic */ ServerPanel this$0;

            public final void run() {
                Connector.getInstance().fetchServerLists();
            }
            {
                this.this$0 = serverPanel;
            }
        }.start();
    }

    public AbstractAction[] getActions() {
        AbstractAction[] abstractActionArray = new AbstractAction[13];
        abstractActionArray[0] = this.acConnect;
        abstractActionArray[1] = this.acDisconnect;
        abstractActionArray[3] = this.acEditServer;
        abstractActionArray[5] = this.acAddServer;
        abstractActionArray[6] = this.acRemoveServer;
        abstractActionArray[8] = this.acOpenHostsFile;
        abstractActionArray[9] = this.acSaveHostsFile;
        abstractActionArray[11] = this.acOpenWSXFile;
        abstractActionArray[12] = this.acSaveWSXFile;
        return abstractActionArray;
    }

    private final /* synthetic */ void this() {
        this.prefs = Preferences.getInstance();
        this.napPrefs = NapPreferences.getInstance();
        this.acNapigator = new NapigatorAction();
        this.acUseAutoConnector = new UseAutoConnectorAction();
        this.acConnect = new ConnectAction();
        this.acDisconnect = new DisconnectAction();
        this.acAddServer = new AddServerAction();
        this.acEditServer = new EditServerAction();
        this.acRemoveServer = new RemoveServerAction();
        this.acOpenHostsFile = new OpenHostsFileAction();
        this.acSaveHostsFile = new SaveHostsFileAction();
        this.acOpenWSXFile = new OpenWSXFileAction();
        this.acSaveWSXFile = new SaveWSXFileAction();
    }

    public ServerPanel() {
        this.this();
        this.initialize();
    }

    protected class StatsListener
    implements StatusListener {
        public void setStatus(String string) {
            ServerPanel.this.jlMyStatus.setText(" " + string);
        }

        protected StatsListener() {
        }
    }

    private class UseAutoConnectorAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            Connector.getInstance().setEnabled(abstractButton.isSelected());
        }

        public UseAutoConnectorAction() {
            this.putValue("Name", Plugin.tr("Connect automatically"));
            this.putValue("ShortDescription", Plugin.tr("Automatically connect to servers"));
            this.putValue("MnemonicKey", new Integer(65));
            this.putValue("SmallIcon", XNapFrame.getEmptyIcon());
        }
    }

    private class RemoveFailedServersAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            ServerPanel.this.napPrefs.setRemoveFailedServers(abstractButton.isSelected());
        }

        public RemoveFailedServersAction() {
            this.putValue("Name", Plugin.tr("Remove Unreachable Servers"));
            this.putValue("ShortDescription", Plugin.tr("Automatically remove unreachable servers"));
            this.putValue("MnemonicKey", new Integer(82));
        }
    }

    private class NapigatorAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ServerPanel.this.doAskNapigator();
        }

        public NapigatorAction() {
            this.putValue("Name", Plugin.tr("Ask Napigator"));
            this.putValue("ShortDescription", Plugin.tr("Ask Napigator for a list of servers"));
            this.putValue("SmallIcon", XNapFrame.getIcon("connect_creating.png"));
            this.putValue("MnemonicKey", new Integer(65));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
        }
    }

    private class BrowseAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ServerPanel.this.jta.getSelectedRow();
            if (n != -1) {
                Server server = ServerPanel.this.stm.get(n);
                String string = JOptionPane.showInputDialog(ServerPanel.this, Plugin.tr("Nick"), Plugin.tr("Browse User"), 3);
                if (string != null) {
                    Browse browse = new Browse(server.getUser(string));
                    SearchManager.getInstance().browse(browse);
                }
            }
        }

        public BrowseAction() {
            this.putValue("Name", Plugin.tr("Browse User") + "...");
            this.putValue("ShortDescription", Plugin.tr("Browse any User"));
            this.putValue("SmallIcon", XNapFrame.getIcon("filefind.png"));
        }
    }

    private class ChatAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ServerPanel.this.jta.getSelectedRow();
            if (n != -1) {
                Server server = ServerPanel.this.stm.get(n);
                String string = JOptionPane.showInputDialog(ServerPanel.this, "Nick", Plugin.tr("Chat with User"), 3);
                if (string != null) {
                    IChannel iChannel = server.getUser(string).getPrivateChannel();
                    ChatManager.getInstance().addChannel(iChannel);
                }
            }
        }

        public ChatAction() {
            this.putValue("Name", Plugin.tr("Chat with User") + "...");
            this.putValue("ShortDescription", Plugin.tr("Private Chat with any User."));
            this.putValue("SmallIcon", XNapFrame.getIcon("mail_generic.png"));
            this.putValue("MnemonicKey", new Integer(72));
        }
    }

    private class ConnectAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ServerPanel.this.jta.getSelectedRowCount();
            int[] nArray = ServerPanel.this.jta.getSelectedRows();
            int n2 = 0;
            while (n2 < n) {
                Connector.getInstance().login(ServerPanel.this.stm.get(nArray[n2]));
                ++n2;
            }
        }

        public ConnectAction() {
            this.putValue("Name", Plugin.tr("Connect"));
            this.putValue("ShortDescription", Plugin.tr("Connect to the selected server(s)"));
            this.putValue("SmallIcon", XNapFrame.getIcon("connect_established.png"));
            this.putValue("MnemonicKey", new Integer(67));
        }
    }

    private class DisconnectAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ServerPanel.this.jta.getSelectedRowCount();
            int[] nArray = ServerPanel.this.jta.getSelectedRows();
            int n2 = 0;
            while (n2 < n) {
                Connector.getInstance().logout(ServerPanel.this.stm.get(nArray[n2]));
                ++n2;
            }
        }

        public DisconnectAction() {
            this.putValue("Name", Plugin.tr("Disconnect"));
            this.putValue("ShortDescription", Plugin.tr("Disconnect from the selected server(s)"));
            this.putValue("SmallIcon", XNapFrame.getIcon("connect_no.png"));
            this.putValue("MnemonicKey", new Integer(68));
        }
    }

    private class AddServerAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Server server = new Server();
            ServerEditorDialog serverEditorDialog = new ServerEditorDialog(server);
            serverEditorDialog.setLocationRelativeTo(ServerPanel.this);
            serverEditorDialog.setModal(true);
            serverEditorDialog.show();
            if (serverEditorDialog.isOkay()) {
                Connector.getInstance().addServer(server);
            }
        }

        public AddServerAction() {
            this.putValue("Name", Plugin.tr("Add Server") + "...");
            this.putValue("ShortDescription", Plugin.tr("Add a server to the list"));
            this.putValue("SmallIcon", XNapFrame.getIcon("filenew.png"));
            this.putValue("MnemonicKey", new Integer(65));
        }
    }

    private class EditServerAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ServerPanel.this.jta.getSelectedRow();
            if (n != -1) {
                Server server = ServerPanel.this.stm.get(n);
                ServerEditorDialog.showDialog(ServerPanel.this, server);
            }
        }

        public EditServerAction() {
            this.putValue("Name", Plugin.tr("Edit Server") + "...");
            this.putValue("ShortDescription", Plugin.tr("Change server properties"));
            this.putValue("SmallIcon", XNapFrame.getIcon("edit.png"));
            this.putValue("MnemonicKey", new Integer(69));
        }
    }

    private class RemoveServerAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ServerPanel.this.jta.getSelectedRows();
            Server[] serverArray = new Server[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                serverArray[n] = ServerPanel.this.stm.get(nArray[n]);
                ++n;
            }
            n = 0;
            while (n < serverArray.length) {
                Connector.getInstance().removeServer(serverArray[n]);
                ++n;
            }
        }

        public RemoveServerAction() {
            this.putValue("Name", Plugin.tr("Remove Server"));
            this.putValue("ShortDescription", Plugin.tr("Remove the selected server(s) from the list"));
            this.putValue("SmallIcon", XNapFrame.getIcon("eraser.png"));
            this.putValue("MnemonicKey", new Integer(82));
        }
    }

    private class OpenHostsFileAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(FileHelper.getHomeDir() + "hosts"));
            if (jFileChooser.showOpenDialog(ServerPanel.this) == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                ServerPanel.this.doLoadServersFile(string, false);
            }
        }

        public OpenHostsFileAction() {
            this.putValue("Name", Plugin.tr("Import Hosts File"));
            this.putValue("ShortDescription", Plugin.tr("Imports a list of servers from a file"));
            this.putValue("SmallIcon", XNapFrame.getIcon("fileopen.png"));
            this.putValue("MnemonicKey", new Integer(79));
        }
    }

    private class SaveHostsFileAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(FileHelper.getHomeDir() + "hosts"));
            if (jFileChooser.showSaveDialog(ServerPanel.this) == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                ServerPanel.this.doSaveServersFile(string, false);
            }
        }

        public SaveHostsFileAction() {
            this.putValue("Name", Plugin.tr("Export Hosts File") + "...");
            this.putValue("ShortDescription", Plugin.tr("Export a file with the servers you want to save for latter use"));
            this.putValue("SmallIcon", XNapFrame.getIcon("filesave.png"));
            this.putValue("MnemonicKey", new Integer(83));
        }
    }

    private class OpenWSXFileAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showOpenDialog(ServerPanel.this) == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                ServerPanel.this.doLoadServersFile(string, true);
            }
        }

        public OpenWSXFileAction() {
            this.putValue("Name", Plugin.tr("Import WSX File"));
            this.putValue("ShortDescription", Plugin.tr("Imports a lists of servers from a file in WSX format"));
            this.putValue("SmallIcon", XNapFrame.getIcon("fileimport.png"));
            this.putValue("MnemonicKey", new Integer(79));
        }
    }

    private class SaveWSXFileAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(FileHelper.getHomeDir() + "hosts.wsx"));
            if (jFileChooser.showSaveDialog(ServerPanel.this) == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                ServerPanel.this.doSaveServersFile(string, true);
            }
        }

        public SaveWSXFileAction() {
            this.putValue("Name", Plugin.tr("Export WSX File") + "...");
            this.putValue("ShortDescription", Plugin.tr("Exports a lists of servers into a file in WSX format"));
            this.putValue("SmallIcon", XNapFrame.getIcon("fileexport.png"));
            this.putValue("MnemonicKey", new Integer(83));
        }
    }

    private class TableDataListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() == 2 && (n = ServerPanel.this.jta.rowAtPoint(mouseEvent.getPoint())) > -1) {
                ServerPanel.this.jta.getSelectionModel().setSelectionInterval(n, n);
                Connector.getInstance().login(ServerPanel.this.stm.get(n));
            }
        }

        private TableDataListener() {
        }
    }
}

