/*
 * Decompiled with CFR 0.152.
 */
package xnap.io;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ListIterator;
import xnap.io.AbstractRepository;
import xnap.io.ResumeFile;
import xnap.io.ResumeFile2;
import xnap.io.ResumeFile3;
import xnap.net.IDownloadContainer;
import xnap.util.DownloadQueue;
import xnap.util.FileHelper;
import xnap.util.Notifier;
import xnap.util.Preferences;
import xnap.util.SearchFilterData;
import xnap.util.SearchFilterHelper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ResumeRepository
extends AbstractRepository
implements PropertyChangeListener {
    public static int VERSION = 1;
    private static ResumeRepository singleton = new ResumeRepository();
    private static DownloadQueue dlQueue = DownloadQueue.getInstance();
    private Preferences prefs;
    private boolean firstTime;

    public static ResumeRepository getInstance() {
        return singleton;
    }

    public void add(ResumeFile3 resumeFile3) {
        super.add(resumeFile3);
        this.updateLater();
    }

    protected boolean exists(File file) {
        if (!file.exists()) {
            if (file instanceof ResumeFile3) {
                ResumeFile3 resumeFile3 = (ResumeFile3)file;
                File file2 = new File(this.prefs.getIncompleteDir(), file.getName());
                if (file2.exists()) {
                    ResumeFile3 resumeFile32 = new ResumeFile3(file2, resumeFile3.getFinalSize(), resumeFile3.getFilterData());
                    super.add(resumeFile32);
                }
            }
            return false;
        }
        return true;
    }

    public String getDirs() {
        return this.prefs.getIncompleteDir();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getPropertyName().equals("incompleteDir")) {
            this.updateLater();
        }
    }

    protected void postRead(boolean bl, String string) {
        if (!this.allowWrite) {
            this.allowWrite = Notifier.getInstance().canPurgeResumeRepository();
        }
    }

    protected void postUpdate() {
        if (this.firstTime) {
            ListIterator listIterator = super.listIterator();
            while (listIterator.hasNext()) {
                File file = (File)listIterator.next();
                if (file == null) continue;
                ResumeFile3 resumeFile3 = this.convert(file);
                listIterator.set(resumeFile3);
                if (resumeFile3 == null) continue;
                this.shorten(resumeFile3);
                IDownloadContainer iDownloadContainer = resumeFile3.createDownload();
                dlQueue.add(iDownloadContainer, false);
            }
            this.firstTime = false;
        }
    }

    protected ResumeFile3 convert(File file) {
        if (file instanceof ResumeFile3) {
            return (ResumeFile3)file;
        }
        if (file instanceof ResumeFile2) {
            ResumeFile2 resumeFile2 = (ResumeFile2)file;
            return new ResumeFile3(resumeFile2, resumeFile2.getFinalSize(), this.convertFilter(resumeFile2));
        }
        if (file instanceof ResumeFile) {
            ResumeFile resumeFile = (ResumeFile)file;
            return new ResumeFile3(resumeFile, resumeFile.getFinalSize(), this.convertFilter(resumeFile));
        }
        return null;
    }

    public SearchFilterData convertFilter(ResumeFile resumeFile) {
        return SearchFilterHelper.convert(resumeFile.getFilterData());
    }

    public void shorten(ResumeFile3 resumeFile3) {
        logger.debug("shorten " + resumeFile3.getName() + ", " + resumeFile3.length());
        FileHelper.shorten(resumeFile3, (int)Math.max(resumeFile3.length() - resumeFile3.getFinalSize(), 0L));
        logger.debug("add " + resumeFile3.getName() + ", " + resumeFile3.length());
    }

    private final /* synthetic */ void this() {
        this.prefs = Preferences.getInstance();
        this.firstTime = true;
    }

    private ResumeRepository() {
        super(FileHelper.getHomeDir() + "resumes", VERSION, true);
        this.this();
        this.readAndUpdateLater();
    }
}

