/*
 * Decompiled with CFR 0.152.
 */
package xnap.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import xnap.util.EventVector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractRepository
extends EventVector {
    protected static Logger logger;
    protected String dbFilename;
    protected int version;
    private Hashtable indicies;
    private HashSet deletedFiles;
    private long lastModified;
    private int nonNullCount;
    private Thread runner;
    private Object updateLock;
    private boolean updatePending;
    private boolean updateRunning;
    protected boolean allowWrite;
    protected boolean deleteOnly;
    static /* synthetic */ Class class$xnap$io$AbstractRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void add(File file) {
        boolean bl = false;
        while (!bl) {
            Object object = this.updateLock;
            // MONITORENTER : object
            {
                if (this.updateRunning) {
                    try {
                        logger.debug("add: waiting in spinlock");
                        this.updateLock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.addFile(file);
                    bl = true;
                }
                // MONITOREXIT : object
            }
        }
    }

    public abstract String getDirs();

    protected boolean exists(File file) {
        return file.exists();
    }

    public int getNonNullSize() {
        return this.nonNullCount;
    }

    public synchronized int indexOf(File file) {
        return (Integer)this.indicies.get(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isUpdateRunning() {
        Object object = this.updateLock;
        synchronized (object) {
            return this.updateRunning;
        }
    }

    public void updateLater() {
        this.updateLater(false);
    }

    protected void readAndUpdateLater() {
        this.updateLater(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateLater(boolean bl) {
        this.updatePending = true;
        Object object = this.updateLock;
        synchronized (object) {
            if (this.updateRunning) {
                return;
            }
            this.updateRunning = true;
        }
        this.runner = new Thread((Runnable)new UpdateRunner(bl), "UpdateRepository");
        this.runner.start();
    }

    protected void read() {
        logger.info("reading: " + this.dbFilename);
        this.preRead();
        boolean bl = false;
        String string = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.dbFilename));
            int n = objectInputStream.readInt();
            int n2 = objectInputStream.readInt();
            logger.debug("current version: " + n2 + ", repository version: " + this.version);
            if (n2 < this.version) {
                logger.debug("discarding old repository");
                return;
            }
            if (n >= 0) {
                logger.debug(this.dbFilename + ": allocating " + n + " items");
                this.ensureCapacity(n);
            }
            int n3 = 0;
            while (n3 < n) {
                try {
                    Object object = objectInputStream.readObject();
                    if (object != null && object instanceof File) {
                        this.addDirectory((File)object);
                    }
                }
                catch (Exception exception) {
                    logger.error("" + n3 + '/' + n + " error reading repository", exception);
                    this.allowWrite = false;
                }
                ++n3;
            }
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = "Could not find file";
        }
        catch (IOException iOException) {
            string = "Could not read file";
            this.allowWrite = false;
        }
        this.postRead(bl, string);
    }

    protected boolean write() {
        if (!this.allowWrite) {
            return false;
        }
        String string = null;
        logger.info("write: " + this.dbFilename);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.dbFilename));
            objectOutputStream.writeInt(this.nonNullCount);
            objectOutputStream.writeInt(this.version);
            Iterator iterator = super.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null) continue;
                objectOutputStream.writeObject(e);
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            this.lastModified = new File(this.dbFilename).lastModified();
            string = "Wrote " + this.dbFilename;
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = "Invalid directory " + this.dbFilename;
        }
        catch (IOException iOException) {
            string = "Could not write file " + this.dbFilename;
        }
        return false;
    }

    protected void update() {
        File file;
        Iterator iterator;
        logger.debug("update: " + this.dbFilename);
        StringTokenizer stringTokenizer = new StringTokenizer(this.getDirs(), ";");
        this.deletedFiles.clear();
        if (this.deleteOnly) {
            iterator = super.iterator();
            while (iterator.hasNext()) {
                file = (File)iterator.next();
                if (file == null || this.exists(file)) continue;
                this.deletedFiles.add(file);
            }
        } else {
            iterator = super.iterator();
            while (iterator.hasNext()) {
                file = (File)iterator.next();
                if (file == null) continue;
                this.deletedFiles.add(file);
            }
            while (stringTokenizer.hasMoreTokens()) {
                this.addDirectory(new File(stringTokenizer.nextToken()));
            }
        }
        iterator = this.deletedFiles.iterator();
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            int n = this.indexOf(file);
            logger.debug("Repository.update: deleted (" + n + ") " + file);
            super.set(n, null);
            this.indicies.remove(file);
            --this.nonNullCount;
            this.fireElementRemoved(file, n);
        }
        this.write();
    }

    protected void preRead() {
    }

    protected void postRead(boolean bl, String string) {
    }

    protected void preUpdate() {
    }

    protected void postUpdate() {
    }

    private final void addDirectory(File file) {
        if (!this.isPartOfRepository(file)) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                int n = 0;
                while (n < fileArray.length) {
                    this.addDirectory(fileArray[n]);
                    ++n;
                }
            }
        } else if (file.isFile() && file.canRead()) {
            this.addFile(file);
        }
    }

    private final void addFile(File file) {
        this.deletedFiles.remove(file);
        Integer n = (Integer)this.indicies.get(file);
        if (n == null) {
            this.addNewFile(file);
            this.indicies.put(file, new Integer(super.size() - 1));
            ++this.nonNullCount;
        } else if (file.lastModified() > this.lastModified) {
            logger.debug("addFile: update " + file);
        }
    }

    protected void addNewFile(File file) {
        super.add(file);
    }

    protected boolean isPartOfRepository(File file) {
        return true;
    }

    static /* synthetic */ boolean access$3(AbstractRepository abstractRepository) {
        return abstractRepository.updateRunning;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.indicies = new Hashtable();
        this.deletedFiles = new HashSet();
        this.nonNullCount = 0;
        this.updateLock = new Object();
        this.updatePending = false;
        this.updateRunning = false;
        this.allowWrite = true;
    }

    public AbstractRepository(String string, int n, boolean bl) {
        this.this();
        this.dbFilename = string;
        this.deleteOnly = bl;
        this.lastModified = new File(string).lastModified();
        this.version = n;
    }

    public AbstractRepository(String string, int n) {
        this(string, n, false);
    }

    static {
        Class clazz = class$xnap$io$AbstractRepository;
        if (clazz == null) {
            clazz = class$xnap$io$AbstractRepository = AbstractRepository.class$("[Lxnap.io.AbstractRepository;", false);
        }
        logger = Logger.getLogger(clazz);
    }

    private class UpdateRunner
    implements Runnable {
        boolean read;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (this.read) {
                AbstractRepository.this.read();
            }
            Thread.currentThread().setPriority(1);
            AbstractRepository.this.preUpdate();
            while (AbstractRepository.this.updatePending) {
                AbstractRepository.this.updatePending = false;
                AbstractRepository.this.update();
            }
            Object object = AbstractRepository.this.updateLock;
            synchronized (object) {
                AbstractRepository.this.updateRunning = false;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
                AbstractRepository.this.postUpdate();
                return;
            }
        }

        public UpdateRunner(boolean bl) {
            this.read = bl;
        }
    }
}

