/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.gui.table.UserTableModel;
import xnap.gui.util.SwingSynchronizedCache;
import xnap.net.IUser;
import xnap.net.event.StatusChangeEvent;
import xnap.net.event.StatusChangeListener;
import xnap.user.UserManager;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HotlistTableModel
extends UserTableModel
implements ListListener,
StatusChangeListener {
    private static Logger logger;
    private UserFilter filter;
    static /* synthetic */ Class class$xnap$gui$table$HotlistTableModel;

    public void elementAdded(ListEvent listEvent) {
        IUser iUser = (IUser)listEvent.getElement();
        iUser.addStatusChangeListener(this);
        this.addFiltered(iUser);
    }

    public void elementRemoved(ListEvent listEvent) {
        IUser iUser = (IUser)listEvent.getElement();
        iUser.removeStatusChangeListener(this);
        this.remove(iUser);
    }

    public void addFiltered(IUser iUser) {
        if (this.filter == null || this.filter.matches(iUser)) {
            this.add(iUser);
        }
    }

    public String getTableName() {
        return XNap.tr("Hotlist Table");
    }

    public void setFilter(UserFilter userFilter) {
        this.filter = userFilter;
        this.reload();
    }

    public void statusChange(StatusChangeEvent statusChangeEvent) {
        SwingUtilities.invokeLater(new StatusChangeEventHandler((IUser)statusChangeEvent.getSource()));
    }

    public void reload() {
        this.rows.clear();
        Object[] objectArray = UserManager.getInstance().toArray();
        int n = 0;
        while (n < objectArray.length) {
            IUser iUser = (IUser)objectArray[n];
            if (this.filter == null || this.filter.matches(iUser)) {
                this.rows.add(iUser);
            }
            ++n;
        }
        this.fireTableDataChanged();
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.filter = null;
    }

    public HotlistTableModel() {
        super("hotlist");
        this.this();
        SwingSynchronizedCache swingSynchronizedCache = new SwingSynchronizedCache(this);
        UserManager.getInstance().addListListener(swingSynchronizedCache);
    }

    static {
        Class clazz = class$xnap$gui$table$HotlistTableModel;
        if (clazz == null) {
            clazz = class$xnap$gui$table$HotlistTableModel = HotlistTableModel.class$("[Lxnap.gui.table.HotlistTableModel;", false);
        }
        logger = Logger.getLogger(clazz);
    }

    private class StatusChangeEventHandler
    implements Runnable {
        IUser u;

        public void run() {
            logger.debug("status change: " + this.u + " (" + this.u.getClass() + ')');
            if (HotlistTableModel.this.filter == null || HotlistTableModel.this.filter.matches(this.u)) {
                int n = HotlistTableModel.this.rows.indexOf(this.u);
                if (n != -1) {
                    HotlistTableModel.this.fireTableRowsUpdated(n, n);
                } else {
                    HotlistTableModel.this.add(this.u);
                }
            } else {
                HotlistTableModel.this.remove(this.u);
            }
        }

        public StatusChangeEventHandler(IUser iUser) {
            this.u = iUser;
        }
    }

    public static class AllFilter
    implements UserFilter {
        public boolean matches(IUser iUser) {
            return true;
        }

        public String toString() {
            return XNap.tr("All");
        }
    }

    public static class CategoryFilter
    implements UserFilter {
        String category;

        public boolean matches(IUser iUser) {
            boolean bl = false;
            if (!iUser.isTemporary() && iUser.getCategory().equals(this.category)) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return this.category;
        }

        public CategoryFilter(String string) {
            this.category = string;
        }
    }

    public static class OtherFilter
    implements UserFilter {
        UserFilter[] filters;

        public boolean matches(IUser iUser) {
            if (iUser.isTemporary()) {
                return false;
            }
            boolean bl = false;
            int n = 0;
            while (n < this.filters.length && !bl) {
                bl |= this.filters[n].matches(iUser);
                ++n;
            }
            return bl ^ true;
        }

        public String toString() {
            return XNap.tr("Other");
        }

        public OtherFilter(UserFilter[] userFilterArray) {
            this.filters = userFilterArray;
        }
    }

    public static interface UserFilter {
        public boolean matches(IUser var1);
    }
}

