/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.XNapLoader;
import xnap.gui.DefaultDialog;
import xnap.gui.XNapFrame;
import xnap.util.Preferences;
import xnap.util.VersionManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UpdateDialog
extends DefaultDialog {
    private static UpdateDialog me = null;
    private static Logger logger;
    private static Preferences prefs;
    private static VersionManager vm;
    private JTextArea jtaText;
    private JCheckBox jcAutoVersionCheck;
    private XNapFrame exitHandler;
    private UpdateAction acUpdate;
    static /* synthetic */ Class class$xnap$gui$UpdateDialog;

    public static void showDialog(XNapFrame xNapFrame, boolean bl) {
        new Thread("ShowUpdateDialog", bl, xNapFrame){
            final /* synthetic */ boolean val$showFailed;
            final /* synthetic */ XNapFrame val$c;

            public final void run() {
                if (UpdateDialog.access$0() == null) {
                    boolean bl = false;
                    try {
                        bl = UpdateDialog.access$2().check();
                    }
                    catch (IOException iOException) {
                        UpdateDialog.access$1().debug("version check failed", iOException);
                    }
                    if (!bl) {
                        if (this.val$showFailed) {
                            JOptionPane.showMessageDialog(this.val$c, XNap.tr("Sorry, no new version available."), XNap.tr("Update"), 1);
                        }
                        return;
                    }
                    UpdateDialog.access$3(new UpdateDialog(this.val$c));
                    if (this.val$c != null) {
                        UpdateDialog.access$0().setLocationRelativeTo(this.val$c);
                    }
                }
                UpdateDialog.access$0().show();
            }
            {
                this.val$showFailed = bl;
                this.val$c = xNapFrame;
            }
        }.start();
    }

    public void apply() {
        prefs.setAutoVersionCheck(this.jcAutoVersionCheck.isSelected());
        prefs.write();
    }

    static /* synthetic */ UpdateDialog access$0() {
        return me;
    }

    static /* synthetic */ Logger access$1() {
        return logger;
    }

    static /* synthetic */ void access$3(UpdateDialog updateDialog) {
        me = updateDialog;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.acUpdate = new UpdateAction();
    }

    private UpdateDialog(XNapFrame xNapFrame) {
        super(BUTTON_OKAY);
        this.this();
        this.exitHandler = xNapFrame;
        this.jtaText = new JTextArea(10, 40);
        this.jtaText.setEditable(false);
        this.jtaText.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jtaText.setText(vm.getInfo());
        JScrollPane jScrollPane = new JScrollPane(this.jtaText);
        this.jcAutoVersionCheck = new JCheckBox(XNap.tr("Check for New Version"), prefs.getAutoVersionCheck());
        this.getButtonPanel().add((Component)this.jcAutoVersionCheck, 0);
        this.getButtonPanel().add(new JButton(this.acUpdate));
        Object[] objectArray = new Object[]{"2.5r3"};
        this.setTitle(MessageFormat.format(XNap.tr("New Version Available (Current Version: {0})!"), objectArray));
        this.getMainPanel().setLayout(new BorderLayout());
        this.getMainPanel().add((Component)jScrollPane, "Center");
        this.pack();
    }

    static {
        Class clazz = class$xnap$gui$UpdateDialog;
        if (clazz == null) {
            clazz = class$xnap$gui$UpdateDialog = UpdateDialog.class$("[Lxnap.gui.UpdateDialog;", false);
        }
        logger = Logger.getLogger(clazz);
        prefs = Preferences.getInstance();
        vm = new VersionManager();
    }

    private class UpdateAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread((Runnable)new UpdateRunner(), "Update");
            thread.start();
        }

        public UpdateAction() {
            this.putValue("Name", XNap.tr("Update"));
            this.putValue("ShortDescription", XNap.tr("Update XNap to latest version"));
            this.putValue("MnemonicKey", new Integer(85));
        }
    }

    private class UpdateRunner
    implements Runnable {
        public void run() {
            UpdateDialog.this.acUpdate.setEnabled(false);
            try {
                InputStream inputStream = vm.connect();
                Object[] objectArray = new Object[]{"xnap.jar"};
                ProgressMonitorInputStream progressMonitorInputStream = new ProgressMonitorInputStream(UpdateDialog.this, MessageFormat.format(XNap.tr("Downloading {0}"), objectArray), inputStream);
                inputStream = new BufferedInputStream(progressMonitorInputStream);
                progressMonitorInputStream.getProgressMonitor().setMillisToPopup(0);
                progressMonitorInputStream.getProgressMonitor().setMillisToDecideToPopup(0);
                File file = vm.save(inputStream);
                int n = JOptionPane.showConfirmDialog(UpdateDialog.this, XNap.tr("Restart XNap?"), XNap.tr("New Version Installed"), 0);
                if (n == 0) {
                    XNapLoader.run(file);
                    UpdateDialog.this.exitHandler.doExit(false);
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(UpdateDialog.this, iOException.getLocalizedMessage(), XNap.tr("Update Error"), 0);
            }
            UpdateDialog.this.acUpdate.setEnabled(true);
        }

        private UpdateRunner() {
        }
    }
}

