/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import xnap.gui.theme.BigTheme;
import xnap.gui.theme.BoldTheme;
import xnap.gui.theme.CustomTheme;
import xnap.gui.theme.PlainTheme;
import xnap.gui.theme.Theme;
import xnap.plugin.PluginInfo;
import xnap.util.JarClassLoader;

public class ThemeManager {
    public static final String[][] EXTRA_LAFS = new String[][]{{"Kunststoff", "com.incors.plaf.kunststoff.KunststoffLookAndFeel"}, {"Simple", "com.memoire.slaf.SlafLookAndFeel"}, {"Oyoaha", "com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel"}, {"Metouia", "net.sourceforge.mlf.metouia.MetouiaLookAndFeel"}, {"OpenStep", "nextlf.plaf.NextLookAndFeel"}, {"GTK", "org.gtk.java.swing.plaf.gtk.GtkLookAndFeel"}, {"3D", "swing.addon.plaf.threeD.ThreeDLookAndFeel"}};
    public static final Theme[] THEMES = new Theme[]{new BigTheme(), new BoldTheme(), new PlainTheme(), new CustomTheme()};
    protected static Object[] savedDefaults = ThemeManager.getDefaults();

    public static Object[] getDefaults() {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Object[] objectArray = new Object[uIDefaults.size() * 2];
        int n = 0;
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            objectArray[n] = k;
            objectArray[n + 1] = uIDefaults.get(k);
            n += 2;
        }
        return objectArray;
    }

    public static void setDefaults(Object[] objectArray) {
        UIManager.getDefaults().putDefaults(objectArray);
    }

    public static void setTheme(String string) {
        int n = 0;
        while (n < THEMES.length) {
            if (THEMES[n].getClass().getName().equals(string)) {
                ThemeManager.setTheme(THEMES[n]);
                return;
            }
            ++n;
        }
    }

    public static void setTheme(Theme theme) {
        UIManager.getDefaults().putDefaults(theme.getProperties());
    }

    public static Theme[] getThemes() {
        return THEMES;
    }

    public static Object[] getSavedDefaults() {
        return savedDefaults;
    }

    public static UIManager.LookAndFeelInfo[] getInstalledLookAndFeels() {
        LinkedList<UIManager.LookAndFeelInfo> linkedList = new LinkedList<UIManager.LookAndFeelInfo>();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        if (lookAndFeelInfoArray != null) {
            int n = 0;
            while (n < lookAndFeelInfoArray.length) {
                try {
                    Class<?> clazz = JarClassLoader.getInstance().loadClass(lookAndFeelInfoArray[n].getClassName());
                    Object obj = clazz.newInstance();
                    Method method = clazz.getMethod("isSupportedLookAndFeel", null);
                    Object object = method.invoke(obj, null);
                    if (((Boolean)object).booleanValue()) {
                        linkedList.add(lookAndFeelInfoArray[n]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray2 = new UIManager.LookAndFeelInfo[linkedList.size()];
        System.arraycopy(linkedList.toArray(), 0, lookAndFeelInfoArray2, 0, lookAndFeelInfoArray2.length);
        return lookAndFeelInfoArray2;
    }

    public static void installLookAndFeels() {
        Object object;
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < EXTRA_LAFS.length) {
            ThemeManager.addLookAndFeel(hashtable, EXTRA_LAFS[n][1], EXTRA_LAFS[n][0]);
            ++n;
        }
        PluginInfo[] pluginInfoArray = JarClassLoader.getInstance().getPluginInfos();
        int n2 = 0;
        while (n2 < pluginInfoArray.length) {
            object = pluginInfoArray[n2].getName();
            String string = pluginInfoArray[n2].getClassName();
            if (object != null && string != null) {
                ThemeManager.addLookAndFeel(hashtable, string, (String)object);
            }
            ++n2;
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        if (lookAndFeelInfoArray != null) {
            int n3 = 0;
            while (n3 < lookAndFeelInfoArray.length) {
                hashtable.remove(lookAndFeelInfoArray[n3].getClassName());
                ++n3;
            }
        }
        object = hashtable.values().iterator();
        while (object.hasNext()) {
            UIManager.installLookAndFeel((UIManager.LookAndFeelInfo)object.next());
        }
    }

    public static void addLookAndFeel(Hashtable hashtable, String string, String string2) {
        try {
            Class<?> clazz = JarClassLoader.getInstance().loadClass(string);
            Object obj = clazz.newInstance();
            hashtable.put(string, new UIManager.LookAndFeelInfo(string2, string));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ThemeManager() {
    }
}

