/*
 * Decompiled with CFR 0.152.
 */
package xnap.cmdl;

import xnap.cmdl.AbstractCommand;
import xnap.cmdl.CommandLineSupport;
import xnap.cmdl.Console;
import xnap.cmdl.Executer;
import xnap.cmdl.ReadlineConsole;
import xnap.plugin.PluginManager;
import xnap.util.ISearchContainer;
import xnap.util.Preferences;
import xnap.util.SearchManager;
import xnap.util.SearchResultCollector;
import xnap.util.Updater;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CommandLine
implements CommandLineSupport,
ListListener {
    private static Console console = Console.getInstance();
    private static ReadlineConsole icRLC = new ReadlineConsole();
    private static Preferences prefs;
    private String[] args;
    private AbstractCommand[] commands;

    public void run() {
        this.init();
        boolean bl = true;
        while (bl) {
            String string = console.readln("XNap> ");
            bl = Executer.parseCommand(string);
        }
        this.exit();
    }

    public void init() {
        Executer.installHandler(this);
        String string = "XNap 2.5r3 (http://xnap.sourceforge.net).\n\nXNap comes with ABSOLUTELY NO WARRANTY; for details type 'readme'.\nThis is free software, and you are welcome to redistribute it\nunder certain conditions; type 'license' for details.\n\nReady (h for help, q to exit)\n";
        console.println(string);
        SearchManager.getInstance().addListListener(this);
        Updater.start();
        PluginManager.getInstance().enablePlugins(prefs.getEnabledPlugins());
    }

    public void elementAdded(ListEvent listEvent) {
        ISearchContainer iSearchContainer = (ISearchContainer)listEvent.getElement();
        SearchResultCollector searchResultCollector = new SearchResultCollector(iSearchContainer.getDefaultGrouper());
        iSearchContainer.setCollector(searchResultCollector);
        iSearchContainer.start();
    }

    public void elementRemoved(ListEvent listEvent) {
    }

    public void exit() {
        icRLC.saveSettings();
        prefs.setEnabledPlugins(PluginManager.getInstance().disablePlugins());
        prefs.write();
        System.exit(0);
    }

    public AbstractCommand[] getCommands() {
        return this.commands;
    }

    private final /* synthetic */ void this() {
        this.commands = new AbstractCommand[]{new ExitCmd()};
    }

    public CommandLine(String[] stringArray) {
        this.this();
        this.args = stringArray;
    }

    static {
        console.setConsole(icRLC);
        prefs = Preferences.getInstance();
    }

    protected class ExitCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            CommandLine.this.exit();
            return true;
        }

        public ExitCmd() {
            this.putValue("cmd", new String[]{"exit", "quit", "q"});
            this.putValue("shortHelp", "Exits the application.");
        }
    }
}

