/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.userprefs;

import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.l2fprod.common.swing.JButtonBar;
import com.l2fprod.common.swing.plaf.blue.BlueishButtonBarUI;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.dialogs.userprefs.AlertsTab;
import cz.vity.freerapid.gui.dialogs.userprefs.ConnectionsTab;
import cz.vity.freerapid.gui.dialogs.userprefs.GeneralTab;
import cz.vity.freerapid.gui.dialogs.userprefs.MiscTab;
import cz.vity.freerapid.gui.dialogs.userprefs.PluginsTab;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesTab;
import cz.vity.freerapid.gui.dialogs.userprefs.ViewsTab;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.swing.binding.MyPresentationModel;
import cz.vity.freerapid.swing.components.EnhancedToolbar;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;

public class UserPreferencesDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(UserPreferencesDialog.class.getName());
    private static final String CARD_PROPERTY = "card";
    private final ManagerDirector managerDirector;
    private final HashMap<Card, UserPreferencesTab> tabs = new LinkedHashMap<Card, UserPreferencesTab>();
    private MyPresentationModel model;
    private Trigger trigger;
    private boolean updateQueue = false;
    private JButton btnOK;
    private JButton btnCancel;
    private JPanel panelCard;
    private JButtonBar toolbar;

    public UserPreferencesDialog(Frame owner, ApplicationContext context) throws Exception {
        super(owner, true);
        this.setName("UserPreferencesDialog");
        this.managerDirector = ((MainApp)context.getApplication()).getManagerDirector();
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            this.doClose();
            throw e;
        }
    }

    @Override
    public String[] getList(String key, int valueCount) {
        return super.getList(key, valueCount);
    }

    @Override
    public ResourceMap getResourceMap() {
        return super.getResourceMap();
    }

    @Override
    public void registerKeyboardAction(javax.swing.Action action) {
        super.registerKeyboardAction(action);
    }

    MyPresentationModel getModel() {
        return this.model;
    }

    void setUpdateQueue() {
        this.updateQueue = true;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnCancel;
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnOK;
    }

    private void build() throws CloneNotSupportedException {
        Card card;
        this.inject();
        this.init();
        try {
            card = Card.valueOf(AppPrefs.getProperty("userSettingsSelectedCard", Card.CARD1.toString()));
        }
        catch (IllegalArgumentException e) {
            card = Card.CARD1;
        }
        this.showCard(card);
        this.pack();
        this.setResizable(true);
        UserPreferencesDialog.locateOnOpticalScreenCenter(this);
    }

    private void init() {
        this.toolbar.setUI(new BlueishButtonBarUI());
        ActionMap map = this.getActionMap();
        ButtonGroup group = new ButtonGroup();
        this.addButton(map.get("generalBtnAction"), Card.CARD1, group);
        this.addButton(map.get("connectionsBtnAction"), Card.CARD2, group);
        this.addButton(map.get("soundBtnAction"), Card.CARD3, group);
        this.addButton(map.get("viewsBtnAction"), Card.CARD4, group);
        this.addButton(map.get("pluginsBtnAction"), Card.CARD6, group);
        this.addButton(map.get("miscBtnAction"), Card.CARD5, group);
        this.trigger = new Trigger();
        this.model = new MyPresentationModel(null, (ValueModel)this.trigger);
        javax.swing.Action actionOK = map.get("okBtnAction");
        PropertyConnector connector = PropertyConnector.connect(this.model, "buffering", actionOK, "enabled");
        connector.updateProperty2();
        this.setAction(this.btnOK, "okBtnAction");
        this.setAction(this.btnCancel, "cancelBtnAction");
    }

    private void addButton(javax.swing.Action action, Card card, ButtonGroup group) {
        JToggleButton button = new JToggleButton(action);
        Dimension size = button.getPreferredSize();
        Dimension dim = new Dimension(83, size.height + 8);
        button.setFont(button.getFont().deriveFont(10.0f));
        button.setForeground(Color.BLACK);
        button.setMinimumSize(dim);
        button.setPreferredSize(dim);
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.setOpaque(false);
        this.toolbar.add(button);
        button.putClientProperty(CARD_PROPERTY, (Object)card);
        group.add(button);
    }

    void showCard(Card card) {
        String actionName;
        assert (card != null);
        UserPreferencesTab tab = this.tabs.get((Object)card);
        if (!tab.isInitialized()) {
            tab.init();
            tab.setInitialized(true);
        }
        CardLayout cardLayout = (CardLayout)this.panelCard.getLayout();
        cardLayout.show(this.panelCard, card.toString());
        AppPrefs.storeProperty("userSettingsSelectedCard", card.toString());
        switch (card) {
            case CARD1: {
                actionName = "generalBtnAction";
                break;
            }
            case CARD2: {
                actionName = "connectionsBtnAction";
                break;
            }
            case CARD3: {
                actionName = "soundBtnAction";
                break;
            }
            case CARD4: {
                actionName = "viewsBtnAction";
                break;
            }
            case CARD5: {
                actionName = "miscBtnAction";
                break;
            }
            case CARD6: {
                actionName = "pluginsBtnAction";
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        javax.swing.Action action = this.getActionMap().get(actionName);
        assert (action != null);
        action.putValue("SwingSelectedKey", Boolean.TRUE);
    }

    @Action
    public void okBtnAction() {
        if (!this.validated()) {
            return;
        }
        for (UserPreferencesTab tab : this.tabs.values()) {
            if (!tab.isInitialized()) continue;
            tab.apply();
        }
        this.trigger.triggerCommit();
        if (this.updateQueue) {
            this.managerDirector.getDataManager().getProcessManager().queueUpdated();
        }
        this.doClose();
    }

    private boolean validated() {
        for (UserPreferencesTab tab : this.tabs.values()) {
            if (!tab.isInitialized() || tab.validated()) continue;
            return false;
        }
        return true;
    }

    @Action
    public void cancelBtnAction() {
        for (UserPreferencesTab tab : this.tabs.values()) {
            if (!tab.isInitialized()) continue;
            tab.cancel();
        }
        this.doClose();
    }

    @Action
    public void generalBtnAction(ActionEvent e) {
        this.showCard(e);
    }

    @Action
    public void connectionsBtnAction(ActionEvent e) {
        this.showCard(e);
    }

    @Action
    public void soundBtnAction(ActionEvent e) {
        this.showCard(e);
    }

    @Action
    public void viewsBtnAction(ActionEvent e) {
        this.showCard(e);
    }

    @Action
    public void miscBtnAction(ActionEvent e) {
        this.showCard(e);
    }

    @Action
    public void pluginsBtnAction(ActionEvent e) {
        this.showCard(e);
    }

    private void showCard(ActionEvent e) {
        this.showCard((Card)((Object)((JComponent)e.getSource()).getClientProperty(CARD_PROPERTY)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClose() {
        logger.fine("Closing UserPreferencesDialog");
        try {
            if (this.model != null) {
                this.model.release();
            }
        }
        finally {
            super.doClose();
        }
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        this.btnOK = new JButton();
        this.btnOK.setName("btnOK");
        this.btnCancel = new JButton();
        this.btnCancel.setName("btnCancel");
        this.panelCard = new JPanel();
        this.toolbar = new EnhancedToolbar();
        JXButtonPanel buttonBar = new JXButtonPanel();
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setLayout(new BorderLayout());
        contentPanel.setLayout(new BorderLayout());
        buttonBar.setBorder(Borders.createEmptyBorder("5dlu, 4dlu, 4dlu, 4dlu"));
        buttonBar.setCyclic(true);
        PanelBuilder buttonBarBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormSpecs.GLUE_COLSPEC, ColumnSpec.decode("max(pref;42dlu)"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.PREF_COLSPEC}, RowSpec.decodeSpecs("pref")), buttonBar);
        ((FormLayout)buttonBar.getLayout()).setColumnGroups(new int[][]{{2, 4}});
        buttonBarBuilder.add((Component)this.btnOK, cc.xy(2, 1));
        buttonBarBuilder.add((Component)this.btnCancel, cc.xy(4, 1));
        contentPanel.add((Component)buttonBar, "South");
        GeneralTab generalTab = new GeneralTab(this);
        ConnectionsTab connectionsTab = new ConnectionsTab(this, this.managerDirector);
        AlertsTab alertsTab = new AlertsTab(this);
        ViewsTab viewsTab = new ViewsTab(this);
        PluginsTab pluginsTab = new PluginsTab(this, this.managerDirector);
        MiscTab miscTab = new MiscTab(this);
        this.tabs.put(Card.CARD1, generalTab);
        this.tabs.put(Card.CARD2, connectionsTab);
        this.tabs.put(Card.CARD3, alertsTab);
        this.tabs.put(Card.CARD4, viewsTab);
        this.tabs.put(Card.CARD6, pluginsTab);
        this.tabs.put(Card.CARD5, miscTab);
        for (UserPreferencesTab tab : this.tabs.values()) {
            tab.build(cc);
        }
        this.panelCard.setLayout(new CardLayout());
        this.panelCard.add((Component)generalTab, "CARD1");
        this.panelCard.add((Component)connectionsTab, "CARD2");
        this.panelCard.add((Component)alertsTab, "CARD3");
        this.panelCard.add((Component)viewsTab, "CARD4");
        this.panelCard.add((Component)pluginsTab, "CARD6");
        this.panelCard.add((Component)miscTab, "CARD5");
        contentPanel.add((Component)this.panelCard, "Center");
        dialogPane.add((Component)contentPanel, "Center");
        dialogPane.add((Component)this.toolbar, "North");
        contentPane.add((Component)dialogPane, "Center");
    }

    static enum Card {
        CARD1,
        CARD2,
        CARD3,
        CARD4,
        CARD5,
        CARD6;

    }
}

