/*
 * Decompiled with CFR 0.152.
 */
package com.be.swing.plaf.beos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BeOSButtonUI
extends BasicButtonUI {
    private static final BeOSButtonUI buttonUI = new BeOSButtonUI();
    private boolean defaultsInitialized;
    protected Color selectColor;
    protected Color selectTextColor;
    protected Color disabledTextColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return buttonUI;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaultsInitialized) {
            this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
            this.selectTextColor = UIManager.getColor(this.getPropertyPrefix() + "selectText");
            this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
            this.defaultsInitialized = true;
        }
        abstractButton.setOpaque(false);
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaultsInitialized = false;
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new BeOSButtonListener(abstractButton);
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getSelectTextColor() {
        return this.selectTextColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled()) {
            Dimension dimension = abstractButton.getSize();
            graphics.setColor(this.getSelectColor());
            if (((JButton)abstractButton).isDefaultCapable()) {
                graphics.fillRect(5, 5, dimension.width - 10, dimension.height - 10);
            } else {
                graphics.fillRect(1, 1, dimension.width - 1, dimension.height - 1);
            }
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = -1;
        if (buttonModel.isEnabled()) {
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                graphics.setColor(this.getSelectTextColor());
                BasicGraphicsUtils.drawString(graphics, string, -1, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(abstractButton.getForeground());
                BasicGraphicsUtils.drawString(graphics, string, -1, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
        } else {
            graphics.setColor(this.getDisabledTextColor());
            BasicGraphicsUtils.drawString(graphics, string, -1, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton.isContentAreaFilled()) {
            Dimension dimension = abstractButton.getSize();
            graphics.setColor(abstractButton.getBackground());
            if (((JButton)abstractButton).isDefaultCapable()) {
                graphics.fillRect(5, 5, dimension.width - 10, dimension.height - 10);
            } else {
                graphics.fillRect(1, 1, dimension.width - 1, dimension.height - 1);
            }
        }
        super.paint(graphics, jComponent);
    }

    class BeOSButtonListener
    extends BasicButtonListener {
        public void focusGained(FocusEvent focusEvent) {
            Component component = (Component)focusEvent.getSource();
            component.repaint();
        }

        public BeOSButtonListener(AbstractButton abstractButton) {
            super(abstractButton);
        }
    }
}

