/*
 ******************************************************************************
 ******************************************************************************
 *
 *  Licensed Materials - Property of IBM
 *
 *  IBM TCP/IP for DOS.
 *  Copyright (c) IBM Corp. 1992.  All rights reserved.
 *  US Government Users Restricted Rights - Use, duplication or
 *  disclosure restricted by GSA ADP Schedule contract with IBM Corp.
 *
 ******************************************************************************
 ******************************************************************************
 *
 *  $Author:   Terri_Waldron  $
 *  $Revision:   1.13  $
 *  $Modtime:   18 Jan 1993 14:21:14  $
 *
 *  $Header:   L:/INCLUDE/RSA/RPC/TYPES.H_V   1.13   18 Jan 1993 14:23:22   Terri_Waldron  $
 *
 *  $Log:   L:/INCLUDE/RSA/RPC/TYPES.H_V  $
 * 
 *    Rev 1.13   18 Jan 1993 14:23:22   Terri_Waldron
 * Fixed the include when doing windows programming.
 *
 *    Rev 1.12   17 Jan 1993 11:54:22   Bob_Pombrio
 * Chnaged the D16 memory stuff back to regular malloc's and free's.
 *
 *    Rev 1.9   05 Dec 1992 11:08:30   Bob_Pombrio
 * Fixed the memory allocation routines to use Rationals code.
 *
 *    Rev 1.8   05 Nov 1992 14:18:22   Bob_Pombrio
 * Fixed a mis-spelling on a define.
 *
 *    Rev 1.7   04 Nov 1992 16:17:48   Bob
 * Added the missing include to the KERNEL build stuff at the end of the file.
 *
 *    Rev 1.6   19 Oct 1992 15:09:12   R_Kania
 * Added the if block for building as the kernel.
 *
 *    Rev 1.5   15 Oct 1992 18:58:10   R_Kania
 *
 *
 *    Rev 1.4   15 Oct 1992 17:42:28   R_Kania
 * Fixed includes
 *
 *    Rev 1.3   15 Oct 1992 16:19:52   R_Kania
 * Fixed ifndef for conditional includes of TCPTYPES.H
 *
 *    Rev 1.2   15 Oct 1992 15:34:42   R_Kania
 * Corrected ifndef statements for conditional includes
 *
 *    Rev 1.1   13 Oct 1992 14:32:26   R_Kania
 * Microsoft C 7.00 changes
 *
 *    Rev 1.0   07 Oct 1992 12:10:18   RKania
 * Initial revision.
 *
 ******************************************************************************
 ******************************************************************************
 *
 * Copyright (c) 1990 by Sun Microsystems, Inc.
 *      @(#)types.h     1.20 88/02/08 SMI
 *      @(#)types.h     1.6  90/07/19 4.1NFSSRC SMI
 *
 ******************************************************************************
 ******************************************************************************
 */

/*
 ******************************************************************************
 * types.h
 * RPC additions to <sys/types.h>
 ******************************************************************************
 */
#ifndef __rpc_types_h
#define __rpc_types_h

#ifndef _WINSOCKAPI_
#ifndef _TCPTYPES_H_
#include <sys/tcptypes.h>
#endif

#include <sys/errno.h>
#include <sys/utils.h>
#include <malloc.h>
#include <sys/types.h>
#endif

/*
 ******************************************************************************
 * General boolean definitions
 ******************************************************************************
 */
#define bool_t short
#define enum_t                  short

#define __dontcare__            -1

#ifndef FALSE
#define FALSE                   (0)
#endif

#ifndef TRUE
#define TRUE                    (1)
#endif

#ifndef NULL
#define NULL                    0
#endif

/*
 ******************************************************************************
 * Memory allocation defines
 ******************************************************************************
 */
#define mem_alloc(bsize)        malloc(bsize)
#define mem_free(ptr, bsize)    free(ptr)

#endif
