/* [xalloc.c wk 6.10.88] new alloc functions
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * 11.9.91  wk	added getMoreMemHook
 * 15.02.93 wk	added xrealloc()
 * 03.03.93 wk	NULL-ptr check for xstrdup()
 * 25.02.94 wk	use of memdbg and this module is now detected
 */

#include <wk/tailor.h>
RCSID("$Id: xalloc.c,v 1.7 1995/03/08 16:59:11 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef MEM_DEBUG
    #undef MEM_DEBUG  /* not here ! */
#endif
#include <wk/lib.h>


int _wklib_memdbgcheck;

static void Init(void);
#define DoInit()   do { if( _wklib_memdbgcheck != 1 ) Init(); } while(0)

static void Init()
{
    if( _wklib_memdbgcheck )
        Bug("xalloc: memdbg or another memory module is linked in");
    _wklib_memdbgcheck = 1;
}




#ifdef DOCUMENTATION
@Summary xmalloc	   Extended malloc() function
 #include <wk/wklib.h>

 void *xmalloc( bytes );
 size_t     bytes ;	Anzahl der angeforderten Bytes
@Description
 Dies Funktion is identisch zu malloc(), berprft aber ob der Aufruf
 erfolgreich war und bricht andernfalls das Programm mit einer Standard
 Fehlermeldung und exit(4) ab.
 Ist die Variable: XAllocFailureHook ungleich NULLF, so wird diese zuerst
 aufgerufen um Speicher freizugeben, bevor die Funktion abbricht.
 Es wird dann solange weiterversucht wie diese Funktion True zurckgibt.
@Return Value
 Pointer to allocated memory
#endif

void *xmalloc( size_t size )
{
    void *p ;

    DoInit();
    while( !(p = malloc( size )) )
	if( !XAllocFailureHook )
	    Errorx(0) ;
	else if( !XAllocFailureHook( size ) )
	    Errorx(0);

    return p ;
}



#ifdef DOCUMENTATION
@Summary xcalloc	  Extended calloc() function

 #include <wk/wklib.h>

 void *xcalloc( bytes, size );
 size_t     bytes ;	Anzahl der angeforderten Elemente
 size_t     size ;	Gre eines Elements
@Description
 Dies Funktion is identisch zu calloc(), berprft aber ob der Aufruf
 erfolgreich war und bricht andernfalls das Programm mit einer Standard
 Fehlermeldung und exit(4) ab.

@Return Value
 Pointer to allocated memory
#endif



void *xcalloc( size_t anz, size_t size )
{
    void *p ;

    DoInit();
    while( !(p=calloc( anz, size ) ) )
	if( !XAllocFailureHook )
	    Errorx(0) ;
	else if( !XAllocFailureHook( anz*size ) )
	    Errorx(0);

    return p ;
}


#ifdef DOCUMENTATION
@Summary xrealloc	   reallocate buffer
 #include <wk/wklib.h>

 void *xrealloc( void *ptr, size_t size);
@Description
 Dies Funktion is identisch zu realloc(), berprft aber ob der Aufruf
 erfolgreich war und bricht andernfalls das Programm mit einer Standard
 Fehlermeldung und exit(4) ab.
@Return Value
 Pointer to allocated memory
#endif


void *xrealloc( void *ptr, size_t size )
{
    void *p ;

    DoInit();
    while( !(p=realloc( ptr, size ) ) )
	if( !XAllocFailureHook )
	    Errorx(0) ;
	else if( !XAllocFailureHook( size ) )
	    Errorx(0);

    return p ;
}





#ifdef DOCUMENTATION
@Summary xstrdup	   duplicate a string

 #include <wk/wklib.h>

 char *xstrdup( s );
 const char *s; 	String
@Description
 Like strdup() but a NOMEM-Check is done by a call to xmalloc().
@Return Value
 Pointer to new String (allocated by malloc)
#endif


char *xstrdup( const char *s )
{
    if( !s )
        Bug("xstrdup(NULL)");
    return strcpy( (char*)xmalloc( strlen(s)+1 ), s ) ;
}



/**** end of file ****/
