/* [time5.c wk 18.07.94] Str2JD
 *	Copyright (c) 1988-94 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <wk/tailor.h>
RCSID("$Id: time5.c,v 1.5 1996/01/25 20:16:50 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/lib.h>
#include <wk/string.h>


#ifdef DOCUMENTATION
@summary Str2JD 	   Scan a date string
 #include <wk/lib.h>

 int Str2JD( string, ret_jd, ret_n );
 const char *string; String mit Datum
 long  *ret_jd;      wenn != NULL: Julianische Periode
 size_t *ret_n;      wenn != NULL: Lnge des betrachteten Datum-Strings
@Description
 Wandelt einen String in ein Datum um, White-Spaces am Anfang
 werden bersprungen, das Datum wird im Format t.m.j erwartet, wobei das
 Jahr auch 2-stellig sein kann, in diesem Fall wird auf das Jahr 1900 addiert.
@Return Value
 Wert von CheckDate(); 0 ist ein gltiges Datum.
@See Also
 JD2Str
#endif


int
Str2JD( const char *string, long *ret_jd, size_t *ret_n )
{
    int d,m,y, i;
    unsigned n1, n2;

    if( ret_n )
	*ret_n = 0;
  #ifdef __ZTC__
    #define xcast   (char*)
  #else
    #define xcast
  #endif
    if( sscanf( xcast string, " %d.%d.%n%d%n", &d, &m, &n1, &y, &n2 ) != 3 )
	return 4;   /* format des Datums ist nicht erkennbar */
  #undef xcast
    if( ret_n )
	*ret_n = n2;
    if( n2-n1 == 2 )
	y += 1900;

    if( i = CheckDate( d, m, y ) )
	return i;
    if( ret_jd )
	*ret_jd = Date2JD( d, m, y );
    return 0;
}


/*** bottom of file ****/
