/* [time1.c wk 27.5.91] TimeOfDay()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 07.07.94 wk	added yieldFnc
 * 22.12.94 wk	added netware support
 * 08.03.95 wk	added Linux support
 */

#include <wk/tailor.h>
RCSID("$Id: time1.c,v 1.20 1996/12/03 18:16:59 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/lib.h>
#include <wk/environ.h>
#include <time.h>
#if OS2
  #define INCL_DOSPROCESS 1	/* for DosSleep() */
  #include <os2.h>
#elif NETWARE
  #include <process.h>
#elif (__ZTC__ || __MSC__ || __WATCOMC__)
  #include <dos.h>
  #include <bios.h>
#endif
#ifdef POSIX
  #include <time.h>
  #ifndef WINNT
  #include <sys/time.h>
  #endif
  #include <sys/types.h>
  #include <unistd.h>
  #if defined(UNIX) || defined(__VMS)
     #ifdef __VMS
       #include <sys/socket.h>
     #endif
     #define USE_SELECT_FOR_SLEEP 1
  #endif
#endif


static void (*yieldFnc)(void);


#ifdef DOCUMENTATION
@Summary TimeOfDay	  Get Time of day in Milliseconds
 #include <wk/lib.h>

 long TimeOfDay();
@Description
 Gibt die Tageszeit in Millisekunden seit Mitternacht zurck.
@Return Value
 Millisekunden seit Mitternacht
#endif

#if __MSC__
#pragma check_stack(off)
#endif

long TimeOfDay()
{
  #if __ZTC__ && !defined(OS2)
    struct dos_time_t t;

    dos_gettime( &t );
    return (3600L*t.hour + 60L*t.minute + t.second) * 1000L + t.hsecond*10;
  #elif (__MSC__ || __WATCOMC__) && !defined(OS2) && !defined(NETWARE) \
	&& !defined(WINNT)
    struct dostime_t t;

    _dos_gettime( &t );
    return (3600L*t.hour + 60L*t.minute + t.second) * 1000L + t.hsecond*10;

  #else /* use ANSI-conform method */
    struct tm *t;
    time_t ts ;

    time( &ts ) ;
    t = localtime( &ts ) ;
    return (3600L*t->tm_hour + 60L*t->tm_min + t->tm_sec) * 1000L ;
  #endif
}


#ifdef DOCUMENTATION
@Summary Sleep
 #include <wk/lib.h>

 void Sleep( long milliSeconds ); /* a macro */
 void wklib_sleep( long ms );

 milliseconds == 0 only gives up the timeslice (if possible)
@Notes
 This function does not wait for exact amount of time, if may sleep longer
 (depending on registered yield functions) or short (e.g. due to signal
  delivery)
 This function uses select() on most unix boxes.
#endif /*DOCUMENTATION*/


void
wklib_sleep( long mSeconds )
{
  #if USE_SELECT_FOR_SLEEP
    /* note we shoul mess around with the returned timeout,
     * but most systems dont reduce the value on an interrupt or so.
     * But as this is an inxeact funtion, we simmply assume
     * we slept the full amount. note sleeping is divided into 1 second
     * intervalls, so we can call out yieldfunction.
     */
    if( yieldFnc )
	yieldFnc();
    if( mSeconds > 0 ) {
	struct timeval tv;

	for( ; mSeconds >= 1000; mSeconds -= 1000 ) {
	    tv.tv_sec = 1;
	    tv.tv_usec = 0;
	    select(0,NULL,NULL,NULL, &tv);
	    if( yieldFnc )
		yieldFnc();
	}
	if( mSeconds > 0 ) {
	    tv.tv_sec = 0;
	    tv.tv_usec = mSeconds * 1000;
	    select(0,NULL,NULL,NULL, &tv);
	}
    }
  #elif OS2
    if( yieldFnc )
	yieldFnc();
    DosSleep( (ulong)mSeconds );
  #elif (__ZTC__ || __MSC__||__WATCOMC__) && !MSDOS_WINDOWS && !NETWARE \
	&& !WINNT
    union REGS inregs, outregs;
    struct SREGS segregs;
    clock_t endTime;

    if( yieldFnc )
	yieldFnc();
  #if __WATCOMC__ && defined(__386__)
    inregs.x.eax = 0x352f ; /* get interupt vector 0x2f */
    int386x( 0x21, &inregs, &outregs, &segregs ) ;
    if( segregs.es || outregs.x.ebx ) { /* 2f is installed */
  #else
    inregs.x.ax = 0x352f ; /* get interupt vector 0x2f */
    int86x( 0x21, &inregs, &outregs, &segregs ) ;
    if( segregs.es || outregs.x.bx ) { /* 2f is installed */
  #endif
	segregs.es = 1; /* remember this */
      #if __WATCOMC__ && defined(__386__)
	inregs.x.eax = 0x1680 ; /* give up timeslice */
	int386( 0x2f, &inregs, &outregs);
      #else
	inregs.x.ax = 0x1680 ; /* give up timeslice */
	int86( 0x2f, &inregs, &outregs);
      #endif
    }
    else
	segregs.es = 0;

  #if (__WATCOMC__ && (MSDOS || DOS386))
    /* the OS/2 DOS-Box does not work correctly with the above */
    /* "nice"-API, so we add an addional keyboard polling */
    /* and hope OS/2 will detect this */
    _bios_keybrd(_KEYBRD_READY);
  #endif

    if( mSeconds > 0 ) {
	endTime = clock() + mSeconds / (1000 / CLK_TCK);
	do {
	    if( yieldFnc )
		yieldFnc();
	    if( segregs.es ) {
	      #if __WATCOMC__ && defined(__386__)
		inregs.x.eax = 0x1680 ; /* give up timeslice */
		int386( 0x2f, &inregs, &outregs);
	      #else
		inregs.x.ax = 0x1680 ; /* give up timeslice */
		int86( 0x2f, &inregs, &outregs);
	      #endif
	    }
	} while(clock() < endTime);
    }

  #elif NETWARE
    clock_t endTime;

    if( yieldFnc )
	yieldFnc();
    if( mSeconds > 0 ) {
	endTime = clock() + mSeconds / (1000 / CLK_TCK);
	do {
	    ThreadSwitchWithDelay();
	    if( yieldFnc )
		yieldFnc();
	} while(clock() < endTime);
    }
    else
	ThreadSwitch();
  #else
    clock_t endTime;

    if( yieldFnc )
	yieldFnc();
    if( mSeconds > 0 ) {
	endTime = clock() + mSeconds / (1000 / CLK_TCK);
	do {
	    if( yieldFnc )
		yieldFnc();
	} while(clock() < endTime);
    }
  #endif
}


void Wklib_registerYield( int mode, void (*f)(void) )
{
    mode = 0;
    yieldFnc = f;
}

/*** bottom of file ****/
