/* [strg7.c wk 19.3.93] More compare functions
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: strg7.c,v 1.5 1995/03/08 16:58:12 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/string.h>


/****************
 * Like strcmp, but without trailing white spaces
 */

int StrCmpNTS( const char *a, const char *b )
{
    size_t na, nb;

    na = StrLenNTS(a);
    nb = StrLenNTS(b);
    if( na < nb )   /* das ist glaub ich nicht richtig, aber einfacher */
	return -1;
    if( na > nb )
	return 1;
    return memcmp( a, b, na );
}




/****************
 * Like strlen, but w/o trailing white spaces
 */

size_t StrLenNTS( const char *str )
{
    const char *p ;
    const char *mark ;
    size_t n;

    /* find last non space character */
    for( n=0,mark = NULL, p = str; *p; p++, n++ )
	if( isspace( *(const byte*)p ) ) {
	    if( !mark )
		mark = p ;
	}
	else
	    mark = NULL ;
    return mark ? mark - str : n;
}


/***** bottom of file ******/
