/* [strg5.c wk 6.6.91] InsertTabs()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 22.05.92 wk	Neue Funktion InsertTabs2()
 * 12.01.93 wk	Changed meaning of InsertTabs2()
 * 21.02.95 wk	InsertTabs2() now inserts Tabs up the the first
 *		String-Delimiter (so we can save a Makefile and
 *		leave at least one tab at the beginning of the line :-))
 */

#include <wk/tailor.h>
RCSID("$Id: strg5.c,v 1.6 1995/03/08 16:58:03 wk Exp $")
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <wk/string.h>


static size_t DoInsertTabs( char *p, size_t len , int special );


#ifdef DOCUMENTATION
@Summary InsertTabs	 Insert tab characters into a buffer
 #include <wk/strhilf.h>

 size_t InsertTabs( p, size );
 size_t InsertTabs2( p, size );
 char	*p ;	    Buffer
 size_t size;	    Size of buffer
@Description
 Diese Funktion komprimiert einen Buffer, indem nach DOS Konventionen Tabs
 eingebaut werden.  (Der Buffer mu die Zeile vom Anfang an beinhalten).
 InsertTabs2() ist eine besondere Version, die Tabs nur dann einfuegt, wenn
 in der Zeile kein String vorkommt; ein String wird am Vorhandensein
 eines einfachen oder doppelten Anfuehrungszeichen erkannt, vor diesen Zeichen
 werden Tabs allerdings doch eingefgt.
@Return Value
 Size of Buffer ( ist jetzt <= oldSize )
#endif

size_t
InsertTabs( char *p, size_t len )
{
    return DoInsertTabs(p,len,0);
}

size_t
InsertTabs2( char *p, size_t len )
{
    return DoInsertTabs(p,len,1);
}

static size_t
DoInsertTabs( char *p, size_t len , int special )
{
    register size_t i , pos ;
    size_t next_tab , n ;
    int shift , sum_shift ;

    sum_shift = n = 0 ;
    for( pos = 0; pos < len ; pos++, n++ )
        if( p[pos] == ' ' ) {
	    next_tab = (n&~7)+8 - sum_shift ;
	    for( i=pos ; i < next_tab && i < len ; i++ )
                if( p[i] != ' ' )
		    break ;
	    if( !(i < next_tab ) )
		if( (shift = next_tab - pos - 1) > 0 ) {
		    memmove( p+pos, p+pos+shift, len-pos-shift );
		    len -= shift ;
                    p[pos] = '\t' ;
		    n += shift ;
		    sum_shift += shift ;
		}
	}
        else if( special && (p[pos] == '\'' || p[pos] == '\"') )
	    break;
    return len;
}


/******** bottom of file ***********/
