/* [file8.c wk 29.3.89] CreatTmpFile()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 26.01.93 wk	C Set/2 support
 * 30.05.94 wk	Added RenameTmpFile
 */

#include <wk/tailor.h>
RCSID("$Id: file8.c,v 1.12 1996/04/18 14:32:16 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <wk/io.h>
#include <wk/lib.h>
#include <wk/file.h>
#if __STDC__ || defined(_WINDOWS)
  #include <time.h>  /* for clock */
#endif


#ifndef EACCES
  #define EACCES EACCESS
#endif

#ifndef ENOMEM
  #define ENOMEM  EOUTOFMEM
#endif

/****** local protos *******/
static int TmpName( char *name, char *buf, const char *suf );

/***** functions *******/


#ifdef DOCUMENTATION
@Summary CreateTmpFile	  Create temporary file
 #include <wk/file.h>

 char *CreateTmpFile( p );
 char *CreateTmpFile2( d, p );
 const char *d; 	directory for the tmpfile
 char	*p;		prefix of filename

@Description
 Erzeugt einen temporren filenamen, voll netzwerk fhig.
 Die Datei wird angelegt und wieder geschlossen.
 errno kann abgefragt werden. Ist als prefix NULL angegeben, so
 wird "$" als Prefix angenommen, es werden max. 4 Bytes des Prefixes
 benutzt.
@Return Value
 Pointer to name of file, name is hold in a buffer
 allocated by call to malloc() or NULL if not created.
#endif

char *CreateTmpFile( const char *prefix )
{
    return CreateTmpFile2( NULL, prefix );
}



/****************
 * Same as Create Tempfile, but Direct specifies the directory where
 * the file is to be created - if its NULL function is the same as
 * CreateTmpFile
 */

char *CreateTmpFile2( const char *direct, const char *prefix )
{
    return CreateTmpFile3( direct, prefix, NULL);
}

/****************
 * Same as CreateTmpFile2, but the suffix my be specified
 * (with dot)
 */
char *
CreateTmpFile3( const char *direct, const char *prefix, const char *suf )
{
    FILE *st ;
    char *name, *p=NULL; /* avoid compiler warning about uninitialized use */
    int n ;
    char ext[1+10+4+20+1];

  #if UNIX || POSIX
    if( !suf )
	sprintf(ext, ".%d.tmp", getpid());
    else
	sprintf(ext, "%.20s", suf);
  #else
    if( !suf )
	strcpy(ext, ".tmp");
    else
	sprintf(ext, "%.4s", suf);
  #endif

    if( !prefix )
	prefix = "$";

    if( !direct )
	if( !(p=getenv("TMP")) )
	    if( !(p=getenv("TEMP")) )
	      #if UNIX || POSIX
		p = "/tmp";
	      #else
		p = "." ;
	      #endif
    if( !(n = strlen(direct? direct:p)) )  {
	/* empty string, use current directory */
	if( direct )
	    direct = "." ;
	else
	    p = "." ;
	n = 1 ;
    }

    if( (name = malloc( n+1+(4+4)+ strlen(ext) +1 )) )
    {
	strcpy( name, direct? direct:p );
	if( name[n-1] != ':' && name[n-1] != '/' && name[n-1] != '\\' )
	    strcat( name, "/" );
	p = name + strlen(name) ;
	for( n=0; n < 4 && prefix[n] ; n++ )
	    *(p++) = prefix[n] ;
	for( ; n < 4 ; n++ )
	    *(p++) = '_' ;
	*p = '\0';
      #if !__STDC__ && !defined(_WINDOWS)
	FilenameCompr( name ) ;
      #endif
	p = name + strlen(name) ;

	/* starting at p, we can now append 4 characters + extension */
	n = 0 ;     /* max. # of tries */
	st = NULL;
	do {
	    if( TmpName( name, p, ext ) )  /* append variable part */
		n = 1000 ;	      /* tmpName couldn't create Name */
	    else
		st = fopen( name, "wb" );
	} while( !st && errno == EACCES && ++n < 30 ) ;

	if( st )
	    fclose(st) ;    /* okay: created */
	else {
	    FREE( name );   /* error creating tmpFile */
	    errno = ENOENT ;
	}
    }
    else
	errno = ENOMEM ;

    return name ;
}


#ifdef DOCUMENTATION
@Summary RenameTmpFile
 #include <wk/file.h>

 char *RenameTmpFile( const char *file, const char *target,
		      const char * prefix, const char * suffix );

@Description
 Do a secure rename of a file to another directory, the renamed file
 may change its name.
@Return Value
 Returns: NULL on error or malloced name of the new file
@See Also
@Notes
 Currently this funtion does not attempt to use the origianl name
 as the new name.
@Example
#endif /*DOCUMENTATION*/


char *RenameTmpFile( const char *filename, const char *target,
		     const char *prefix, const char *suffix )
{
    char *name , *p;
    int n, rc;
  #ifdef UNIX
    char *ext;

  #endif

    if( !prefix )
	prefix = "$";
    if( !suffix )
	suffix = ".tmp";

  #ifdef UNIX
    ext = xmalloc(1+10+1+strlen(suffix));
    sprintf(ext, ".%d%s", getpid(),suffix);
  #endif

    if( !target || !*target )  /* empty string, use current directory */
	target = "." ;
    n = strlen(target);

  #ifdef UNIX
    if( (name = malloc( n+1+(4+4)+1+strlen(ext)+1 )) )
  #else
    if( (name = malloc( n+1+(4+4)+1+strlen(suffix)+1 )) )
  #endif
    {
	strcpy( name, target );
	if( name[n-1] != ':' && name[n-1] != '/' && name[n-1] != '\\' )
	    strcat( name, "/" );
	p = name + strlen(name) ;
	for( n=0; n < 4 && prefix[n] ; n++ )
	    *(p++) = prefix[n] ;
	for( ; n < 4 ; n++ )
	    *(p++) = '_' ;
	*p = '\0';
      #if !__STDC__ && !defined(_WINDOWS)
	FilenameCompr( name ) ;
      #endif
	p = name + strlen(name) ;

	/* starting at p, we can now append 4 characters + extension */
	n = 0 ;     /* max. # of tries */
	rc = 0;
	do {
	    if( TmpName( name, p ,
			      #ifdef UNIX
				ext
			      #else
				suffix
			      #endif
		       ) )  /* append variable part */
		n = 1000 ;	      /* tmpName couldn't create Name */
	    else
		rc = rename( filename, name );
	} while( rc && errno == EACCES && ++n < 30 ) ;

	if( rc ) {
	    FREE( name );   /* error renaming tmpFile */
	    errno = EACCES ;
	}
    }
    else
	errno = ENOMEM ;

  #ifdef UNIX
    free(ext);
  #endif
    return name ;
}


/*
 * name is a string with a pathname where the extension and the last 4
 * bytes of the name are missing. buf points to the last character
 * of name + 1, this function will append an 4 Byte String to name
 * ( starting at buf ) and an extension
 * and then verify if this file name exists. this process is repeated
 * as often as needed.
 */

static int TmpName( char *name, char *buf, const char *suf )
{
    char valString[4+1] ;
    long theValue;
    int n;

    n = 0 ;
    do {
	if( ++n > 500 )
	    return -1 ; /* no file found after 500 tries */
      #if __STDC__ || defined(_WINDOWS)
	theValue = clock() ;
      #else
	theValue = TimeOfDay() ;
      #endif
	theValue ^= (long)rand() * 16;
	if( theValue < 0 )
	    theValue = -theValue;
	theValue %= 1679616L ; /* take remainder, so value will be less */
			       /* than max. Value with 4-Digits based 36 */
	ltoa( theValue , valString, 36 );
	strcpy( buf, valString );
	strcat( buf, suf );
    } while( !access( name, 0 ) );

    return 0;
}

/******* bottom of file *******/
