/* [file2.c wk 1.3.90] efopen() : fopen with EnvSearch
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /vol1/src/master/libs/wklib/file2.c,v 1.9 1996/01/10 19:05:56 wernerk Exp $
 */

#include <wk/tailor.h>
RCSID("$Id: file2.c,v 1.9 1996/01/10 19:05:56 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/file.h>
#include <wk/string.h>
#include <wk/environ.h>


#ifdef DOCUMENTATION
@Summary efopen 	  Open a stream
 #include <wk/file.h>

 FILE *efopen( env, path, type );
 char *efopen2( env, path, type retfp);
 const char *env ;	Environment string
 const char *path;	Dateiname
 const char *type;	Openflags
@Description
 Wie fopen(), aber die Datei wird auch in den unter env angegebenen
 Directories gesucht, ist env == NULL, so identisch zu fopen,
 ist *env='\0', so wird PATH angenommen,
 beginnt env mit einem '=', so ist der darauffolgende String direkt die
 pfadangabe.
@Return Value
 efopen: A pointer to the open file.
 efopne2: A malloced string with the real pathname or NULL on open failure.
@See Also
 fopen
#endif


FILE *
efopen( const char *env, const char *name, const char *type )
{
    FILE *fp;
    char *p;

    if( p = efopen2( env, name, type, &fp ) ) {
	free(p);
	return fp;
    }
    return NULL;
}


char *
efopen2( const char *env, const char *name, const char *type, FILE **retfp )
{
    char *path ;

    path = xmalloc(F_MAX_PATH) ;
    if( env ) {
	if( *env )
	    SearchEnv( name, env, path ) ;
	else
	    SearchEnv( name, "PATH", path ) ;
    }
    else
	mem2str( path, name, F_MAX_PATH ) ;

    if( *retfp = fopen(path,type) )
	return path;
    free(path) ;
    return NULL;
}



/*** bottom of file ***/
