/* [file14.c wk 25.10.94] File Locks
 *	Copyright (c) 1988-94 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */


#include <wk/tailor.h>
RCSID("$Id: file14.c,v 1.1 1996/12/06 22:16:06 wk Exp $")
#include <stdio.h>
#include <wk/file.h>
#include <wk/io.h>

#ifdef OS20
int _System DosForceDelete( const char *s );
#endif


#ifdef DOCUMENTATION
@Summary FileLock FileUnlock
 #include <wk/file.h>

 int FileLock( handle, reserved, offset, nbytes, timeout )
 int FileUnlock( handle, offset, nbytes )
 int handle;	    system file handle (from sopen)
 int reserved;	    should be zero
 ulong offset;	    offset, where to lock
 ulong nbytes;	    length of area to lock
 long timeout;	    timeout value in milliseconds (-1 := no timeout)

@Description
 Wrapper for the usual filelock functions.
 You may lock any range , this includes offsets behind the end of the file.
 It is not defined wether this is a advisory lock or a physical lock,
 processes locking files should agree to use only these lock functions.
 It ist not defined wether errno is changed or not.
@Return Value
 0 for success
 or an errno value (EACCES if the lock is not available)
@See Also
 sopen close
#endif /*DOCUMENTATION*/


int
FileLock( int handle, int reserved, ulong offset, ulong nbytes, long timeout)
{
  #if OS20  /* (watcom version seems to be broken) */
  #elif __WATCOMC__ /* all other dos versions */
  #endif
}

int
FileUnlock( int handle, ulong offset, ulong nbytes )
{
}


/*** bottom of file ***/
