/* [file11.c wk 22.12.91] Filesystem
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <wk/tailor.h>
RCSID("$Id: file11.c,v 1.14 1996/12/03 18:16:59 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/io.h>
#include <wk/file.h>
#include <wk/string.h>
#if EMX
    #include <os2.h>
#elif OS2
    #include <os2def.h>
    #define INCL_DOSFILEMGR
    #include <bsedos.h>
#endif


#ifdef __GNUC__
ulong DosQueryCurrentDir()  asm("DosQueryCurrentDir");
ulong DosQueryCurrentDisk() asm("DosQueryCurrentDisk");
#ifndef DosQCurDisk
  #define DosQCurDisk	  DosQueryCurrentDisk
#endif
#endif


int FileCmpName( const char *a, const char *b )
{
  #if UNIX || M_UNIX || M_XENIX || POSIX
    /* fixme: does POSIX say anything about casesensitivity in filenames
     * E.g. OpenVMS *is* case-in-sensitive!
     */
    return strcmp( a, b );
  #else
    return stricmp( a, b );
  #endif
}


#ifdef DOCUMENTATION
@Summary FileUnifyName
 #include <wk/file.h>

 char *FileUnifyName( char *name )
@Description
 Converts the filename to a unique form, so that the name is suitable
 for a hashed table.
@Return Value
 name
#endif /*DOCUMENTATION*/

char *FileUnifyName( char *name )
{
  #if UNIX || M_UNIX || M_XENIX || POSIX
    return name;
  #else
    return strlwr( name );
  #endif
}


#ifdef DOCUMENTATION
@Summary FileQryFS
 #include <wk/file.h>

 int FileQryFS( const char *fname );
@Description
 This function will return the type of filesystem where the given file is
 stored. At least a drive letter is required for this function.
@Return Value
 Returns: 0 = Error getting information
	  F_FS_FAT   = MSDOS FAT Filesystem
	  F_FS_VFAT  = MSDOS VFAT Filesystem
	  F_FS_HPFS  = OS/2 High Performance Filesystem
	  F_FS_UNIX  = Generic UNIX Filesystem
#endif /*DOCUMENTATION*/


int FileQryFS( const char *fname )
{
  #if MSDOS || DOS16RM || DOS386
    return F_FS_FAT;	/* the only supported one (DOS-BOX emulates it)*/
  #elif UNIX || M_UNIX || M_XENIX || POSIX
    return F_FS_UNIX;
  #elif NETWARE
    return F_FS_FAT;	/* fixme: take the Netware Namespaces in account */
  #elif WINNT
    return F_FS_VFAT;  /* FIXME: is there a qryFS() API? */
  #else /* OS2 or EMX */
    char drv[2+1];
    char *buf, *p;
   #if OS20 || EMX
    ulong  cb;
   #else
    ushort cb;
   #endif
    int type;

    #if EMX
	if( _osmode == DOS_MODE )
	    return F_FS_FAT;
    #endif

    mem2str( drv, fname, DIM(drv) );
    /* we need the drive name and nothing else
     * There is a serious bug in OS/2 (at least v2.1):
     * if you specify something like "." the system will hang
     * and you have to push the reset-button or (power-off, power-on on
     * some of the, so called, famous machines from the company with the
     * three letters or the one statring with COM ...)
     * (don't known wether we can blame it on Billys firm)
     */
    if( !(isalpha(*drv) && drv[1]==':') ) {
      #if OS20
	ulong drive;
      #else
	ushort drive;
      #endif
	ulong drivemap;

	if( drv[1] == ':' )
	    return 0;  /* not properly formed */
	if( DosQCurDisk(&drive, &drivemap) )
	    return 0; /* System call failed */
	drv[0] = 'a'+ drive - 1;
	drv[1] = ':';
	drv[2] = 0;
    }

    cb = 200;
    buf = xmalloc(cb);
    type = 0;

  #if OS20 || EMX
    if( !DosQueryFSAttach( (PSZ)drv, 0, 1, (PFSQBUFFER2)buf, &cb ) ) {
	for(p=buf+8; *p; p++ )
	    ;
	p++;
  #else /*}*/
    if( !DosQFSAttach( (PSZ)drv, 0, FSAIL_QUERYNAME, (PBYTE)buf, &cb, 0) ) {
	for(p=buf+4; *p; p++ )
	    ;
	p += 1+2;
  #endif
	if( !strcmp( p, "FAT" ) )
	    type = F_FS_FAT;
	else if( !strcmp( p, "HPFS" ) )
	    type = F_FS_HPFS;
    }

    free( buf );
    return type;
  #endif
}

/******* bottom of file *******/
