/* [codepg.c wk 11.12.90] CodePage releated functionss
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 *  6.06.92 wk	added paramter mode to Map functions
 *  2.01.93 wk	EMX Support added
 * 26.01.93 wk	C Set/2 Support added
 */


#include <wk/tailor.h>
RCSID("$Id: codepg.c,v 1.9 1996/12/03 18:16:56 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if MSDOS || DOS386 || EMX || DOS16RM
#include <dos.h>
#endif
#include <errno.h>
#include <wk/environ.h>
#if EMX
  #include <os2.h>
#elif OS2
  #define INCL_DOSNLS
  #include <os2.h>
#endif

/***** protoytpes ****/
/**** functions *****/

#ifdef DOCUMENTATION
@Summary QryActiveCodePage
 #include <wk/environ.h>

 int QryActiveCodePage(void);

@Description
 This functions retrieves the currently active codepage.
@Return Value
 A Number e.g.: 437, 850 .. or -1 if no codepage support available
@See Also
 SetActiveCodePage
#endif /*DOCUMENTATION*/

int QryActiveCodePage(void)
{
  #if NETWARE
    return -1;
  #elif WINNT
    return -1;
  #elif EMX || OS20
    ulong cp, len;

  #if EMX
    if( _osmode == DOS_MODE )
	return -1;
  #endif

    if( DosQueryCp( sizeof cp, &cp, &len ) )
	return -1;   /* error getting CP */
    return cp;

  #elif OS2
    ushort cp, len;

    if( DosGetCp( sizeof cp, &cp, &len ) )
	return -1;   /* error getting CP */
    return cp;

  #elif UNIX || POSIX
    return -1;
  #else
    union REGS inregs, outregs ;

  #if __WATCOMC__ && defined(__386__)
    inregs.x.eax = 0x6601 ; /* get active codepage */
    int386( 0x21, &inregs, &outregs ) ;
    if( outregs.x.cflag )
	return -1;   /* error getting CP */
    return outregs.x.ebx;
  #else
    inregs.x.ax = 0x6601 ; /* get active codepage */
    int86( 0x21, &inregs, &outregs ) ;
    if( outregs.x.cflag )
	return -1;   /* error getting CP */
    /* dx will contain the resident CP - I don't need this */
    return outregs.x.bx;
  #endif
  #endif
}


#ifdef DOCUMENTATION
@Summary SetActiveCodePage
 #include <wk/environ.h>

 int SetActiveCodePage( int cp );

@Description
 This functions make cp the active one. If it fails, errno will be set.
@Return Value
 0 = success or errno
@See Also
 QryActiveCodePage
#endif /*DOCUMENTATION*/

int SetActiveCodePage( int cp )
{
  #if NETWARE
    return errno = -1;
  #elif WINNT
    return errno = -1;
  #elif EMX || OS20
    if( cp < 0 )
	return 0; /* invalid value, do nothing may come from GetCp Error*/
  #if EMX
    if( _osmode == DOS_MODE )
	return errno = -1;
  #endif

    if( DosSetProcessCp( (ulong)cp ) )
	return errno = -1;   /* error setting CP */
    return 0;

  #elif OS2
    if( cp < 0 )
	return 0; /* invalid value, do nothing may come from GetCp Error*/
    if( DosSetCp( (ushort)cp, 0 ) )
	return errno = -1;   /* error setting CP */
    return 0;

  #elif UNIX || POSIX
    return -1;
  #else
    union REGS inregs, outregs ;

    if( cp < 0 )
	return 0; /* invalid value, do nothing may come from GetCp Error*/
  #if __WATCOMC__ && defined(__386__)
    inregs.x.eax = 0x6602 ; /* set active codepage */
    inregs.x.ebx = cp;
    int386( 0x21, &inregs, &outregs ) ;
    if( outregs.x.cflag ) {
	if( outregs.x.eax == 1 )
	    errno = EINVAL; /* invalid function */
	else if( outregs.x.eax == 2 )
	    errno = ENOENT; /* country.sys not found */
	else if( outregs.x.eax == 4 )
	    errno = EACCES; /* no access to devive */
	else
	    errno = -1;
	return errno ;	 /* error setting CP */
    }
  #else
    inregs.x.ax = 0x6602 ; /* set active codepage */
    inregs.x.bx = cp;
    int86( 0x21, &inregs, &outregs ) ;
    if( outregs.x.cflag ) {
	if( outregs.x.ax == 1 )
	    errno = EINVAL; /* invalid function */
	else if( outregs.x.ax == 2 )
	    errno = ENOENT; /* country.sys not found */
	else if( outregs.x.ax == 4 )
	    errno = EACCES; /* no access to devive */
	else
	    errno = -1;
	return errno ;	 /* error setting CP */
    }
  #endif
    /* do a second check, there is some trouble with the cflag value */
    if( cp != QryActiveCodePage() )
	return errno = -1;
    return 0;
  #endif
}



/* translate ISO 8859-1 to CodePage 850 */
/*  mode = 1 : use wk translation of control characters */

byte MapIso2Ibm( byte c, int mode )
{
    switch( c ) {
	/* the standard (ISO-8859-1 to IBM-CP-850) */
      case 0xa0: c = (byte)'\xff' ; break;  /* nobreakspace */
      case 0xa1: c = (byte)'\xad' ; break;  /* exclamdown */
      case 0xa2: c = (byte)'\xbd' ; break;  /* cent */
      case 0xa3: c = (byte)'\x9c' ; break;  /* sterling */
      case 0xa4: c = (byte)'\xcf' ; break;  /* currency */
      case 0xa5: c = (byte)'\xbe' ; break;  /* yen */
      case 0xa6: c = (byte)'\xdd' ; break;  /* brokenbar */
      case 0xa7: c = (byte)'\xf5' ; break;  /* section */
      case 0xa8: c = (byte)'\xf9' ; break;  /* diaeresis */
      case 0xa9: c = (byte)'\xb8' ; break;  /* copyright */
      case 0xaa: c = (byte)'\xa6' ; break;  /* ordfeminine */
      case 0xab: c = (byte)'\xae' ; break;  /* guillemotleft */
      case 0xac: c = (byte)'\xaa' ; break;  /* notsign */
      case 0xad: c = (byte)'\xf0' ; break;  /* hyphen */
      case 0xae: c = (byte)'\xa9' ; break;  /* registered */
      case 0xaf: c = (byte)'\xee' ; break;  /* macron */
      case 0xb0: c = (byte)'\xf8' ; break;  /* degree */
      case 0xb1: c = (byte)'\xf1' ; break;  /* plusminus */
      case 0xb2: c = (byte)'\xfd' ; break;  /* twosuperior */
      case 0xb3: c = (byte)'\xfc' ; break;  /* threesuperior */
      case 0xb4: c = (byte)'\xef' ; break;  /* acute */
      case 0xb5: c = (byte)'\xe6' ; break;  /* mu */
      case 0xb6: c = (byte)'\xf4' ; break;  /* paragraph */
      case 0xb7: c = (byte)'\xfa' ; break;  /* periodcentered */
      case 0xb8: c = (byte)'\xf7' ; break;  /* cedilla */
      case 0xb9: c = (byte)'\xfb' ; break;  /* onesuperior */
      case 0xba: c = (byte)'\xa7' ; break;  /* masculine */
      case 0xbb: c = (byte)'\xaf' ; break;  /* guillemotright */
      case 0xbc: c = (byte)'\xac' ; break;  /* onequarter */
      case 0xbd: c = (byte)'\xab' ; break;  /* onehalf */
      case 0xbe: c = (byte)'\xf3' ; break;  /* threequarters */
      case 0xbf: c = (byte)'\xa8' ; break;  /* questiondown */
      case 0xc0: c = (byte)'\xb7' ; break;  /* Agrave */
      case 0xc1: c = (byte)'\xb5' ; break;  /* Aacute */
      case 0xc2: c = (byte)'\xb6' ; break;  /* Acircumflex */
      case 0xc3: c = (byte)'\xc7' ; break;  /* Atilde */
      case 0xc4: c = (byte)'\x8e' ; break;  /* Adiaeresis */
      case 0xc5: c = (byte)'\x8f' ; break;  /* Aring */
      case 0xc6: c = (byte)'\x92' ; break;  /* AE */
      case 0xc7: c = (byte)'\x80' ; break;  /* Ccedilla */
      case 0xc8: c = (byte)'\xd4' ; break;  /* Egrave */
      case 0xc9: c = (byte)'\x90' ; break;  /* Eacute */
      case 0xca: c = (byte)'\xd2' ; break;  /* Ecircumflex */
      case 0xcb: c = (byte)'\xd3' ; break;  /* Ediaeresis */
      case 0xcc: c = (byte)'\xde' ; break;  /* Igrave */
      case 0xcd: c = (byte)'\xd6' ; break;  /* Iacute */
      case 0xce: c = (byte)'\xd7' ; break;  /* Icircumflex */
      case 0xcf: c = (byte)'\xd8' ; break;  /* Idiaeresis */
      case 0xd0: c = (byte)'\xd1' ; break;  /* Eth */
      case 0xd1: c = (byte)'\xa5' ; break;  /* Ntilde */
      case 0xd2: c = (byte)'\xe3' ; break;  /* Ograve */
      case 0xd3: c = (byte)'\xe0' ; break;  /* Oacute */
      case 0xd4: c = (byte)'\xe2' ; break;  /* Ocircumflex */
      case 0xd5: c = (byte)'\xe5' ; break;  /* Otilde */
      case 0xd6: c = (byte)'\x99' ; break;  /* Odiaeresis */
      case 0xd7: c = (byte)'\x9e' ; break;  /* multiply */
      case 0xd8: c = (byte)'\x9d' ; break;  /* Ooblique */
      case 0xd9: c = (byte)'\xeb' ; break;  /* Ugrave */
      case 0xda: c = (byte)'\xe9' ; break;  /* Uacute */
      case 0xdb: c = (byte)'\xea' ; break;  /* Ucircumflex */
      case 0xdc: c = (byte)'\x9a' ; break;  /* Udiaeresis */
      case 0xdd: c = (byte)'\xed' ; break;  /* Yacute */
      case 0xde: c = (byte)'\xe8' ; break;  /* Thorn */
      case 0xdf: c = (byte)'\xe1' ; break;  /* ssharp */
      case 0xe0: c = (byte)'\x85' ; break;  /* agrave */
      case 0xe1: c = (byte)'\xa0' ; break;  /* aacute */
      case 0xe2: c = (byte)'\x83' ; break;  /* acircumflex */
      case 0xe3: c = (byte)'\xc6' ; break;  /* atilde */
      case 0xe4: c = (byte)'\x84' ; break;  /* adiaeresis */
      case 0xe5: c = (byte)'\x86' ; break;  /* aring */
      case 0xe6: c = (byte)'\x91' ; break;  /* ae */
      case 0xe7: c = (byte)'\x87' ; break;  /* ccedilla */
      case 0xe8: c = (byte)'\x8a' ; break;  /* egrave */
      case 0xe9: c = (byte)'\x82' ; break;  /* eacute */
      case 0xea: c = (byte)'\x88' ; break;  /* ecircumflex */
      case 0xeb: c = (byte)'\x89' ; break;  /* ediaeresis */
      case 0xec: c = (byte)'\x8d' ; break;  /* igrave */
      case 0xed: c = (byte)'\xa1' ; break;  /* iacute */
      case 0xee: c = (byte)'\x8c' ; break;  /* icircumflex */
      case 0xef: c = (byte)'\x8b' ; break;  /* idiaeresis */
      case 0xf0: c = (byte)'\xd0' ; break;  /* eth */
      case 0xf1: c = (byte)'\xa4' ; break;  /* ntilde */
      case 0xf2: c = (byte)'\x95' ; break;  /* ograve */
      case 0xf3: c = (byte)'\xa2' ; break;  /* oacute */
      case 0xf4: c = (byte)'\x93' ; break;  /* ocircumflex */
      case 0xf5: c = (byte)'\xe4' ; break;  /* otilde */
      case 0xf6: c = (byte)'\x94' ; break;  /* odiaeresis */
      case 0xf7: c = (byte)'\xf6' ; break;  /* division */
      case 0xf8: c = (byte)'\x9b' ; break;  /* oslash */
      case 0xf9: c = (byte)'\x97' ; break;  /* ugrave */
      case 0xfa: c = (byte)'\xa3' ; break;  /* uacute */
      case 0xfb: c = (byte)'\x96' ; break;  /* ucircumflex */
      case 0xfc: c = (byte)'\x81' ; break;  /* udiaeresis */
      case 0xfd: c = (byte)'\xec' ; break;  /* yacute */
      case 0xfe: c = (byte)'\xe7' ; break;  /* thorn */
      case 0xff: c = (byte)'\x98' ; break;  /* ydiaeresis */

      default  :
	if( mode ) switch(c) { /* my own mappings */
	  case 0x80: c = (byte)'\xb0' ; break;  /* lightblock */
	  case 0x81: c = (byte)'\xb1' ; break;  /* mediumblock */
	  case 0x82: c = (byte)'\xb2' ; break;  /* denseblock */
	  case 0x83: c = (byte)'\xdb' ; break;  /* fullblock */
	  case 0x84: c = (byte)'\xdc' ; break;  /* upperhalfblock */
	  case 0x85: c = (byte)'\xdf' ; break;  /* lowerhalfblock */
	  case 0x86: c = (byte)'\xfe' ; break;  /* centeredblock */
	  case 0x87: c = (byte)'\xda' ; break;  /* upperleftangle */
	  case 0x88: c = (byte)'\xc2' ; break;  /* uppertee */
	  case 0x89: c = (byte)'\xbf' ; break;  /* upperrightangle */
	  case 0x8a: c = (byte)'\xc3' ; break;  /* lefttee */
	  case 0x8b: c = (byte)'\xc5' ; break;  /* middlecross */
	  case 0x8c: c = (byte)'\xb4' ; break;  /* righttee */
	  case 0x8d: c = (byte)'\xc0' ; break;  /* lowerleftangle */
	  case 0x8e: c = (byte)'\xc1' ; break;  /* lowertee */
	  case 0x8f: c = (byte)'\xd9' ; break;  /* lowerrightangle */
	  case 0x90: c = (byte)'\xc4' ; break;  /* horicontalline */
	  case 0x91: c = (byte)'\xb3' ; break;  /* verticalline */
	  case 0x92: c = (byte)'\xc9' ; break;  /* dblupperleftangle */
	  case 0x93: c = (byte)'\xcb' ; break;  /* dbluppertee */
	  case 0x94: c = (byte)'\xbb' ; break;  /* dblupperrightangle */
	  case 0x95: c = (byte)'\xcc' ; break;  /* dbllefttee */
	  case 0x96: c = (byte)'\xce' ; break;  /* dblmiddlecross */
	  case 0x97: c = (byte)'\xb9' ; break;  /* dblrighttee */
	  case 0x98: c = (byte)'\xc8' ; break;  /* dbllowerleftangle */
	  case 0x99: c = (byte)'\xca' ; break;  /* dbllowertee */
	  case 0x9a: c = (byte)'\xbc' ; break;  /* dbllowerrightangle */
	  case 0x9b: c = (byte)'\xcd' ; break;  /* dblhoricontalline */
	  case 0x9c: c = (byte)'\xba' ; break;  /* dblverticalline */
	  case 0x9d: c = (byte)'\xf2' ; break;  /* alternateequalsign */
	  case 0x9e: c = (byte)'\xd5' ; break;  /* alternateonesuperior */
	  case 0x9f: c = (byte)'\x9f' ; break;  /* integral */
	  default: break;
	}
	break;
    }
    return c;
}


/* translate CodePage 850 to ISO 8859-1 */
/*  mode = 1 : use wk translation of control characters */

byte MapIbm2Iso( byte c, int mode )
{
    switch( c ) {
	/* the standard (IBM-CP-850 to ISO-8859-1) */
      case 0x80: c = (byte)'\xc7' ; break;  /* Ccedilla */
      case 0x81: c = (byte)'\xfc' ; break;  /* udiaeresis */
      case 0x82: c = (byte)'\xe9' ; break;  /* eacute */
      case 0x83: c = (byte)'\xe2' ; break;  /* acircumflex */
      case 0x84: c = (byte)'\xe4' ; break;  /* adiaeresis */
      case 0x85: c = (byte)'\xe0' ; break;  /* agrave */
      case 0x86: c = (byte)'\xe5' ; break;  /* aring */
      case 0x87: c = (byte)'\xe7' ; break;  /* ccedilla */
      case 0x88: c = (byte)'\xea' ; break;  /* ecircumflex */
      case 0x89: c = (byte)'\xeb' ; break;  /* ediaeresis */
      case 0x8a: c = (byte)'\xe8' ; break;  /* egrave */
      case 0x8b: c = (byte)'\xef' ; break;  /* idiaeresis */
      case 0x8c: c = (byte)'\xee' ; break;  /* icircumflex */
      case 0x8d: c = (byte)'\xec' ; break;  /* igrave */
      case 0x8e: c = (byte)'\xc4' ; break;  /* Adiaeresis */
      case 0x8f: c = (byte)'\xc5' ; break;  /* Aring */
      case 0x90: c = (byte)'\xc9' ; break;  /* Eacute */
      case 0x91: c = (byte)'\xe6' ; break;  /* ae */
      case 0x92: c = (byte)'\xc6' ; break;  /* AE */
      case 0x93: c = (byte)'\xf4' ; break;  /* ocircumflex */
      case 0x94: c = (byte)'\xf6' ; break;  /* odiaeresis */
      case 0x95: c = (byte)'\xf2' ; break;  /* ograve */
      case 0x96: c = (byte)'\xfb' ; break;  /* ucircumflex */
      case 0x97: c = (byte)'\xf9' ; break;  /* ugrave */
      case 0x98: c = (byte)'\xff' ; break;  /* ydiaeresis */
      case 0x99: c = (byte)'\xd6' ; break;  /* Odiaeresis */
      case 0x9a: c = (byte)'\xdc' ; break;  /* Udiaeresis */
      case 0x9b: c = (byte)'\xf8' ; break;  /* oslash */
      case 0x9c: c = (byte)'\xa3' ; break;  /* sterling */
      case 0x9d: c = (byte)'\xd8' ; break;  /* Ooblique */
      case 0x9e: c = (byte)'\xd7' ; break;  /* multiply */
      case 0xa0: c = (byte)'\xe1' ; break;  /* aacute */
      case 0xa1: c = (byte)'\xed' ; break;  /* iacute */
      case 0xa2: c = (byte)'\xf3' ; break;  /* oacute */
      case 0xa3: c = (byte)'\xfa' ; break;  /* uacute */
      case 0xa4: c = (byte)'\xf1' ; break;  /* ntilde */
      case 0xa5: c = (byte)'\xd1' ; break;  /* Ntilde */
      case 0xa6: c = (byte)'\xaa' ; break;  /* ordfeminine */
      case 0xa7: c = (byte)'\xba' ; break;  /* masculine */
      case 0xa8: c = (byte)'\xbf' ; break;  /* questiondown */
      case 0xa9: c = (byte)'\xae' ; break;  /* registered */
      case 0xaa: c = (byte)'\xac' ; break;  /* notsign */
      case 0xab: c = (byte)'\xbd' ; break;  /* onehalf */
      case 0xac: c = (byte)'\xbc' ; break;  /* onequarter */
      case 0xad: c = (byte)'\xa1' ; break;  /* exclamdown */
      case 0xae: c = (byte)'\xab' ; break;  /* guillemotleft */
      case 0xaf: c = (byte)'\xbb' ; break;  /* guillemotright */
      case 0xb5: c = (byte)'\xc1' ; break;  /* Aacute */
      case 0xb6: c = (byte)'\xc2' ; break;  /* Acircumflex */
      case 0xb7: c = (byte)'\xc0' ; break;  /* Agrave */
      case 0xb8: c = (byte)'\xa9' ; break;  /* copyright */
      case 0xbd: c = (byte)'\xa2' ; break;  /* cent */
      case 0xbe: c = (byte)'\xa5' ; break;  /* yen */
      case 0xc6: c = (byte)'\xe3' ; break;  /* atilde */
      case 0xc7: c = (byte)'\xc3' ; break;  /* Atilde */
      case 0xcf: c = (byte)'\xa4' ; break;  /* currency */
      case 0xd0: c = (byte)'\xf0' ; break;  /* eth */
      case 0xd1: c = (byte)'\xd0' ; break;  /* Eth */
      case 0xd2: c = (byte)'\xca' ; break;  /* Ecircumflex */
      case 0xd3: c = (byte)'\xcb' ; break;  /* Ediaeresis */
      case 0xd4: c = (byte)'\xc8' ; break;  /* Egrave */
      case 0xd6: c = (byte)'\xcd' ; break;  /* Iacute */
      case 0xd7: c = (byte)'\xce' ; break;  /* Icircumflex */
      case 0xd8: c = (byte)'\xcf' ; break;  /* Idiaeresis */
      case 0xdd: c = (byte)'\xa6' ; break;  /* brokenbar */
      case 0xde: c = (byte)'\xcc' ; break;  /* Igrave */
      case 0xe0: c = (byte)'\xd3' ; break;  /* Oacute */
      case 0xe1: c = (byte)'\xdf' ; break;  /* ssharp */
      case 0xe2: c = (byte)'\xd4' ; break;  /* Ocircumflex */
      case 0xe3: c = (byte)'\xd2' ; break;  /* Ograve */
      case 0xe4: c = (byte)'\xf5' ; break;  /* otilde */
      case 0xe5: c = (byte)'\xd5' ; break;  /* Otilde */
      case 0xe6: c = (byte)'\xb5' ; break;  /* mu */
      case 0xe7: c = (byte)'\xfe' ; break;  /* thorn */
      case 0xe8: c = (byte)'\xde' ; break;  /* Thorn */
      case 0xe9: c = (byte)'\xda' ; break;  /* Uacute */
      case 0xea: c = (byte)'\xdb' ; break;  /* Ucircumflex */
      case 0xeb: c = (byte)'\xd9' ; break;  /* Ugrave */
      case 0xec: c = (byte)'\xfd' ; break;  /* yacute */
      case 0xed: c = (byte)'\xdd' ; break;  /* Yacute */
      case 0xee: c = (byte)'\xaf' ; break;  /* macron */
      case 0xef: c = (byte)'\xb4' ; break;  /* acute */
      case 0xf0: c = (byte)'\xad' ; break;  /* hyphen */
      case 0xf1: c = (byte)'\xb1' ; break;  /* plusminus */
      case 0xf3: c = (byte)'\xbe' ; break;  /* threequarters */
      case 0xf4: c = (byte)'\xb6' ; break;  /* paragraph */
      case 0xf5: c = (byte)'\xa7' ; break;  /* section */
      case 0xf6: c = (byte)'\xf7' ; break;  /* division */
      case 0xf7: c = (byte)'\xb8' ; break;  /* cedilla */
      case 0xf8: c = (byte)'\xb0' ; break;  /* degree */
      case 0xf9: c = (byte)'\xa8' ; break;  /* diaeresis */
      case 0xfa: c = (byte)'\xb7' ; break;  /* periodcentered */
      case 0xfb: c = (byte)'\xb9' ; break;  /* onesuperior */
      case 0xfc: c = (byte)'\xb3' ; break;  /* threesuperior */
      case 0xfd: c = (byte)'\xb2' ; break;  /* twosuperior */
      case 0xff: c = (byte)'\xa0' ; break;  /* nobreakspace */
      default  :
	if( mode ) switch(c) { /* my own mappings */
	  case 0x9f: c = (byte)'\x9f' ; break;  /* integral */
	  case 0xb0: c = (byte)'\x80' ; break;  /* lightblock */
	  case 0xb1: c = (byte)'\x81' ; break;  /* mediumblock */
	  case 0xb2: c = (byte)'\x82' ; break;  /* denseblock */
	  case 0xb3: c = (byte)'\x91' ; break;  /* verticalline */
	  case 0xb4: c = (byte)'\x8c' ; break;  /* righttee */
	  case 0xb9: c = (byte)'\x97' ; break;  /* dblrighttee */
	  case 0xba: c = (byte)'\x9c' ; break;  /* dblverticalline */
	  case 0xbb: c = (byte)'\x94' ; break;  /* dblupperrightangle */
	  case 0xbc: c = (byte)'\x9a' ; break;  /* dbllowerrightangle */
	  case 0xbf: c = (byte)'\x89' ; break;  /* upperrightangle */
	  case 0xc0: c = (byte)'\x8d' ; break;  /* lowerleftangle */
	  case 0xc1: c = (byte)'\x8e' ; break;  /* lowertee */
	  case 0xc2: c = (byte)'\x88' ; break;  /* uppertee */
	  case 0xc3: c = (byte)'\x8a' ; break;  /* lefttee */
	  case 0xc4: c = (byte)'\x90' ; break;  /* horicontalline */
	  case 0xc5: c = (byte)'\x8b' ; break;  /* middlecross */
	  case 0xc8: c = (byte)'\x98' ; break;  /* dbllowerleftangle */
	  case 0xc9: c = (byte)'\x92' ; break;  /* dblupperleftangle */
	  case 0xca: c = (byte)'\x99' ; break;  /* dbllowertee */
	  case 0xcb: c = (byte)'\x93' ; break;  /* dbluppertee */
	  case 0xcc: c = (byte)'\x95' ; break;  /* dbllefttee */
	  case 0xcd: c = (byte)'\x9b' ; break;  /* dblhoricontalline */
	  case 0xce: c = (byte)'\x96' ; break;  /* dblmiddlecross */
	  case 0xd5: c = (byte)'\x9e' ; break;  /* alternateonesuperior */
	  case 0xd9: c = (byte)'\x8f' ; break;  /* lowerrightangle */
	  case 0xda: c = (byte)'\x87' ; break;  /* upperleftangle */
	  case 0xdb: c = (byte)'\x83' ; break;  /* fullblock */
	  case 0xdc: c = (byte)'\x84' ; break;  /* upperhalfblock */
	  case 0xdf: c = (byte)'\x85' ; break;  /* lowerhalfblock */
	  case 0xf2: c = (byte)'\x9d' ; break;  /* alternateequalsign */
	  case 0xfe: c = (byte)'\x86' ; break;  /* centeredblock */
	  default: break;
	}
	break;
    }
    return c;
}



/*** bottom of file ***/
