/* [cleanup.c wk 11.4.89] Cleanup Function Handler
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 21.03.95 wk	Added RegisterCleanUp()
 */

#include <wk/tailor.h>
RCSID("$Id: cleanup.c,v 1.9 1996/10/31 14:56:00 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/lib.h>


#ifdef DOCUMENTATION
@Summary AddCleanUp
 #include <wk/lib.h>

 int AddCleanUp( void(*fnc)(void*), void *data );
 void RegisterCleanup( void (*fnc)(void) );
@Description
 Diese Funktion fgt eine neue Funktion der Cleanup prozedur zu.
 Beim ersten Aufruf wird eine Cleanup-Funktion via atexit installiert;
 diese Funktion wird dann alle Cleanupfunktionen der Reihe nach aufrufen.
 Den Cleanupfunktionen kann ein Zeiger auf einen Datenbereich mitgegeben
 werden.
 Es knnen beliebig viele Cleanup funktionen installiert werden; es wird
 via malloc Speicher angefordert. welcher dann als letzte Cleanaktion
 freigegeben wird, Ist kein Speicher mehr vorhanden, so wird via Bug()
 abgebrochen.
 Aufbau einer Cleanup function demnach:

 [static] void Clean_xyz( void *data )
 {

 }

 bzw.
 [static] void Clean_xyz(  )
 {

 }

 Es ist sichergestellt, da Funktionen, die mit RegisterCleanup
 gesetzt wurden nur einmalig gesetzt werden
@Return Value
 Index Nummer der Cleanup funktion.
#endif /*DOCUMENTATION*/


typedef struct t_table {
	struct t_table *next;/* next entry in linked list */
	int index;	     /* index of Function, may be used for removing */
	void (*Fnc)(void*);  /* Cleanup function */
	void *fncData;	     /* data to be passed to function */
    } table_t;

typedef struct t_table2 {
	struct t_table2 *next; /* next entry in linked list */
	void (*Fnc)(void);     /* Cleanup function */
    } table2_t;


static int isInitialized;
static int lastIndex;
static table_t *head;
static table2_t *head2;
static volatile int exitSentinel;
static int exitReturnCode;

static void Cleanup(void);


int
AddCleanUp( void (*NewFnc)(void*), void *fncData )
{
    table_t *item;

    if( exitSentinel )
	return -1;
    /* we have to call a malloc function first, because if we use */
    /* MEM_DEBUG its better to register the atexit() within the memdbg */
    /* function first, so this atexit will be call after this cleanup */
    /* function */
    item = xcalloc( 1, sizeof( table_t ) );
    if( !isInitialized ) {
	atexit( Cleanup );
	isInitialized++;
    }
    /* add at beginning of linked list */
    item->index  = lastIndex++;
    item->Fnc	 = NewFnc;
    item->fncData= fncData;
    if( head )
	item->next = head;
    head = item;
    return item->index;
}


void
RegisterCleanup( void (*NewFnc)(void) )
{
    table2_t *item;

    if( exitSentinel )
	return ;
    for(item=head2; item; item = item->next)
	if( item->Fnc == NewFnc )
	    return;
    /* we have to call a malloc function first, because if we use */
    /* MEM_DEBUG its better to register the atexit() within the memdbg */
    /* function first, so this atexit will be call after this cleanup */
    /* function */
    item = xcalloc( 1, sizeof( table2_t ) );
    if( !isInitialized ) {
	atexit( Cleanup );
	isInitialized++;
    }
    /* add at beginning of linked list */
    item->Fnc	 = NewFnc;
    if( head2 )
	item->next = head2;
    head2 = item;
}


int
WklibInExit( int *ret_rc )
{
    if( ret_rc )
	*ret_rc = exitReturnCode;
    return exitSentinel? 1: 0;
}


static void
Cleanup()
{
    static volatile int sentinel;
    table_t *item, *nxtItem;
    table2_t *item2, *nxtItem2;

    if( !sentinel ) {
	sentinel++;
	for(item2=head2; item2; item2 = nxtItem2) {
	    item2->Fnc();
	    nxtItem2 = item2->next;
	    free( item2 );
	}
	head2 = NULL;
	for(item=head; item; item = nxtItem) {
	    item->Fnc( item->fncData );
	    nxtItem = item->next;
	    free( item );
	}
	head = NULL;
	sentinel--;
    }
}


void
wklib_exit( int rc )
{
    if( exitSentinel ) {
	fputs("\awklib_exit called twice\n", stderr);
	fflush(stderr);
    }
    exitSentinel++;
    exitReturnCode = rc;
  #undef exit
    exit(rc);
  #define exit exit_should_not_be_behind_this_point
    fputs("\aweird: wklib_exit\n", stderr); fflush(stderr);
    abort();
    /*NOTREACHED*/
}



/**** end of file ****/
