/* [byteord.c wk 03.03.94] Byte ordering
 *	Copyright (c) 1988-94 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <wk/tailor.h>
RCSID("$Id: byteord.c,v 1.4 1997/01/07 14:46:35 wk Exp $")
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <wk/byteord.h>



#ifndef WKLIB_BIG_ENDIAN  /* this is simple */

#ifndef __WATCOMC__
ushort wklib_htons(ushort x)
{
    char buf[2], z;

    memcpy(buf, &x, 2);
    z = buf[0];
    buf[0] = buf[1];
    buf[1] = z;
    memcpy( &x, buf, 2 );
    return x;
}
#endif

#if !(defined(__WATCOMC__) && defined(__386__))
ulong wklib_htonl(ulong x)
{
    char buf[4], z;

    memcpy(buf, &x, 4);
    z = buf[0];
    buf[0] = buf[3];
    buf[3] = z;
    z = buf[1];
    buf[1] = buf[2];
    buf[2] = z;
    memcpy( &x, buf, 4 );
    return x;
}
#endif

#endif

/*** bottom of file ****/
